#ifndef CPPCADES_CP_EXTENDED_KEYUSAGE_OBJECT_H_
#define CPPCADES_CP_EXTENDED_KEYUSAGE_OBJECT_H_

#include "CPPCadesCPEKU.h"
#include "CPPCadesCollections.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPExtendedKeyUsageObject
{
public:
    CPPCadesCPExtendedKeyUsageObject(void);
    ~CPPCadesCPExtendedKeyUsageObject(void);

    HRESULT get_IsPresent(BOOL *pVal);
    HRESULT get_IsCritical(BOOL *pVal);
    HRESULT get_EKUs(boost::shared_ptr<CPPCadesCPEKUsObject>& pVal);

    //internal use
    HRESULT put_EKUs(const boost::shared_ptr<CPPCadesCPEKUsObject>& pVal);
    HRESULT put_IsCritical(BOOL pVal);
    HRESULT put_IsPresent(BOOL pVal);
    void clear();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPExtendedKeyUsageObject);

    boost::shared_ptr<CPPCadesCPEKUsObject> m_EKUs;
    BOOL m_isPresent;
    BOOL m_isCritical;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_EXTENDED_KEYUSAGE_OBJECT_H_

