#ifndef CPPCADES_CP_ABOUT_OBJECT_H_
#define CPPCADES_CP_ABOUT_OBJECT_H_

#include "cppcades.h"
#include "CPPVersion.h"
#include "WinCryptEx.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesAboutObject
{
public:
    CPPCadesAboutObject(void);
    ~CPPCadesAboutObject(void);

    HRESULT get_MajorVersion(unsigned int* pVal);
    HRESULT get_MinorVersion(unsigned int* pVal);
    HRESULT get_BuildVersion(unsigned int* pVal);
    HRESULT get_Version(CAtlString& Val);
    HRESULT get_ProviderVersion(CAtlString& version, CAtlString& provName, DWORD dwProvType);
    HRESULT get_CSPVersion(CAtlString& provName, DWORD dwProvType, boost::shared_ptr<CPPVersionObject>& pVersion);
    HRESULT get_CSPName(DWORD dwProvType, CAtlString &retval);
    HRESULT get_PluginVersion(boost::shared_ptr<CPPVersionObject>& pVersion);
    HRESULT ReaderFilter(DWORD EnabledTypes, DWORD EnabledOperations, CAtlStringA& sRegexFilter);
    HRESULT MediaFilter(DWORD MediaType);
        
private:
    CAtlString m_version;
    DWORD m_dwMajorVersion;
    DWORD m_dwMinorVersion;
    DWORD m_dwBuildVersion;
    DISALLOW_COPY_AND_ASSIGN(CPPCadesAboutObject);
    boost::shared_ptr<CPPVersionObject> m_pCSPVersion;
    boost::shared_ptr<CPPVersionObject> m_pPluginVersion;
    CRYPT_CARRIER_TYPES m_cryptCarrierTypes;
    CAtlString m_defaultFilter;
    bool m_cryptCarrierTypesInitialized;
    bool m_cryptUniqueFilterInitialized;
    bool m_defaultFilterExists;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_ABOUT_OBJECT_H_

