#ifndef CPP_ENROLL_ATTRIBUTE_OBJECT_H_
#define CPP_ENROLL_ATTRIBUTE_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"
#include "CPPEnrollCollections.h"
#include "cplib/Blob.h"

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollX509Extensions;
class CPPEnrollX509NameValuePairs;
class CPPEnrollAlternativeNames;

class CPPEnrollX509Attribute
{
public:
    CPPEnrollX509Attribute(void);
    ~CPPEnrollX509Attribute(void);
    HRESULT Initialize(boost::shared_ptr<CPPEnrollObjectId>& pObjectId,
        EncodingType Encoding,
        CAtlString strEncodedData);
    HRESULT get_ObjectId(boost::shared_ptr<CPPEnrollObjectId>& pObjectId);

    // internal only
    BYTE* pbData();
    DWORD cbData();
    HRESULT InitializeFromAttrBlob(
        boost::shared_ptr<CPPEnrollObjectId>& pObjectId,
        PCRYPT_ATTR_BLOB pAttrBlob);

protected:
    CStringBlob m_value;
    CRYPT_ATTR_BLOB m_attrBlob;
    boost::shared_ptr<CPPEnrollObjectId> m_pOid;
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509Attribute);
};

class CPPEnrollX509AttributeExtensions : public CPPEnrollX509Attribute
{
public:
    CPPEnrollX509AttributeExtensions(void);
    ~CPPEnrollX509AttributeExtensions(void);

    HRESULT InitializeEncode(boost::shared_ptr<CPPEnrollX509Extensions>& pExtensions);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509AttributeExtensions);
};

class CPPEnrollX509AttributeNameValuePairs : public CPPEnrollX509Attribute
{
public:
    CPPEnrollX509AttributeNameValuePairs(void);
    ~CPPEnrollX509AttributeNameValuePairs(void);

    HRESULT InitializeEncode(boost::shared_ptr<CPPEnrollX509NameValuePairs>& pNameValuePairs);
    CBlob* getCryptAttrBlobs(DWORD index);
private:
    std::vector<CBlob> m_vecEncodedValues;
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509AttributeNameValuePairs);
};

class CPPEnrollX509AttributeAlternativeNames : public CPPEnrollX509Attribute
{
public:
    CPPEnrollX509AttributeAlternativeNames(void);
    ~CPPEnrollX509AttributeAlternativeNames(void);

    HRESULT InitializeEncode(boost::shared_ptr<CPPEnrollAlternativeNames>& pNameValuePairs);
    CBlob* getCryptAttrBlobs(DWORD index);
private:
    std::vector<CBlob> m_vecEncodedValues;
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509AttributeAlternativeNames);
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_ATTRIBUTE_OBJECT_H_
