<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>


	<!--  OtherSigningCertificate -->
<xsl:template match="OtherSigningCertificate" name="OtherSigningCertificate">

      <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OtherSigningCertificate_header</xsl:with-param> </xsl:call-template>				
      </fo:block>


      <xsl:for-each select="./certs/*">  
	<xsl:call-template name="OtherCertID"/>
      </xsl:for-each>

      <xsl:for-each select="./policies/*">  
	<xsl:call-template name="PolicyInformation"/>
      </xsl:for-each>

</xsl:template>

<!--^-->
	<!--  OtherCertID -->
<xsl:template match="OtherCertID" name="OtherCertID">

      <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OtherCertID_header</xsl:with-param> </xsl:call-template>				
      </fo:block>


      <xsl:for-each select="./otherCertHash">  
	<xsl:call-template name="OtherHash"/>
      </xsl:for-each>

      <xsl:for-each select="./issuerSerial">  
	<xsl:call-template name="IssuerSerial"/>
      </xsl:for-each>

</xsl:template>

<!--^-->
	<!--  OtherHash -->
<xsl:template match="OtherHash" name="OtherHash">

      <xsl:for-each select="./sha1Hash">  
	<xsl:call-template name="OtherHashValue"/>
      </xsl:for-each>

      <xsl:for-each select="./otherHash">  
	<xsl:call-template name="OtherHashAlgAndValue"/>
      </xsl:for-each>

</xsl:template>

<!--^-->
	<!--  OtherHashValue -->
<xsl:template match="OtherHashValue" name="OtherHashValue">
      <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OtherHashValue_header</xsl:with-param> </xsl:call-template>				
      </fo:block>
      <fo:block font-family="Courier New" font-size="10pt"                              
	border-style="solid"
	padding="3pt"
	>
	<xsl:value-of select="."/>
      </fo:block>
</xsl:template>

<!--^-->
	<!--  OtherHashAlgAndValue -->
<xsl:template match="OtherHashAlgAndValue" name="OtherHashAlgAndValue">

      <xsl:for-each select="./hashAlgorithm">  
      <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OtherHashAlgAndValue_hashAlgorithm</xsl:with-param> </xsl:call-template>				
      </fo:block>
	<xsl:call-template name="AlgorithmIdentifier"/>
      </xsl:for-each>

      <xsl:for-each select="./hashValue">  
	<xsl:call-template name="OtherHashValue"/>
      </xsl:for-each>

</xsl:template>

	<!--  SigningCertificate -->
<xsl:template match="SigningCertificate" name="SigningCertificate">

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SigningCertificate_certs</xsl:with-param> </xsl:call-template>				
      <xsl:for-each select="./certs/*">  
	<xsl:call-template name="ESSCertID"/>
      </xsl:for-each>


      <xsl:for-each select="./policies/*">  
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SigningCertificate_policies</xsl:with-param> </xsl:call-template>				
        <fo:block font-family="Courier New" font-size="10pt"
	 border-style="solid"
	 padding="3pt"
	 >
      	 <xsl:for-each select="./*">  
	    <xsl:call-template name="PolicyInformation"/>
      	 </xsl:for-each>
	</fo:block>
      </xsl:for-each>

</xsl:template>

<xsl:template match="SigningCertificateV2" name="SigningCertificateV2">

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SigningCertificate_certs</xsl:with-param> </xsl:call-template>				
      <xsl:for-each select="./certs/ESSCertIDv2">  
	<xsl:call-template name="ESSCertIDv2"/>
      </xsl:for-each>


      <xsl:for-each select="./policies/*">  
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SigningCertificate_policies</xsl:with-param> </xsl:call-template>				
        <fo:block font-family="Courier New" font-size="10pt"
	 border-style="solid"
	 padding="3pt"
	 >
      	 <xsl:for-each select="./*">  
	    <xsl:call-template name="PolicyInformation"/>
      	 </xsl:for-each>
	</fo:block>
      </xsl:for-each>

</xsl:template>

	<!--  EnrollmentCSPInfo -->
<xsl:template match="EnrollmentCSPInfo" name="EnrollmentCSPInfo">

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EnrollmentCSPInfo_header</xsl:with-param> </xsl:call-template>				

      <xsl:for-each select="./provType">  
     	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EnrollmentCSPInfo_provType</xsl:with-param> </xsl:call-template>
	 =
	<xsl:call-template name="ESSCertID"/>
      </xsl:for-each>


   <xsl:for-each select="./name">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EnrollmentCSPInfo_name</xsl:with-param> </xsl:call-template>
     <xsl:value-of select="."/>
   </xsl:for-each>

   <xsl:for-each select="./signature">
     <xsl:call-template name="Signature"/>
   </xsl:for-each>

</xsl:template>

	<!--  DirectoryString -->
<xsl:template match="DirectoryString" name="DirectoryString">

   <xsl:for-each select="./teletexString">  
	<xsl:call-template name="TeletexString"/>
   </xsl:for-each>


   <xsl:for-each select="./printableString">
     <xsl:call-template name="PrintableString"/>
   </xsl:for-each>

   <xsl:for-each select="./universalString">
     <xsl:call-template name="UniversalString"/>
   </xsl:for-each>

   <xsl:for-each select="./bmpString">
     <xsl:call-template name="BMPString"/>
   </xsl:for-each>

   <xsl:for-each select="./utf8String">
     <xsl:call-template name="UTF8String"/>
   </xsl:for-each>

</xsl:template>


	<!--  TeletexString -->
<xsl:template match="TeletexString" name="TeletexString">
   <xsl:value-of select="."/>
</xsl:template>

	<!--  PrintableString -->
<xsl:template match="PrintableString" name="PrintableString">
   <xsl:value-of select="."/>
</xsl:template>

	<!--  UniversalString -->
<xsl:template match="UniversalString" name="UniversalString">
   <xsl:value-of select="."/>
</xsl:template>

	<!--  BMPString -->
<xsl:template match="BMPString" name="BMPString">
   <xsl:value-of select="."/>
</xsl:template>

	<!--  UTF8String -->
<xsl:template match="UTF8String" name="UTF8String">
   <xsl:value-of select="."/>
</xsl:template>

	<!--  PHGString -->
<xsl:template match="PHGString" name="PHGString">
   <xsl:value-of select="."/>
</xsl:template>

</xsl:stylesheet>