<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>


<xsl:template match="DVCSRequest" name="DVCSRequest">


    <fo:block font-family="Times" font-size="14pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      > 
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequest_info</xsl:with-param> </xsl:call-template>
    </fo:block>
     
     <xsl:for-each select="./requestInformation">
	<xsl:call-template name="DVCSRequestInformation"/>
     </xsl:for-each>

  <xsl:for-each select="./transactionIdentifier">  
   <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequest_transactionIdentifier</xsl:with-param> </xsl:call-template>
    </fo:block>


	<!--   -->
   <fo:block font-family="Courier New" font-size="10pt"
     border-style="solid"
     padding="3pt"
     >
	<xsl:call-template name="GeneralName"/>
   </fo:block>
  </xsl:for-each>


    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequest_data</xsl:with-param> </xsl:call-template>
    </fo:block>

     <xsl:for-each select="./data">
	<xsl:call-template name="Data"/>
    </xsl:for-each>

</xsl:template>


	<!--  DVCSRequestInformation -->
<xsl:template match="DVCSRequestInformation" name="DVCSRequestInformation">
    <!--   -->	
    <xsl:for-each select="./version">  
	<xsl:call-template name="INTVersion"/>
    </xsl:for-each>

    <!--    -->	
    <xsl:for-each select="./service">  
	<xsl:call-template name="ServiceType"/>
    </xsl:for-each>

    <!--  Nonce -->	
    <xsl:for-each select="./nonce">  
	<xsl:call-template name="Nonce"/>
    </xsl:for-each>

    <!--    -->	
    <xsl:for-each select="./requestTime">  
    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequestInformation_requestTime</xsl:with-param> </xsl:call-template>
    </fo:block>

	<xsl:call-template name="DVCSTime"/>
    </xsl:for-each>


    <!--    -->	
   <xsl:for-each select="./requester">  
    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequestInformation_requester</xsl:with-param> </xsl:call-template>
    </fo:block>
	<xsl:call-template name="GeneralNames"/>
    </xsl:for-each>




    <!--    -->	
    <xsl:for-each select="./requestPolicy">  
    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequestInformation_requestPolicy</xsl:with-param> </xsl:call-template>
    </fo:block>
	<xsl:call-template name="PolicyInformation"/>
    </xsl:for-each>




    <!--    -->	
    <xsl:for-each select="./dvcs">  
    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequestInformation_dvcs</xsl:with-param> </xsl:call-template>
    </fo:block>
	<xsl:call-template name="GeneralNames"/>
    </xsl:for-each>


    <!--    -->	
    <xsl:for-each select="./dataLocations">  
    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequestInformation_dataLocations</xsl:with-param> </xsl:call-template>
    </fo:block>
	<xsl:call-template name="GeneralNames"/>
    </xsl:for-each>


     <xsl:for-each select="./extensions">  
	  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequestInformation_extensions</xsl:with-param> </xsl:call-template>				
	  </fo:block>

		<!--   -->
	  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >
	    <xsl:call-template name="Extensions"/>
          </fo:block>
    </xsl:for-each>
</xsl:template>


	<!--  DataCerts -->
<xsl:template match="DataCerts" name="DataCerts">
 	  <xsl:for-each select="./*">  
		<xsl:call-template name="TargetEtcChain"/>
	  </xsl:for-each>
</xsl:template>


	<!--   -->
<xsl:template match="Data" name="Data">

	  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Data_header</xsl:with-param> </xsl:call-template>				
	  </fo:block>

		<!--   -->
	  <fo:block font-family="Courier New" font-size="10pt"                              
	    border-style="solid"
	    padding="3pt"
	    >

	    <xsl:call-template name="split">
	      <xsl:with-param name="val">
		<xsl:value-of select="message"/>
	      </xsl:with-param>
	    </xsl:call-template>

          </fo:block>

 	  <xsl:for-each select="./messageImprint">  
		<xsl:call-template name="DigestInfo"/>
	  </xsl:for-each>

 	  <xsl:for-each select="./certs">  
		<xsl:call-template name="DataCerts"/>
	  </xsl:for-each>

</xsl:template>


	<!--  DigestInfo -->

	<!--  DVCSTime -->
<xsl:template match="DVCSTime" name="DVCSTime">

    <!--    -->	
    <xsl:for-each select="./genTime">  
	<xsl:call-template name="GeneralizedTime"/>
    </xsl:for-each>


    <!--    -->	
    <xsl:for-each select="./timeStampToken">  
	<xsl:call-template name="TimeStampToken"/>
    </xsl:for-each>

</xsl:template>

	<!--  ServiceType -->
<xsl:template match="ServiceType" name="ServiceType">
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ServiceType_header</xsl:with-param> </xsl:call-template>

    	      <xsl:for-each select="./cpd">
	      	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ServiceType_cpd</xsl:with-param> </xsl:call-template>
	      </xsl:for-each>

    	      <xsl:for-each select="./ccpd">
	      	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ServiceType_ccpd</xsl:with-param> </xsl:call-template>
	      </xsl:for-each>

    	      <xsl:for-each select="./vpkc">
	      	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ServiceType_vpkc</xsl:with-param> </xsl:call-template>
	      </xsl:for-each>

    	      <xsl:for-each select="./vsd">
	      	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ServiceType_vsd</xsl:with-param> </xsl:call-template>
	      </xsl:for-each>

</xsl:template>


	<!--  TargetEtcChain -->
<xsl:template match="TargetEtcChain" name="TargetEtcChain">


    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TargetEtcChain_target</xsl:with-param> </xsl:call-template>
    </fo:block>

    <xsl:for-each select="./target">  
	<xsl:call-template name="CertEtcToken"/>
    </xsl:for-each>

    <xsl:for-each select="./chain">  
	<xsl:call-template name="CertEtcToken"/>
    </xsl:for-each>

    <xsl:for-each select="./pathProcInput">  
	<xsl:call-template name="PathProcInput"/>
    </xsl:for-each>

</xsl:template>

	<!--  PathProcInput -->


	<!--  CertEtcToken -->
<xsl:template match="CertEtcToken" name="CertEtcToken">

      <xsl:for-each select="./certificate">  
        <xsl:for-each select="./tbsCertificate">  
	    <xsl:call-template name="TBSCertificate"/>
        </xsl:for-each>
	<!-- <xsl:apply-templates select="."/> -->
      </xsl:for-each>

      <xsl:for-each select="./esscertid">  
	<xsl:call-template name="ESSCertID"/>
      </xsl:for-each>

      <xsl:for-each select="./pkistatus">  
	<xsl:call-template name="PKIStatusInfo"/>
      </xsl:for-each>

      <xsl:for-each select="./assertion">  
	<xsl:call-template name="ContentInfo"/>
      </xsl:for-each>

      <xsl:for-each select="./crl">  
	<xsl:call-template name="CertificateList"/>
      </xsl:for-each>

      <xsl:for-each select="./ocspcertstatus">  
	<xsl:call-template name="CertStatus"/>
      </xsl:for-each>

      <xsl:for-each select="./oscpcertid">  
	<xsl:call-template name="CertID"/>
      </xsl:for-each>

      <xsl:for-each select="./oscpresponse">  
	<xsl:call-template name="OCSPResponse"/>
      </xsl:for-each>

      <xsl:for-each select="./capabilities">  
	<xsl:call-template name="SMIMECapabilities"/>
      </xsl:for-each>


	<!--   -->
     <xsl:for-each select="./extensions">  
	  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertEtcToken_extensions</xsl:with-param> </xsl:call-template>				
	  </fo:block>

		<!--   -->
	  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >
	    <xsl:call-template name="Extensions"/>
          </fo:block>
    </xsl:for-each>


</xsl:template>

</xsl:stylesheet>
