/*
 * Copyright(C) 2008  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 125330 $
 * \date $Date:: 2015-08-06 15:08:41 +0300#$
 * \author $Author: dim $
 * \brief   
 */

#include "ric_prj.h" 

static DWORD trust_check_file_presence( 
    TSupSysContext *context, 
    TCHAR folder )
{
    TRICContext *ctx = (TRICContext*)context;
    BYTE apdu[] = { 0x00, 0xa4, 0x00, 0x0c };
    unsigned char data[2];
    DWORD code;
    unsigned short id;

    SUPSYS_PRE_CONTEXT( context, TRICContext );

	id = (unsigned short)(0x101+(unsigned char)((folder-'A')*0x10));

    data[0]=(unsigned char)(id>>8);
    data[1]=(unsigned char)(id&0x00ff);

    code = send_apdu( ctx, apdu, data, 2, NULL, NULL );
    if( code )
	return code;
    return ERROR_SUCCESS;
}

typedef struct TTrustFolderEnumOwn_ {
    const TCHAR *folders; /*!<   folders */
    const TCHAR *cur_folder; /*!<      folder. */
} TTrustFolderEnumOwn;

typedef struct TTrustFolderEnumCtx_ {
    int own; /*!< !0,   PCSC, 0  
	. */
    union {
	TSupSysInfoUntyped untyped;  /*!<   
	  . */
	TTrustFolderEnumOwn own; /*!<   
	  PC/SC. */
    } both;
} TTrustFolderEnumCtx;

/*! 
 * \ingroup trust_fun_general
 * \brief    
 * \param context [in]  . 
 * \param info [out]  #TReaderInfoFolderEnum
 * \sa TReaderInfoFolderEnum, READER_FUN_FOLDER_ENUM_OPEN, 
 * \return  .
 */
DWORD trust_folder_enum_open(
    TSupSysContext *context, 
    TSupSysInfo *info)
{
    TTrustFolderEnumCtx *both;
    TReaderInfoFolderEnum *inf = (TReaderInfoFolderEnum*)info;
    TRICContext *ctx = (TRICContext*)context;

    SUPSYS_PRE_INFO(info, TReaderInfoFolderEnum);
    SUPSYS_PRE_CCONTEXT(context, TRICContext);
    inf->add_info.length = 0;
    inf->add_info.info = NULL;

	//   ,   "A"  "B" TODO:      
    both = malloc(sizeof(*both));
    if(!both)
	return (DWORD)NTE_NO_MEMORY;
    both->own = 1;
    both->both.own.folders = _TEXT("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    both->both.own.cur_folder = both->both.own.folders;
    inf->name.length = 2;   //   

    inf->add_info.length = sizeof(*both);
    inf->add_info.info = (unsigned char*)both;

    return trust_select_application(ctx);
}

/*! 
 * \ingroup pcsc_fun_general
 * \brief     
 * \param context [in]  . 
 * \param info [out]  #TReaderInfoFolderEnum
 * \sa TReaderInfoFolderEnum, READER_FUN_FOLDER_ENUM_NEXT, 
 * \return  .
 */
DWORD trust_folder_enum_next(
    TSupSysContext *context,
    TSupSysInfo *info) {
    DWORD code;
    TReaderInfoFolderEnum *inf = (TReaderInfoFolderEnum*)info;
    TTrustFolderEnumCtx *both;

    SUPSYS_PRE_INFO(info, TReaderInfoFolderEnum);
    SUPSYS_PRE_CCONTEXT(context, TRICContext);
    SUPSYS_PRE(inf->add_info.info);
    SUPSYS_PRE_READ_PTRS(inf->add_info.info, inf->add_info.length);

    both = (TTrustFolderEnumCtx*)inf->add_info.info;

    // ,   "A"  "B" TODO:      
    if (!both->own || 0 == *both->both.own.cur_folder) {
	return (DWORD)ERROR_FILE_NOT_FOUND;
    }
    code = ERROR_SUCCESS;
    if (NULL != inf->name.text) {
	if (1 <= inf->name.length) {
	    inf->name.text[0] = *both->both.own.cur_folder++;
	    inf->name.text[1] = 0;
	    inf->name.length = 2;
	    code = trust_check_file_presence(context, inf->name.text[0]);
	    if (code == (DWORD)ERROR_FILE_NOT_FOUND) {
		code = trust_select_application(context);
		if (code)
		    return code;
		code = trust_check_file_presence(context, inf->name.text[0]);
	    }
	}
	else {
	    inf->name.text[0] = 0;
	    inf->name.length = 0;
	    code = (DWORD)ERROR_INVALID_PARAMETER;	// TODO: MORE_DATA
	}
    }
    else {
	inf->name.length = 2;	//      
    }
    return code;
}

/*! 
 * \ingroup pcsc_fun_general
 * \brief    
 * \param context [in]  . 
 * \param info [out]  #TReaderInfoFolderEnum
 * \sa TReaderInfoFolderEnum, READER_FUN_FOLDER_ENUM_CLOSE, 
 * \return  .
 */
DWORD trust_folder_enum_close(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TTrustFolderEnumCtx *both;
    TReaderInfoFolderEnum *inf = (TReaderInfoFolderEnum*)info;

    SUPSYS_PRE_INFO(info, TReaderInfoFolderEnum);
    SUPSYS_PRE_CCONTEXT(context, TRICContext);
    SUPSYS_PRE(inf->add_info.info);
    SUPSYS_PRE_READ_PTRS(inf->add_info.info, inf->add_info.length);

    both = (TTrustFolderEnumCtx*)inf->add_info.info;
    both->own = 0;
    free(both);
    return ERROR_SUCCESS;
}
