/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/****
 * $Id: f12istat.c 206422 2020-02-10 13:50:43Z frolov $
 *
 *       (READER).
 *
 *   /      (FAT12).
 *
 *      .
 *   info-.
 *
 * : FAT12_INFO_SUPPORT
 ****/

#include "fat12prj.h"
#include "reader.kit/rdr_ver.h"

/*+   info-. +*/
static const TSupSysFunctionTableItem fat12_funs[] =
{
    { SUPSYS_FUN_NICKNAME, fat12_info_nickname },
    { SUPSYS_FUN_NAME, fat12_info_name },
    { SUPSYS_FUN_INSTANCE, fat12_info_instance },
    { SUPSYS_FUN_CONTEXT_DUP, fat12_context_dup },
    { SUPSYS_FUN_CONTEXT_FREE, fat12_context_free },
    { SUPSYS_FUN_FLAGS, fat12_info_system_flag },
#ifndef UNIX
    { SUPSYS_FUN_CALL, fat12_aux_call },
#endif
    { SUPSYS_FUN_VERSIONSUPPORT, info_versionsupport},
    { SUPSYS_FUN_REGISTER, fat12_register },
    { SUPSYS_FUN_UNREGISTER, fat12_unregister },
    { SUPSYS_FUN_CONNECT, fat12_connect },
    { SUPSYS_FUN_DISCONNECT, fat12_disconnect },

#ifdef UNIX
    { READER_FUN_LOCK, fat12_lock },
    { READER_FUN_UNLOCK, fat12_unlock },
#endif //UNIX

    { READER_FUN_CONNECT_CARRIER, fat12_connect_carrier },
    { READER_FUN_DISCONNECT_CARRIER, fat12_disconnect_carrier },
    
    { READER_FUN_GET_PARAM, fat12_get_param },
    { READER_FUN_PASSWORD_TYPE, fat12_get_password_type },
    { READER_FUN_GET_APPLET_TEXT_INFO, fat12_get_text_info },

#ifndef UNIX
    { READER_FUN_UNIQUE_GET, fat12_unique_get },
#endif /* UNIX */

#ifndef _WIN32
    { READER_FUN_FOLDER_ENUM_OPEN, fat12_info_locked_folder_enum_open },
    { READER_FUN_FOLDER_ENUM_NEXT, fat12_info_locked_folder_enum_next },
    { READER_FUN_FOLDER_ENUM_CLOSE, fat12_info_locked_folder_enum_close },
#else
    { READER_FUN_FOLDER_ENUM_OPEN, fat12_info_folder_enum_open },
    { READER_FUN_FOLDER_ENUM_NEXT, fat12_info_folder_enum_next },
    { READER_FUN_FOLDER_ENUM_CLOSE, fat12_info_folder_enum_close },
#endif
    { READER_FUN_FOLDER_OPEN, fat12_folder_open },
    { READER_FUN_FOLDER_CLOSE, fat12_folder_close },

#ifdef _WIN32
    { READER_FUN_SEC_DESCR_READ, fat12_folder_get_sdecr },
#endif //_WIN32
    
    { READER_FUN_FOLDER_CLEAR, fat12_folder_clear },
    { READER_FUN_OPEN, fat12_open },
    { READER_FUN_CLOSE, fat12_close },
    { READER_FUN_UNLINK, fat12_unlink },

#ifdef _WIN32
    { READER_FUN_SEC_DESCR_WRITE, fat12_folder_put_sdecr },
#endif //_WIN32

    { READER_FUN_READ, fat12_read },
    { READER_FUN_WRITE, fat12_write },
    { READER_FUN_CHSIZE, fat12_chsize },
    { READER_FUN_LENGTH, fat12_length },
    { READER_FUN_GET_FREE_SPACE, fat12_free_space },
};

static const TSupSysFunctionTableItem FAT12_GROUP_FUNS[] =
{
    { SUPSYS_FUN_INSTANCE, fat12_info_instance },
    { SUPSYS_FUN_FLAGS, fat12_group_info_system_flag },
    { SUPSYS_FUN_GROUP_ENUM_OPEN, fat12_group_enum_open },
    { SUPSYS_FUN_GROUP_ENUM_NEXT, fat12_group_enum_next },
    { SUPSYS_FUN_GROUP_ENUM_CLOSE, fat12_group_enum_close },
    { SUPSYS_FUN_VERSIONSUPPORT, info_versionsupport},
};

static const TSupSysFunctionTable FAT12_GROUP_TABLE =
{
    sizeof( FAT12_GROUP_FUNS ) / sizeof( TSupSysFunctionTableItem ),
    FAT12_GROUP_FUNS
};

static const TSupSysFunctionTable fat12_table =
{
    sizeof( fat12_funs ) / sizeof( TSupSysFunctionTableItem ),
    fat12_funs
};

const TSupSysEHandle *fat12_reader_get_table( void )
{
    return (const TSupSysEHandle*)&fat12_table;
}

const TSupSysEHandle *
fat12_reader_get_group_table( void )
{
    return (const TSupSysEHandle*)&FAT12_GROUP_TABLE;
}
