/*
 * Copyright(C) 2008  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 * \brief   .
 */

#include "ric_prj.h"
#include "limits.h" 

/*!
 * \brief   .
 */
DWORD trust_select_file( 
    TRICContext *ctx,
    unsigned char file_id, 
    size_t *length )
{
    BYTE apdu_sel[] = { 0x00, 0xa4, 0x00, 0x04 };
    unsigned char data[2],data_out[256];
    DWORD code;
    unsigned short id;
    size_t out_len = sizeof (data_out);

    *length = 0xffff;

    if( file_id >= UCHAR_MAX )
	return (DWORD)ERROR_FILE_NOT_FOUND;
    if (file_id<7)
	id = (unsigned short) ( file_id + ctx->application );
    else
	id = (unsigned short) ( file_id + 0x100 );
    if (id<0x100) id+=0x100;

    data[0]=(unsigned char)(id>>8);
    data[1]=(unsigned char)(id&0x00ff);
	
    code = send_apdu( ctx, apdu_sel, data, 2, data_out, &out_len );
    if( code )
	return code;

    switch (data_out[3]) {
    case 1:
	*length=(size_t)data_out[4];
	break;
    case 2:
	*length=(size_t)((data_out[4]<<8)+data_out[5]);
	break;
    default:
	return (DWORD)SCARD_W_UNSUPPORTED_CARD;
    }

    return ERROR_SUCCESS;
}

/*!
 * \brief   .
 */
DWORD trust_select_application( 
    TRICContext *ctx )
{
    BYTE apdu_sel[] = { 0x00, 0xa4, 0x04, 0x0c };
  
    //   '\0'
    return send_apdu( ctx, apdu_sel, (BYTE*) "CPCSP", 5, NULL, NULL );
}
/* end of file: $Id: mag_sf.c 127051 2015-09-09 12:08:20Z pav $ */
