/*
 * Copyright(C) 2008  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \brief    Challenge/Responce.
 */

#include "rdr_prj.h"
static const size_t g_el_point_indexes_amount = 4;

DWORD rdr_get_password_info(const TSupSysEContext *context, DWORD auth_type, size_t * min_password_length, size_t * max_password_length, size_t * retries, BOOL * isUtf8) {
    DWORD code;
    TReaderInfoAuthInfo info;
    SUPSYS_PRE(context);
    SUPSYS_PRE_WRITE_PTR(min_password_length);
    SUPSYS_PRE_WRITE_PTR(max_password_length);
    SUPSYS_PRE_WRITE_PTR(retries);
    memset(&info, 0, sizeof(TReaderInfoAuthInfo));
    info.auth_type = auth_type;
    info.info.info_pwd.password_encoding = TReaderInfoPwdEncoding_default;

    code = supsys_call(context, READER_FUN_AUTH_INFO, &info);
    if (code)
	LOGRETURN(code);
    SUPSYS_PRE(info.info.info_pwd.min_pwd_length <= info.info.info_pwd.max_pwd_length
	&& info.auth_type == auth_type);

    //  sespake   
    *min_password_length = info.info.info_pwd.min_pwd_length;
    *max_password_length = info.info.info_pwd.max_pwd_length;
    *retries = (size_t)info.info.info_pwd.uiRetries;
    *isUtf8 = (info.info.info_pwd.password_encoding == TReaderInfoPwdEncoding_UTF8);
    LOGRETURN(0);
}

DWORD rdr_get_sespake_full(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcEllipticPointParam * auth_id, TRdrFkcRndm12 salt, BYTE * ind, BOOL * dont_use_mq, BOOL * prehash_password)
{
    DWORD code;
    TReaderInfoAuthInfo info = { 0 };
    SUPSYS_PRE(context);
    SUPSYS_PRE_WRITE_PTR(auth_id);
    SUPSYS_PRE_WRITE_PTR(ind);

    info.auth_type = auth_type;
    info.info.info_sespake.flags = 1 | 2 | 8;
    info.info.info_sespake.salt = salt;
    info.info.info_sespake.dont_use_mq = FALSE;
    info.info.info_sespake.prehash_password = FALSE;

    code = supsys_call(context, READER_FUN_AUTH_INFO, &info);
    if (code)
	LOGRETURN(code);
    SUPSYS_PRE(info.info.info_sespake.group_id <= RDR_FKC_IDG_CP_PARAM_END);
    SUPSYS_PRE(info.info.info_sespake.ind <= g_el_point_indexes_amount);
    *auth_id = info.info.info_sespake.group_id;
    *ind = info.info.info_sespake.ind;
    *prehash_password = info.info.info_sespake.prehash_password;
    *dont_use_mq = info.info.info_sespake.dont_use_mq;
    LOGRETURN(code);
}

DWORD rdr_set_sespake_full(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcEllipticPointParam auth_id, TRdrFkcRndm12 salt, BYTE ind, TRdrFkcPoint * Qpw)
{
    TReaderInfoAuthInfo info = { 0 };
    SUPSYS_PRE(context);
    SUPSYS_PRE_READ_PTR(salt);
    SUPSYS_PRE_READ_PTR(Qpw);


    info.auth_type = auth_type;
    info.info.info_sespake.flags = 1 | 2 | 4;
    info.info.info_sespake.salt = salt;
    info.info.info_sespake.Qpw = Qpw;
    info.info.info_sespake.group_id = auth_id;
    info.info.info_sespake.ind = ind;

    LOGRETURN(supsys_call(context, READER_FUN_SET_AUTH_INFO, &info));
}

DWORD rdr_sespake_first_step(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcTrID transaction_id, TRdrFkcPoint * u1, TRdrFkcPoint *u2)
{
    SUPSYS_PRE(context);
    SUPSYS_PRE_READ_PTR(u1);
    SUPSYS_PRE_READ_PTR(u2);
    TReaderInfoAuthChallenge chal;
    chal.auth_type = auth_type;
    chal.transaction_id = transaction_id;
    chal.challenge_class = TRECc_first;
    memset(&chal.to_CSP, 0, sizeof(TReaderSespakeChallenge2csp));
    chal.to_FKC.first.u1 = u1;
    chal.to_CSP.first.u2 = u2;
    LOGRETURN(supsys_call(context, READER_FUN_AUTH_CHALLENGE, &chal));
}

DWORD rdr_sespake_second_step(TSupSysEContext *context, TRdrLoginInfoType auth_type, TRdrFkcTrID transaction_id, BYTE * hmacA, BYTE * hmacB)
{
    DWORD code;
    TReaderInfoAuthChallenge chal = { 0 };
    SUPSYS_PRE(context);
    SUPSYS_PRE(hmacA);
    SUPSYS_PRE(hmacB);
    chal.auth_type = auth_type;
    chal.transaction_id = transaction_id;
    chal.challenge_class = TRECc_second;
    chal.to_FKC.second_12.hmacA = hmacA;
    chal.to_CSP.second_12.hmacB = hmacB;
    code = supsys_call(context, READER_FUN_AUTH_CHALLENGE, &chal);
    LOGRETURN(code);
}

/* end of file: $Id: rchl.c 67070 2011-03-22 15:46:36Z borodin $ */
