/*
 * Copyright(C) 2007  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

 /*!
  * \file $RCSfile$
  * \version $Revision: 246196 $
  * \date $Date:: 2022-08-30 14:58:29 +0300#$
  * \author $Author: borodin $
  * \brief     .
  */

#include "fat12prj.h"
#define N_ELEM(arr) sizeof((arr))/sizeof((arr)[0])

static DWORD some_info_name(TSupSysContext *context, TSupSysInfo *info, size_t ids)
{
    TSupSysInfoText *inf = (TSupSysInfoText*)info;
    TFat12Context *ctx = (TFat12Context*)context;
    SUPSYS_PRE_INFO(info, TSupSysInfoText);
    SUPSYS_PRE_CCONTEXT(context, TFat12Context);
    SUPSYS_PRE(ctx->connect);

    if (inf->length)
	SUPSYS_PRE_WRITE_PTRS(inf->text, (inf->length + 1) * sizeof(TCHAR));

    TCHAR temp_buf[MAX_PATH + 1]; //   . MAX_PATH   . 
    size_t resource_len = N_ELEM(temp_buf) - 1; //  1 ,   .

    DWORD code = support_resource_string(FAT12_RESOURCE, ids, temp_buf, &resource_len);
    if (ERROR_SUCCESS != code)
	return code;

    size_t full_name_len = resource_len + 1 + _tcslen(ctx->connect);
    if (full_name_len > N_ELEM(temp_buf) - 1) { // ,        temp_buf
	return (DWORD)NTE_FAIL; // -     +    ,   .    .
    }
    if (NULL == inf->text) {
	inf->length = full_name_len;
	return ERROR_SUCCESS;
    }

    if (inf->length < full_name_len) {
	inf->length = full_name_len;
	return (DWORD)ERROR_MORE_DATA;
    }

    //       +  
    temp_buf[resource_len] = _TEXT('\0'); //    .      
    _tcscat(temp_buf, _TEXT(" "));
    _tcscat(temp_buf, ctx->connect);

    _tcscpy(inf->text, temp_buf);
    inf->length = full_name_len;
    return ERROR_SUCCESS;
}

DWORD dir_info_name(
    TSupSysContext *context, TSupSysInfo *info)
{
    return some_info_name(context, info, IDS_DIR_NAME);
}

DWORD fat12_info_name(
    TSupSysContext *context, TSupSysInfo *info)
{
    return some_info_name(context, info, IDS_FAT12_NAME);
}

DWORD dir_info_group_name(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoText *inf = (TSupSysInfoText*)info;
    SUPSYS_PRE_INFO(info, TSupSysInfoText);
    UNUSED(context);

    if (inf->length)
	SUPSYS_PRE_WRITE_PTRS(inf->text, (inf->length + 1) * sizeof(TCHAR));

    TCHAR temp_buf[MAX_PATH + 1]; //   . MAX_PATH   . 
    size_t resource_len = N_ELEM(temp_buf) - 1; //  1 ,   .

    DWORD code = support_resource_string(FAT12_RESOURCE, IDS_DIR_GROUP_NAME, temp_buf, &resource_len);
    if (ERROR_SUCCESS != code)
	return code;

    if (NULL == inf->text) {
	inf->length = resource_len;
	return ERROR_SUCCESS;
    }

    if (inf->length < resource_len) {
	inf->length = resource_len;
	return (DWORD)ERROR_MORE_DATA;
    }

    _tcscpy(inf->text, temp_buf);
    inf->length = resource_len;
    return ERROR_SUCCESS;

}

