/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2013  
 *
 *    , 
 *    .
 *
 *         
 *  ,     ,    , 
 *    : 
 *   1.        
 *           ,   
 *           . 
 *   2.        
 *           ,   
 *              / 
 *        ,   . 
 * 
 *        
 * /   "  "  -  , 
 *    , ,    , 
 *        
 *  .    ,     
 * ,      ,     
 *      ,    /  
 *  ,    ,  Ѩ 
 * ,   , ,   
 *  ,      
 *   (,     , 
 *  ,  ,    - 
 *    ,       
 *  ),         
 *     
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 59519 $
 * \date $Date: 2010-01-13 15:36:15 +0300 (Wed, 13 Jan 2010) $
 * \author $Author: dedal $
 *
 * \brief      
 * " KTLS"  Unix
 *

 */
#ifndef _WCKERNELPART_H__
#define _WCKERNELPART_H__
#ifdef KSP_LITE
#include "KTLS.h"
#ifndef KRN_EMUL
#include <linux/compat.h>
#endif
#else
#include "UTLS.h"
#endif
#include <linux/kernel.h>
#include <asm/ioctl.h>

typedef struct {
    unsigned cbBuffer;
    void * pvBuffer;
} DRTKTLS_EXCHANGE, *PDRTKTLS_EXCHANGE;
typedef struct {
    int Socket;
    DRTKTLS_EXCHANGE Extra;
} DRTKTLS_PROCESS, *PDRTKTLS_PROCESS;
/*
 * commands for drtktls_ioctl
 */
# define DRTKTLS_I		'q'
# define DRTKTLS_RNG		_IOW(DRTKTLS_I,1,PDRTKTLS_EXCHANGE)
# define DRTKTLS_CREATE_SA	_IO(DRTKTLS_I,2)
# define DRTKTLS_EXPORT_SA	_IOW(DRTKTLS_I,3,PDRTKTLS_EXCHANGE)
# define DRTKTLS_IMPORT_SA	_IOW(DRTKTLS_I,4,PDRTKTLS_EXCHANGE)
# define DRTKTLS_EXPORT_CONTEXT	_IOR(DRTKTLS_I,5,PDRTKTLS_EXCHANGE)
# define DRTKTLS_IMPORT_CONTEXT	_IOW(DRTKTLS_I,6,PDRTKTLS_EXCHANGE)
# define DRTKTLS_PROCESS_DATA   _IOWR(DRTKTLS_I,7,PDRTKTLS_PROCESS)
# define DRTKTLS_SET_STACK   _IO(DRTKTLS_I,7)
# define DRTKTLS_GET_STACK   _IOR(DRTKTLS_I,8,int*)

#if SIZEOF_VOID_P == 8 && defined(KSP_LITE) && !defined(KRN_EMUL)
typedef struct {
    unsigned cbBuffer;
    compat_uptr_t cpvBuffer;
} COMPAT_DRTKTLS_EXCHANGE, *PCOMPAT_DRTKTLS_EXCHANGE;
typedef struct {
    int Socket;
    COMPAT_DRTKTLS_EXCHANGE Extra;
} COMPAT_DRTKTLS_PROCESS, *PCOMPAT_DRTKTLS_PROCESS;

# define DRTKTLS_RNG32		_IOW(DRTKTLS_I,1,compat_uptr_t)
//# define DRTKTLS_CREATE_SA32	_IO(DRTKTLS_I,2)
# define DRTKTLS_EXPORT_SA32	_IOW(DRTKTLS_I,3,compat_uptr_t)
# define DRTKTLS_IMPORT_SA32	_IOW(DRTKTLS_I,4,compat_uptr_t)
# define DRTKTLS_EXPORT_CONTEXT32	_IOR(DRTKTLS_I,5,compat_uptr_t)
# define DRTKTLS_IMPORT_CONTEXT32	_IOW(DRTKTLS_I,6,compat_uptr_t)
# define DRTKTLS_PROCESS_DATA32   _IOWR(DRTKTLS_I,7,compat_uptr_t)

#endif

struct _DRTKTLS_CTX_;
struct _DRTKTLS_DRV_;
typedef struct _DRTKTLS_CTX_ DRTKTLS_CTX, *PDRTKTLS_CTX;    
typedef struct _DRTKTLS_DRV_ DRTKTLS_DRV, *PDRTKTLS_DRV;    
SECURITY_STATUS CAPI_EXTC kinit_gost(PDRTKTLS_DRV pDrv, unsigned * pSize);
SECURITY_STATUS CAPI_EXTC kdone_gost(PDRTKTLS_DRV pDrv);
SECURITY_STATUS CAPI_EXTC kset_rng(PDRTKTLS_DRV pDrv, unsigned char * pbData,unsigned cbData);
SECURITY_STATUS CAPI_EXTC kcreate_SA(PDRTKTLS_DRV pDrv);
SECURITY_STATUS CAPI_EXTC kexport_SA(PDRTKTLS_DRV pDrv,unsigned char * pbBuffer,unsigned * puLen);
SECURITY_STATUS CAPI_EXTC kimport_SA(PDRTKTLS_CTX pDCtx, unsigned char * pbSA,unsigned cbSA);
SECURITY_STATUS CAPI_EXTC kinit_ctx(PDRTKTLS_DRV pDrv,PDRTKTLS_CTX pDCtx, unsigned * pSize);
SECURITY_STATUS CAPI_EXTC kimport_keys(PDRTKTLS_CTX pDCtx,void * pvExpDCtx, unsigned cbExpDCtx);
SECURITY_STATUS CAPI_EXTC kexport_keys(PDRTKTLS_CTX pDCtx, void * pvExpDCtx, unsigned *pcbExpDCtx);
SECURITY_STATUS CAPI_EXTC kreadall(PDRTKTLS_CTX pDCtx, int Socket, void * pvExtra, unsigned * pcbExtra);
SECURITY_STATUS CAPI_EXTC kdone_ctx(PDRTKTLS_CTX pDrv);
#endif
