/*
 * Copyright(C) 2000-2010  
 *
 *    , 
 *   .
 *
 *  ,    , 
 *         
 *   .
 *
 *     
 *     .
 */


#include <stdio.h>
 
#ifdef _WIN32

#ifdef _DEBUG
# pragma comment(lib, "comsuppwd.lib")
#else
# pragma comment(lib, ";omsuppw.lib")
#endif
  #include <comutil.h>
  #include <windows.h>
  #include <wincrypt.h>
  #include <wincryptex.h>
#else
  #include <string.h>
  #include <stdlib.h>
  #include <stdio.h>
  #include <WinCryptEx.h>
#endif	// _WIN32
#include "UnixEnroll.h"
#define TYPE_DER (X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)

//--------------------------------------------------------------------
//       

//         
// AT_KEYEXCHANGE   Test(Unix)    (WIN),
//      CryptAcquireContext.
//--------------------------------------------------------------------


static void HandleError(const char *s);


#ifdef _WIN32
#   define CONTAINER L"test"
#else
#   define CONTAINER L"\\\\.\\HDIMAGE\\test"
#endif

class Callbacks: public UnixEnroll::UserCallbacks
{
public:
	bool askPermissionToAddToRootStore( const BYTE* pbCert, DWORD cbCert, bool force = false) const;
	UserCallbacks* clone() const;
	virtual ~Callbacks() {}
};

//--------------------------------------------------------------------
//  askPermissionToAddToRootStore   

bool Callbacks::askPermissionToAddToRootStore( const BYTE* pbCert, DWORD cbCert, bool) const
{
    UNUSED(pbCert);
    UNUSED(cbCert);
    return true;
}

UnixEnroll::UserCallbacks* Callbacks::clone() const
{
	return new Callbacks();
}

//       HandleError,  
//   ,         
//   (stderr) 
//         , 
//        .

void HandleError(const char *s)
{
	DWORD err = GetLastError();
	printf("Error number     : 0x%x\n", err);
	printf("Error description: %s\n", s);
	if(!err) err = 1;
	exit(err);
} 	

static long create_request(BSTR bstrRDN, BSTR bstrEKUsage, BSTR contName, char** chTmp)
{
	HRESULT res = -1;
	Callbacks tb;
    	
	DWORD dwKeySpec = AT_KEYEXCHANGE;
	BSTR strRequest = 0;
	UnixEnroll * pEnroll = new UnixEnroll(tb, false);

	//------------------------------------------------------------------------------------
	// put_ContainerName   
	pEnroll->put_ContainerName(contName);
	//------------------------------------------------------------------------------------
	// put_LimitExchangeKeyToEncipherment    AT_KEYEXCHANGE, false
	//  ,  , true -  
	pEnroll->put_LimitExchangeKeyToEncipherment(TRUE);
	//------------------------------------------------------------------------------------
	// put_KeySpec    
	pEnroll->put_KeySpec(dwKeySpec);
	//------------------------------------------------------------------------------------
	// put_ProviderType   CSP   .
	pEnroll->put_ProviderType(PROV_GOST_2001_DH);
	//------------------------------------------------------------------------------------
	// put_RequestStoreFlags       .
	pEnroll->put_RequestStoreFlags(CERT_SYSTEM_STORE_CURRENT_USER);
	//------------------------------------------------------------------------------------
	//     createRequest
	res = pEnroll->createRequest(XECR_PKCS10_V2_0, bstrRDN, bstrEKUsage, &strRequest);
	*chTmp = ConvertBSTRToString(strRequest);
	printf("charRequest = %s\n",*chTmp);

	delete pEnroll;
    	
	return res;
}

int main(int argc, char* argv[])
{
    char* chTmp = 0;
    HRESULT res;
    BSTR bstrRDN = SysAllocString(L"1.2.840.113549.1.9.1=user@cryptopro.ru, 2.5.4.6=RU, 2.5.4.7=moscow, 2.5.4.10=cpro, 2.5.4.3=common name");
    BSTR bstrEKUsage = SysAllocString(L"1.3.6.1.5.5.7.3.2");
    BSTR contName = SysAllocString(CONTAINER);
    FILE* f;
    if (argc == 2)
        f = fopen(argv[1], "wb");
    else
        f = fopen("request.p10", "wb");
    
    res = create_request(bstrRDN, bstrEKUsage, contName, &chTmp);
	
    if (res != S_OK){
	HandleError( "Error create_request.");
	goto er;
    } else {
	printf("Successful creating request. \n");
    }
	
    fputs(chTmp,f);

er :
    fclose(f);
    SysFreeString(bstrRDN);
    SysFreeString(bstrEKUsage);
    SysFreeString(contName);
    free(chTmp);
    return res;
}//end of main
