#ifndef _PCALLCTX_UTF8_H
#define _PCALLCTX_UTF8_H

#include "reader/support_utf8.h"

static ATTR_USERES void* pcallctx_malloc(void * alloc_param, size_t size)
{
    return rAllocMemory((pCP_CALL_CTX)alloc_param, size, MP_WORK);
}

static void pcallctx_std_free(void * alloc_param, void * ptr)
{
    rFreeMemory((pCP_CALL_CTX)alloc_param, ptr, MP_WORK);
}


/*    UTF8   TCHAR   .
dest -   .   , ,    TCHAR ,   .
src -   UTF8 ,   .

  ,  .   ,     dest.    NULL.

  malloc  free.
*/
static SUP_INLINE ATTR_USERES TCHAR * pcallctx_utf82cpy(pCP_CALL_CTX pCallCtx, TCHAR * dest, const char * src)
{
    return _utf82cpy(pcallctx_malloc, pcallctx_std_free, pCallCtx, dest, src, TRUE);
}

/*    TCHAR,    UTF8-,   src.    .

  malloc  free.
*/
static SUP_INLINE ATTR_USERES size_t pcallctx_utf82len(const char * src) //-V524 - ,  ,    .  . 
{
    return _utf82len(src, TRUE);
}

/*   TCHAR  UTF8.
   src   TCHAR,  UTF8 ,   ,  dest.
 NULL    dest  .

  malloc  free.
*/
static SUP_INLINE ATTR_USERES char * pcallctx_2utf8cpy(pCP_CALL_CTX pCallCtx, char* dest, const TCHAR* src)
{
    return _2utf8cpy(pcallctx_malloc, pcallctx_std_free, pCallCtx, dest, src, TRUE);
}

/*  TCHAR     TCHAR  .
   src   TCHAR,  UTF8 ,   ,  dest.
 NULL    dest  .

  malloc  free.
*/
static SUP_INLINE ATTR_USERES TCHAR * pcallctx_console_2utf8cpy(pCP_CALL_CTX pCallCtx, TCHAR* dest, const TCHAR* src)
{
    return console_2utf8cpy(pcallctx_malloc, pcallctx_std_free, pCallCtx, dest, src);
}

/*
    src   UTF8,   .
  malloc  free.
*/
static SUP_INLINE ATTR_USERES size_t pcallctx_2utf8len(pCP_CALL_CTX pCallCtx, const TCHAR * src)
{
    return _2utf8len(pcallctx_malloc, pcallctx_std_free, pCallCtx, src, TRUE);
}

/*     TCHAR*  utf8,    */
static SUP_INLINE ATTR_USERES char * pcallctx_tchar2utf8(pCP_CALL_CTX pCallCtx, const TCHAR * tstr)
{
    char * ret = rAllocMemory(pCallCtx, pcallctx_2utf8len(pCallCtx, tstr) + 1, MP_WORK);
    if (!ret)
    {
	return NULL;
    }
    if (pcallctx_2utf8cpy(pCallCtx, ret, tstr) == NULL) {
	rFreeMemory(pCallCtx, ret, MP_WORK);
	return NULL;
    }
    return ret;
}

#endif /*_PCALLCTX_UTF8_H*/
