
#ifndef _KSP_BASE_
#define _KSP_BASE_

#include "CSP_WinCrypt.h"
#include "CSP_Sspi.h"
#include "CSP_SChannel.h"

#ifdef UNIX //for CPSSP_CTX_FLAGS
#include "CpSChl.h"
#endif //UNIX

#include "WinCryptEx.h"
#include "wincspc.h"
#include "reader/dprint2.h"

#include "Suites.h"

typedef struct _CPSSP_CTX_ {
	CPSSP_CTX_FLAGS				Flags;
        HCRYPTKEY				hReadKey;
        HCRYPTKEY				hWriteKey;

	//        (  TLS 1.2)
	HCRYPTKEY				hRootReadKey;
	HCRYPTKEY				hRootWriteKey;
	HCRYPTKEY				hRootReadHMACKey;
	HCRYPTKEY				hRootWriteHMACKey;
	HCRYPTKEY				hInter1ReadKey;
	HCRYPTKEY				hInter1WriteKey;
	HCRYPTKEY				hInter1ReadHMACKey;
	HCRYPTKEY				hInter1WriteHMACKey;
	HCRYPTKEY				hInter2ReadKey;
	HCRYPTKEY				hInter2WriteKey;
	HCRYPTKEY				hInter2ReadHMACKey;
	HCRYPTKEY				hInter2WriteHMACKey;

        HCRYPTKEY				hReadHMACKey;
        HCRYPTKEY				hWriteHMACKey;
        HCRYPTHASH				hReadHMACHash;
        HCRYPTHASH				hWriteHMACHash;
        unsigned long long			read_sequence;
        unsigned long long			write_sequence;

	BYTE 					session_id[32/*SSL3_SSL_SESSION_ID_LENGTH*/];
	BYTE					session_id_length;

        DWORD					shutdown;
	SecPkgContext_Certificates		ContextCertificates;
	HANDLE					hHandle;
	DWORD					cbSubjectName;
	BYTE*					pbSubjectName;
	DWORD					cbIssuerName;
	BYTE*					pbIssuerName;
	SecPkgContext_ClientCertPolicyResult	clientCertPolicyResult;
	HCRYPTPROV				hCryptProv;
	DWORD					dwProvVersion;
	HCRYPTMODULE				hCSP;
        BYTE                                    AlpnProtoLen;
        BYTE                                    AlpnProto[MAX_PROTOCOL_ID_SIZE];
        BYTE                                    NpnProtoLen;
        BYTE                                    NpnProto[MAX_PROTOCOL_ID_SIZE];
	DWORD					sp_session_tls_version;
	ALG_ID					aiEffectiveSignAlgid;
	ALG_ID					aiEffectiveExchAlgid;
	DWORD					remote_point_len;
	DWORD					selected_group;
	DWORD					dwClientTLS13PaddingLength;
	DWORD					dwServerTLS13PaddingLength;
	const Cipher*				cipher;
	time_t					session_eol_time;

	HCRYPTKEY				hIvKey;
	BYTE					pbIvData[84/*IV_DATA_LEN*/];
} CPSSP_CTX, *PCPSSP_CTX, *PCPSSP_CREDS;

#define SSL3_RT_MAX_PLAIN_LENGTH		16384
#define SSL3_RT_MAX_COMPRESSED_LENGTH	(1024+SSL3_RT_MAX_PLAIN_LENGTH)
#define SSL3_RT_MAX_ENCRYPTED_LENGTH	(1024+SSL3_RT_MAX_COMPRESSED_LENGTH)

#define SSL3_AD_CLOSE_NOTIFY		 0
#define SSL3_AD_UNEXPECTED_MESSAGE	10	/* fatal */
#define SSL3_AD_BAD_RECORD_MAC		20	/* fatal */
#define SSL3_AD_DECOMPRESSION_FAILURE	30	/* fatal */
#define SSL3_AD_HANDSHAKE_FAILURE	40	/* fatal */
#define SSL3_AD_NO_CERTIFICATE		41
#define SSL3_AD_BAD_CERTIFICATE		42
#define SSL3_AD_UNSUPPORTED_CERTIFICATE	43
#define SSL3_AD_CERTIFICATE_REVOKED	44
#define SSL3_AD_CERTIFICATE_EXPIRED	45
#define SSL3_AD_CERTIFICATE_UNKNOWN	46
#define SSL3_AD_ILLEGAL_PARAMETER	47	/* fatal */

#define SSL_SENT_SHUTDOWN	1
#define SSL_RECEIVED_SHUTDOWN	2
#define SSL_WANT_SHUTDOWN	4

#define SSL3_MT_HELLO_REQUEST			0

#define AddToMessageLog(a,b,c,d,e,f,g)

#endif /* _KSP_BASE_ */
