/*
 * Copyright(C) 2003  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile: PKIXCMP_Base.h,v $
 * \version $Revision: 1.48 $
 * \date $Date: 2005/01/24 12:36:43 $
 * \author $Author: cav $
 *
 * \brief PKIXCMP_Base class
 */

#ifndef PKIXCMP_BASE_H
#define PKIXCMP_BASE_H

#include "CA_CMP_Types.h"
#include "CA_CMP_Msg.h"
#include "CA_CMP_Certificate.h"
#include "CA_CMP_Requests.h"
#include "CA_CMP_ErrorMsg.h"
#include "CA_CMP_CRL.h"
#include "CA_CMP_RevAnnContent.h"
#include "StoreUtil.h"

typedef std::pair<std::string,std::string> ReaderNamePair;
//    -   () 
//    -  ,    
//   CSP

//   
typedef std::list< ReaderNamePair > ReaderList;

class Retry {
public:
    virtual ~Retry() {}
    bool operator()( void ) 
    { 
	if( call() ) { err = 0; return true; }
	err = GetLastError(); 
	return is_exit(); 
    }
    DWORD LastError() const { return err; }
    bool is_exit() const { return !err 
	|| err == (DWORD)SCARD_W_CANCELLED_BY_USER
	|| err == (DWORD)SCARD_W_WRONG_CHV
	|| err == (DWORD)SCARD_E_INVALID_CHV
#ifdef _WIN32
	|| err == (DWORD)NTE_BAD_TYPE  //for Prov params not supported by RSA 
#endif
	|| err == (DWORD)SCARD_W_CHV_BLOCKED; }
protected:
    virtual BOOL call() = 0;
    DWORD err;
};

class WndProv {
public:
    virtual ~WndProv() {}
    //         
    //   name.
    // \param name [in]  ,   
    // \param error [in]    0   
    // \param n [in]   
    // \param num [in]   
    virtual bool insert_create( const char *name, unsigned long error, 
	short n, int num ) = 0;

    //    .
    //          
    //     CANCEL.    
    //       
    // \param name [in]  
    // \param num [in]    -1    
    // \param retry  
    virtual bool retry( const char *name, int num, Retry &retry ) = 0;

    //     pin-
    // \param name [in]  
    // \param i [in]     pin.   
    //  == 3. 
    // \param pin [out] pin-      8 ,  
    //    pin
    // \param n [in]   
    // \param num [in]   
    // \return false     pin. true Ok
    virtual bool get_current_pin( const char *name, short i, char pin[9], short n, 
	int num  ) = 0;

    //      pin-
    // \param name [in]  
    // \param pin [out] pin-      8 ,  
    //    pin
    // \param n [in]   
    // \param i [in]   
    // \return false     pin. true Ok
    virtual bool get_new_pin( const char *name, char pin[9], short n, 
	int num  ) = 0;

    //       
    // \param reader_list [in]   
    // \return   
    virtual std::string get_reader( const ReaderList& ) = 0;

    //   
    virtual int get_key_size();

    //   true,     
    //     WndProv
    virtual bool use_builtin_windows ();

    //   true     ( )
    virtual bool no_pin();

    //   true       
    virtual bool force_new_pin();

protected:
    std::string m_cached_current_pin; // used by PkiClient
    bool m_using_cached_current_pin; // used by PkiClient
};

class OldWndProv : public WndProv
{
public:
    OldWndProv( const char *szContainer, const char *pin );
    OldWndProv( const std::string &reader, const char *pin );
    //   
    virtual int get_key_size()
    {
      return 0;
    }
    virtual bool insert_create( const char *, unsigned long error, short, int ) 
    {
	if( error )
	    throw CA_CRYPT_EXCEPTION;
	return true;
    }
    virtual bool retry( const char *, int, Retry &a_retry )
    { return a_retry(); }
    virtual bool get_current_pin( const char *, short i, char pin[9], short, int)
    {
	if( i != 3 )
	    throw CA_CRYPT_EXCEPTION;
	strcpy( pin, pin_ );
	return true;
    }
    virtual bool get_new_pin( const char *, char pin[9], short, 
	int )
    { strcpy( pin, pin_ ); return true; }
    virtual std::string get_reader( const ReaderList& )
    { return reader_; }

    char pin_[9];
    std::string reader_;
};

#if defined _WIN32
class WIN32WndProv : public WndProv
{
public:
    WIN32WndProv () {}
    //   
    virtual int get_key_size();
    virtual bool use_builtin_windows ();

    virtual bool insert_create( const char *name, unsigned long error, 
	short n, int num );
    virtual bool retry( const char *name, int num, Retry &retry );
    virtual bool get_current_pin( const char *name, short i, char pin[9], short n, 
	int num  );
    virtual bool get_new_pin( const char *name, char pin[9], short n, 
	int num  );
    virtual std::string get_reader( const ReaderList& );
};
#endif	/* _WIN32 */

class PKIXCMP_Base {
public:
    static CACMPT_BLOB GetTLSCert(const char *ini_path);
    static void SetTLSCert(const char *ini_path, const CACMPT_BLOB& cert);

    //    store
    static void CertStore_Add(const wchar_t *store_name, const CACMPT_BLOB &cert, bool SystemStore);
    //    store   
    static void CertStore_Add(const CertificateStore & store, const CACMPT_BLOB &cert)
    {
	CertStore_Add(store.GetName(), cert, store.isSystem());
    }

    //  crl  store
    static void CrlStore_Add(const wchar_t *store_name,
	const CACMPT_BLOB &crl, bool SystemStore = true, bool replace = true);

    //  crl  store c  
    static void CrlStore_Add(const CertificateStore & store,
	const CACMPT_BLOB &crl, bool replace = true )
    {
	    CrlStore_Add(store.GetName(), crl, store.isSystem(), replace);
    };

  //    store   Issuer   
    static void CertStore_Find(encoded_certificate_list &dest,
	const wchar_t *lpwStoreName,
	const wchar_t *issuer,
	const char *serial, bool SystemStore);
    //   store   Issuer   
    static void CertStore_Find(encoded_certificate_list &dest,
			       const CertificateStore &store,
			       const wchar_t *issuer,
			       const char *serial)
    {
	CertStore_Find(dest, store.GetName(), issuer, serial, store.isSystem());
    };

    //     ,      
    //    store  Subject   
    static void CertStore_Find(encoded_certificate_list &dest,
			       const wchar_t *lpwStoreName,
			       const CACMPT_BLOB &subject,
			       const char *serial, bool SystemStore);
    //    store  Subject   
    static void CertStore_Find(encoded_certificate_list &dest,
			       const CertificateStore &store,
			       const CACMPT_BLOB &subject,
			       const char *serial)
    {
	CertStore_Find(dest, store.GetName(), subject, serial, store.isSystem());
    };

    //    store   .
    static void CertStore_Find(encoded_certificate_list &dest,
			      const wchar_t *lpwStoreName,
			      CACMPT_PublicKeyInfo &public_info, bool SystemStore);
    //    store   
    static void CertStore_Find(encoded_certificate_list &dest,
			       const CertificateStore & store,
			       CACMPT_PublicKeyInfo &public_info)
    {
	CertStore_Find(dest, store.GetName(), public_info, store.isSystem());
    };

    //     store
    static bool CertStore_Is( const CACMPT_BLOB &cert,
	const wchar_t *lpwStoreName, bool SystemStore = true );
    //     store
    static bool CertStore_Is( const CACMPT_BLOB &cert,
	const CertificateStore & store)
    {
	    return CertStore_Is(cert,store.GetName(),store.isSystem());
    }

    //  crl  store   Issuer
    static void CrlStore_Find(encoded_crl_list &dest,
	const wchar_t *lpwStoreName,
	const wchar_t *issuer, bool SystemStore);

    //  crl  store   Issuer
    static void CrlStore_Find(encoded_crl_list &dest,
	const CertificateStore & store, const wchar_t *issuer)
    {
	CrlStore_Find(dest, store.GetName(), issuer, store.isSystem());
    };

    //  crl  store  Issuer
    static void CrlStore_Find(encoded_crl_list &dest,
	const wchar_t *lpwStoreName,
	const CACMPT_BLOB &issuer, bool SystemStore = true );
    //  crl  store  Issuer
    static void CrlStore_Find(encoded_crl_list &dest,
	const CertificateStore & store,
	const CACMPT_BLOB &issuer)
    {
	    CrlStore_Find(dest, store.GetName(), issuer, store.isSystem());
    };

    //    store
    static int CertStore_Del( const wchar_t *store_name,
	const CACMPT_BLOB &cert, bool SystemStore = true );
    //    store
    static int CertStore_Del( const CertificateStore & store,
	const CACMPT_BLOB &cert)
    {
	return CertStore_Del(store.GetName(), cert, store.isSystem());
    };

    //  crl  store
    static void CrlStore_Del(const wchar_t *store_name, const CACMPT_BLOB &crl, bool SystemStore);
    //  crl  store
    static void CrlStore_Del(const CertificateStore &store, const CACMPT_BLOB &crl)
    {
	CrlStore_Del(store.GetName(), crl, store.isSystem());
    }

    //  
    static void Cert_Decode(const CACMPT_BLOB &c_msg, CertificateInfo *info);
    //     CertificateInfo (   )
    static void CertRepMessage_Decode(const CACMPT_BLOB &cp_msg, CertificateInfo *info);

    //   crl
    static void Crl_Decode(const CACMPT_BLOB &crl_msg, CrlInfo *info);

    //     RequestInfo (   , ...)
    static int CertReqMessage_Decode(const CACMPT_BLOB &cr_msg, 
	RequestInfo *info);

#define Store_Root	 CertificateStore (L"Root",	true)

    static void InstallRoot(const CACMPT_BLOB &cert)
    {
	CertStore_Add(Store_Root, cert);
    }

    static void ErrorMsgInfo_Decode(const CACMPT_BLOB &em_msg, ErrorMsgInfo *em_info);

    //   
    // \param cert [in]  
    // \param encoded_certificate_list [in]   
    // \param add_store [in]  . store   
    //   
    // \param add_store_len [in]   store
    static unsigned CertChain_VerifyCertificate( const CACMPT_BLOB &cert,
	encoded_certificate_list &path,
	const encoded_certificate_list *cert_list,
	const CertificateStore *add_store = NULL, int add_store_len = 0);

    //  
    static unsigned CertChain_VerifyCMPMessage(
	const CACMPT_BLOB &msg,
	const CertificateStore *add_store, int add_store_len,
	encoded_certificate_list *path);

    //      
    // @parm cr_msg |   
    // @parm ignoreMsgSignature | FALSE -    
    //   ,   PKCS-    
    // : PKCS10-      ,
    //   PKICMP-   
    // 
    // : !!!       
    unsigned CertReqMessage_Verify(const CACMPT_BLOB &cr_msg,
				   encoded_certificate_list *path = NULL);

    static unsigned CertChain_VerifyCrl( const CACMPT_BLOB &crl,
	const CertificateStore *add_store, int add_store_len);

    static void InstallCertificateToStore( const CACMPT_BLOB &RawCertificate,
	HCRYPTPROV hProv, DWORD dwKeySpec, 
	const wchar_t * lpwStoreName = L"My", 
	DWORD dwOpenStore = CERT_SYSTEM_STORE_CURRENT_USER );

    static void InstallCertificateToStore( const CACMPT_BLOB &RawCertificate,
	HCRYPTPROV hProv, DWORD dwKeySpec, 
	const CertificateStore store) 
    {
	    InstallCertificateToStore(RawCertificate,hProv,dwKeySpec,store.GetName(),
			    (store.isSystem()? CERT_SYSTEM_STORE_LOCAL_MACHINE : CERT_SYSTEM_STORE_CURRENT_USER ));
    };

    void CreateTemplate (RequestInfo *info, DWORD dwOpenStore = CERT_SYSTEM_STORE_CURRENT_USER);

    int PKCS10_EncodeAndSign(RequestInfo *info, CACMPT_BLOB &cr_msg, bool fInstallAsMy);

    static std::wstring ChainStatusToString( unsigned chain_status );

    virtual const CertificateStore * Get_ADD_STORE() const =0;
    virtual int Get_ADD_STORE_LEN () const = 0;

    // rsv: public to give access to QuickCert
    static void InstallCertificateToContainer( const CACMPT_BLOB &RawCertificate,
	HCRYPTPROV hProv, DWORD dwKeySpec );

protected:
    PKIXCMP_Base();
    virtual ~PKIXCMP_Base();

    DWORD dwKeySpec;
    DWORD dwProvType_;
    char * szProvider_;
    HCRYPTPROV hProv;
    CACMPT_BLOB MYCert;

    //  ErrorMsgInfo
    static void ErrorMsgInfo_EncodeAndSign(const ErrorMsgInfo *em_info,
	CACMPT_BLOB &em_msg, unsigned long hProv, unsigned long dwKeySpec,
	CACMPT_BLOB &cert, bool ToSign=true);
    static void GenerateKeyPair(WndProv &wnd_prov,
	const char *szProvider, int dwProvType,
	const char *reader, const char *container,
	unsigned long keySpec, bool keyExportable,
        HCRYPTPROV &hProv);

    static unsigned ErrorMsgInfo_Verify( const CACMPT_BLOB &em_msg,
	const CertificateStore *add_store, int add_store_len);
};
#endif // PKIXCMP_BASE_H
