/*
 * Copyright(C) 2003  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile: CA_CMP_CRL.h,v $
 * \version $Revision: 1.18 $
 * \date $Date: 2005/01/24 12:36:43 $
 * \author $Author: cav $
 *
 * \brief   
 */

#ifndef CA_CMP_CRL_H
#define CA_CMP_CRL_H

#include "CA_CMP_Types.h"

enum CrlReason {
    CRLREASON_UNSPECIFIED = 0,
    CRLREASON_KEYCOMPROMISE = 1, 
    CRLREASON_CACOMPROMISE = 2, 
    CRLREASON_AFFILIATIONCHANGED = 3,
    CRLREASON_SUPERSEDED = 4, 
    CRLREASON_CESSATIONOFOPERATION = 5, 
    CRLREASON_CERTIFICATEHOLD = 6, 
    CRLREASON_REMOVEFROMCRL = 8,
    CRLREASON_PRIVILEDGEWITHDRAWN = 9,
    CRLREASON_AACOMPROMISE = 10
};

enum HoldInstruction {
    HOLDINSTRUCTION_UNSPECIFIED = 0,
    HOLDINSTRUCTION_NONE = 1,
    HOLDINSTRUCTION_CALLISSUER = 2,
    HOLDINSTRUCTION_REJECT = 3
};

std::string CrlReason_toString( CrlReason r );
CrlReason CrlReason_fromString( const char* );
HoldInstruction HoldInstruction_fromString( const char* );
HoldInstruction HoldInstruction_fromOid( const char* );

class CrlInfoItem
{
public:
    CrlInfoItem() {*SerialNumber = 0;}
    CrlInfoItem( const CrlInfoItem &item ) { assign( item ); }
    CrlInfoItem( const char* Serial, const CACMPT_Date Date = CACMPT_Date() );
    ~CrlInfoItem() {}
    CrlInfoItem& operator =( const CrlInfoItem &right )
    { assign( right ); return *this; }
    bool operator ==( const CrlInfoItem &right ) const
    { return !strcmp( SerialNumber, right.SerialNumber ); }

    //  CrlReason  extenion
    //  CRLREASON_UNSPECIFIED,  Extension 
    CrlReason GetReason() const;
    //  CrlReason  extenion
    //  CRLREASON_UNSPECIFIED Extension 
    void SetReason( CrlReason );

    //  HoldInstruction  extenion
    //  HOLDINSTRUCTION_UNSPECIFIED,  Extension 
    HoldInstruction GetHoldInstruction() const;
    //  HoldInstruction  extenion
    //  HOLDINSTRUCTION_UNSPECIFIED Extension 
    void SetHoldInstruction( HoldInstruction );

    //  InvalidityDate  extenion
    //  CACMPT_Date(),  Extension 
    CACMPT_Date GetInvalidityDate() const;
    //  InvalidityDate  extenion
    //  invalidity_date == CACMPT_Date() Extension 
    void SetInvalidityDate( const CACMPT_Date &invalidity_date );

    //  
    CACMPT_Date RevokedWhen;

    //  
    CACMPT_SERIAL SerialNumber;

    // extensions
    CACMPT_Extensions Extensions;

protected:
    void assign( const CrlInfoItem &right );
};

class CrlInfo : public std::list<CrlInfoItem>
{
public:
    CrlInfo();
    ~CrlInfo() {}

    CrlInfo( const CrlInfo& crl ): std::list<CrlInfoItem>()
    {
	*this = crl;
    }
    CrlInfo& operator=( const CrlInfo& crl );
    void clear();

    // binary blob
    CACMPT_BLOB RawCRL;

    // thisUpdate
    CACMPT_Date ThisUpdate;

    // nextUpdate
    CACMPT_Date NextUpdate;

    // Use ThisUpdate & NextUpdate
    bool UseUpdate;

    //  - ASN1T_AlgorithmIdentifier signatureAlgorithm;
    char CrlSignatureAlgorithm[ 254 ];

    // dim:    
    int Status;
    int RequestID;

    CACMPT_PARSED_RDN issuerRDN;

    //   
    CACMPT_BLOB SubjectKeyIdentifier;

    //   
    CACMPT_BLOB AuthorityKeyIdentifier;

    // extensions
    CACMPT_Extensions Extensions;
};
#endif // CA_CMP_CRL_H
