<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>


<xsl:template match="ContentInfo" name="ContentInfo">
<xsl:param name="Included"/>

<xsl:if test="$Included = 'false'">

	<!--    -->
  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
    </fo:block>

       <!--   -->
     <fo:block text-align="center" font-size="8pt">
    </fo:block>
  </fo:static-content>



      <!-- Footer -->

  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>


         
	<!--   -->
  <fo:flow flow-name="xsl-region-body">


    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"
	      space-after="16pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
       <xsl:choose>
	<xsl:when test="count(./content/SignedData/encapContentInfo/eContentType[. = $DVCSRequestMessage]) != 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSRequest_header</xsl:with-param> </xsl:call-template>
	</xsl:when>

	<xsl:when test="count(./content/SignedData/encapContentInfo/eContentType[. = $DVCSResponseMessage]) != 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DVCSResponse_header</xsl:with-param> </xsl:call-template>
	</xsl:when>

	<xsl:when test="count(./content/SignedData/encapContentInfo/eContentType[. = $TimeStampAuthenticode]) != 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TimeStampAuthenticode_header</xsl:with-param> </xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKCS7_Unknown</xsl:with-param> </xsl:call-template>
	</xsl:otherwise>
       </xsl:choose>

    </fo:block>

            <!--     -->	  
    <xsl:call-template name="uc_title"/>


    <fo:block text-align="left" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ContentInfo_contentType</xsl:with-param> </xsl:call-template>
      <xsl:for-each select="./contentType">  
	<xsl:call-template name="printOID"/>
      </xsl:for-each>
     </fo:block>

      <xsl:choose>
	<xsl:when test="count(./content/*/*) &gt; 0">
	      <xsl:for-each select="./content">  
		<fo:block text-align="left" font-size="10pt" 	
		      >
		      <xsl:apply-templates select="."/>
		</fo:block> 
	      </xsl:for-each>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:if test="./content != ''">
	    <fo:block text-align="left"
	      font-family="Arial" font-size="12pt"
	      space-before="32pt"
	      space-after="2pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	      
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ContentInfo_content</xsl:with-param> </xsl:call-template>
	    </fo:block>

	    <fo:block text-align="left" font-size="10pt" 	
	        border-style="solid"                        
		>
	      <xsl:value-of select="./content"/>  
	    </fo:block>
	  </xsl:if>
	</xsl:otherwise>
      </xsl:choose>

    <fo:block id="end of certificate">
    </fo:block>
  </fo:flow>

</xsl:if>

<xsl:if test="$Included != 'false'">


    <fo:block text-align="left" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ContentInfo_contentType</xsl:with-param> </xsl:call-template>
      <xsl:for-each select="./contentType">  
	<xsl:call-template name="printOID"/>
      </xsl:for-each>
     </fo:block>

      <xsl:choose>
	<xsl:when test="count(./content/*/*) &gt; 0">
	      <xsl:for-each select="./content">  
		<fo:block text-align="left" font-size="10pt" 	
		      >
		      <xsl:apply-templates select="."/>
		</fo:block> 
	      </xsl:for-each>
	</xsl:when>

	<xsl:otherwise>
	  <xsl:if test="./content != ''">
	    <fo:block text-align="left"
	      font-family="Arial" font-size="12pt"
	      space-before="32pt"
	      space-after="2pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ContentInfo_content</xsl:with-param> </xsl:call-template>
	    </fo:block>

	    <fo:block text-align="left" font-size="10pt" 	
	        border-style="solid"                        
		>
	      <xsl:value-of select="./content"/>  
	    </fo:block>
	  </xsl:if>
	</xsl:otherwise>
      </xsl:choose>

</xsl:if>

</xsl:template>


<xsl:template match="SignedData" name="SignedData">

    <!--   -->	
    <xsl:for-each select="./version">  
	    <!--   -->	
	<fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignedData_version</xsl:with-param> </xsl:call-template>
	</fo:block>

         <!--   -->
	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                        
	    padding="3pt"
	    >
	    <xsl:value-of select='name(./*)'/>
	</fo:block>
    </xsl:for-each>

    <xsl:for-each select="./digestAlgorithms">  
	<xsl:call-template name="DigestAlgorithmIdentifiers"/>
    </xsl:for-each>


    <xsl:for-each select="./encapContentInfo">  
	<xsl:call-template name="EncapsulatedContentInfo"/>
    </xsl:for-each>



    <xsl:for-each select="./certificates">  
	<xsl:call-template name="CertificateSet"/>
    </xsl:for-each>

    <xsl:for-each select="./crls">  
	<xsl:call-template name="CertificateRevocationLists"/>
    </xsl:for-each>

    <xsl:for-each select="./signerInfos">  
	<xsl:call-template name="SignerInfos"/>
    </xsl:for-each>


</xsl:template>

<xsl:template match="CertificateRevocationLists" name="CertificateRevocationLists">
    <xsl:for-each select="./*">  
	<xsl:call-template name="CertificateList"/>	
    </xsl:for-each>
</xsl:template>

<xsl:template match="CertificateSet" name="CertificateSet">
    <xsl:for-each select="./*">  
	<xsl:call-template name="CertificateChoices"/>	
    </xsl:for-each>
</xsl:template>

 <!--    -->
<xsl:template match="CertificateChoices" name="CertificateChoices"> 
    <xsl:for-each select="./certificate">  
	<xsl:call-template name="Certificate"/>	
    </xsl:for-each>

    <xsl:for-each select="./extendedCertificate">  
	<!--xsl:call-template name="ExtendedCertificate"/-->	
    </xsl:for-each>

    <xsl:for-each select="./attrCert">  
	<!--xsl:call-template name="AttributeCertificate"/-->	
    </xsl:for-each>

</xsl:template>



<xsl:template match="EncapsulatedContentInfo" name="EncapsulatedContentInfo">

  <fo:block   font-family="Arial" font-size="14pt"
	      space-before="32pt"			
	      space-after="16pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	    text-align="center" 
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EncapsulatedContentInfo_header</xsl:with-param> </xsl:call-template>
  </fo:block>

   <fo:block font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EncapsulatedContentInfo_contentType</xsl:with-param> </xsl:call-template>
      <xsl:for-each select="./eContentType">  
	<xsl:call-template name="printOID"/>
      </xsl:for-each>
     </fo:block>

    <xsl:choose>
	
	<xsl:when test="count(./eContent) &gt; 0">
	  <xsl:apply-templates select="./eContent"/>
	</xsl:when>

	<xsl:otherwise>
	  <xsl:if test="./eContent != ''">
	    <fo:block text-align="left"
	      font-family="Arial" font-size="12pt"
	      space-before="32pt"
	      space-after="2pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EncapsulatedContentInfo_eContent</xsl:with-param> </xsl:call-template>	      
	    </fo:block>

	    <fo:block text-align="left" font-size="10pt" 	
	        border-style="solid"                        
		>
	      <xsl:value-of select="./eContent"/>  
	    </fo:block>
	  </xsl:if>

        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


</xsl:stylesheet>
