<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>


<xsl:template match="OCSPResponse" name="OCSPResponse">
<xsl:param name="Included"/>
<xsl:if test="$Included = 'false'">

    <!-- Header   -->

	<!--    -->
  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
    </fo:block>

       <!--   -->
     <fo:block text-align="center" font-size="8pt">
    </fo:block>
  </fo:static-content>



      <!-- Footer -->

  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>			<!--  -->
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>




          
	<!--   -->
  <fo:flow flow-name="xsl-region-body">
    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"
	      space-after="16pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponse_header</xsl:with-param> </xsl:call-template>
    </fo:block>

            <!--     -->	  
    <xsl:call-template name="uc_title"/>



	<!--   -->
     <xsl:for-each select="./responseStatus">  
	<xsl:call-template name="OCSPResponseStatus"/>
    </xsl:for-each>

	<!--   -->
     <xsl:for-each select="./responseBytes">  
	<xsl:call-template name="ResponseBytes"/>
    </xsl:for-each>


	<!-- Footer  -->


    <fo:block id="end of certificate">
    </fo:block>
  </fo:flow>
</xsl:if>


<xsl:if test="$Included != 'false'">

	<!--   -->
     <xsl:for-each select="./responseStatus">  
	<xsl:call-template name="OCSPResponseStatus"/>
    </xsl:for-each>

	<!--   -->
     <xsl:for-each select="./responseBytes">  
	<xsl:call-template name="ResponseBytes"/>
    </xsl:for-each>

</xsl:if>
</xsl:template>

	<!--  OCSPResponseStatus -->
<xsl:template match="OCSPResponseStatus" name="OCSPResponseStatus">
    <fo:block font-family="Arial" font-size="14pt"                              
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      >
	<xsl:choose>

			<!-- Response has valid confirmations -->
		<xsl:when test="count(successful) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponseStatus_successful</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!-- Response has valid confirmations -->
		<xsl:when test="count(malformedRequest) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponseStatus_malformedRequest</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!-- Response has valid confirmations -->
		<xsl:when test="count(internalError) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponseStatus_internalError</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!-- Response has valid confirmations -->
		<xsl:when test="count(tryLater) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponseStatus_tryLater</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!-- Response has valid confirmations -->
		<xsl:when test="count(sigRequired) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponseStatus_sigRequired</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!-- Response has valid confirmations -->
		<xsl:when test="count(unauthorized) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponseStatus_unauthorized</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!-- Response has valid confirmations -->
		<xsl:when test="count(badCRL) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_OCSPResponseStatus_badCRL</xsl:with-param> </xsl:call-template>
		</xsl:when>

	</xsl:choose>
    </fo:block>
</xsl:template>


	<!--   ResponseBytes -->
<xsl:template match="ResponseBytes" name="ResponseBytes">
    <fo:block font-family="Arial" font-size="10pt"                              
	      space-before="3pt"
	      space-after="0pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      >
              <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ResponseBytes_responseType</xsl:with-param> </xsl:call-template>
	      :       
              <xsl:for-each select="./responseType">  
  	      	<xsl:call-template name="printOID"/>
              </xsl:for-each>
    </fo:block>
    <xsl:for-each select="./response">  
	  <xsl:apply-templates select="."/>
    </xsl:for-each>

</xsl:template>

	<!--  BasicOCSPResponse -->
<xsl:template match="BasicOCSPResponse" name="BasicOCSPResponse">

    <fo:block font-family="Arial" font-size="14pt"                              
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      >
              <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicOCSPResponse_header</xsl:with-param> </xsl:call-template>
    </fo:block>

    <xsl:for-each select="./tbsResponseData">  
	<xsl:call-template name="ResponseData"/>
    </xsl:for-each>

    <fo:block font-family="Courier New" font-size="14pt"
	    space-before="32pt"			
	    space-after="16pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    text-align="center"
            keep-with-next="always"
	    >
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_BasicOCSPResponse_signatureAlgorithm</xsl:with-param> </xsl:call-template>

    </fo:block>	

    <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithmIdentifier"/>
    </xsl:for-each>

    <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>



    <xsl:for-each select="./certs">  
	<xsl:call-template name="Certificates"/>
    </xsl:for-each>

</xsl:template>

	<!--  ResponseData -->
<xsl:template match="ResponseData" name="ResponseData">

    <xsl:for-each select="./version">  
	<xsl:call-template name="Version"/>
    </xsl:for-each>

    <xsl:for-each select="./responderID">  
	<xsl:call-template name="ResponderID"/>
    </xsl:for-each>

    <fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ResponseData_producedAt</xsl:with-param> </xsl:call-template>
	   :
	   <xsl:for-each select="./producedAt">  
		<xsl:call-template name="GeneralizedTime"/>
	   </xsl:for-each>
    </fo:block>



    <xsl:for-each select="./responses/*">  
	<xsl:call-template name="SingleResponse"/>
    </xsl:for-each>


	<!--   -->
     <xsl:for-each select="./responseExtensions">  
	  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ResponseData_responseExtensions</xsl:with-param> </xsl:call-template>				
	  </fo:block>

		<!--   -->
	  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >
	    <xsl:call-template name="Extensions"/>
          </fo:block>
    </xsl:for-each>


</xsl:template>

	<!--  SingleResponse -->
<xsl:template match="SingleResponse" name="SingleResponse">

	<!--     -->
     <fo:block font-family="Times" font-size="12pt"                        
	    space-before="18pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    text-align="center"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SingleResponse_reqCert</xsl:with-param> </xsl:call-template>				
     </fo:block>

      <xsl:for-each select="./reqCert">  
	<xsl:call-template name="ReqCert"/>
      </xsl:for-each>

      <xsl:for-each select="./certStatus">  
	<xsl:call-template name="CertStatus"/>
      </xsl:for-each>

     <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SingleResponse_thisUpdate</xsl:with-param> </xsl:call-template>				
            <xsl:for-each select="./thisUpdate">  
		<xsl:call-template name="GeneralizedTime"/>
           </xsl:for-each>
     </fo:block>

      <xsl:for-each select="./nextUpdate">  
        <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SingleResponse_nextUpdate</xsl:with-param> </xsl:call-template>				
	    <xsl:call-template name="GeneralizedTime"/>
        </fo:block>
      </xsl:for-each>

      <xsl:for-each select="./singleExtensions">  
        <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SingleResponse_singleExtensions</xsl:with-param> </xsl:call-template>				

	    <xsl:call-template name="Extensions"/>
        </fo:block>
      </xsl:for-each>


</xsl:template>


</xsl:stylesheet>