/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2008-2013  
 *
 *    , 
 *    .
 *
 *         
 *  ,     ,    , 
 *    : 
 *   1.        
 *           ,   
 *           . 
 *   2.        
 *           ,   
 *              / 
 *        ,   . 
 * 
 *        
 * /   "  "  -  , 
 *    , ,    , 
 *        
 *  .    ,     
 * ,      ,     
 *      ,    /  
 *  ,    ,  Ѩ 
 * ,   , ,   
 *  ,      
 *   (,     , 
 *  ,  ,    - 
 *    ,       
 *  ),         
 *     
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

#ifndef _WIN32
#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,18)
#   error Kernels below 2.4.18 not supported
#endif
#include <linux/module.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
#   include <linux/init.h>
#else
#  if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#    define MODVERSIONS
#    include <linux/modversions.h>
#  endif
#  define MODULE_VERSION "0.2010.1130"
#endif

#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/major.h>
#include <linux/errno.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,12,0)
#include <linux/uaccess.h>
#else  /*    2.6.9 */
#include <asm/uaccess.h>
#endif	/* Linux-4.12 */

#include <linux/byteorder/generic.h>
#include <linux/vmalloc.h>
#include <linux/slab.h> /* For kmalloc() */
#include <linux/compat.h>
/* #include <stddef.h> */
typedef int wchar_t;

#define MODNAME "tstesp"

MODULE_LICENSE("FreeBSD");
MODULE_AUTHOR("Dmitry G. Dyachenko CryptoPro Ltd. <dim@cryptopro.ru>");
MODULE_DESCRIPTION("Tstesp - test for esp_gost");

#include "common.h"
#else //!_WIN32
#include "ddk.h"
#include "lfmm.h"
#pragma warning(disable:4002)
#pragma warning(disable:4115)
#pragma warning(disable:4200)
#endif //!_WIN32
#include "wincspc.h"
#include "esp_gost.h"
#include "io_krn.h"

#if defined(_WIN32)
    #define TSTESP_IOCTL_INODE_ARG  1
#elif defined(LINUX)
    #if !defined(HAVE_COMPAT_IOCTL) && LINUX_VERSION_CODE < KERNEL_VERSION(2,6,36) // TODO:   
	#define TSTESP_IOCTL_INODE_ARG  1
    #endif
#endif

#ifdef _WIN32
extern CPC_CONFIG * CSPConfig;
#else
static CPC_CONFIG * CSPConfig = 0;
#endif

typedef union
{
    HCRYPTMODULE module;
    HCRYPTKEY key;
    HCRYPTPROV prov;
    ESP_HANDLE sid;
    void * pointer;
}POINTERS;

static POINTERS pp[1024*10];
static unsigned pc = 0;

#ifndef _WIN32
/* USE_STD_MM
 *  ,     
 *         -- LFMM
 */
#undef USE_STD_MM
#ifndef USE_STD_MM
#include "lfmm.h"
#endif	/* !USE_STD_MM */

static CPC_CONFIG CSPConfigBuf;

#ifdef USE_STD_MM
volatile size_t max_allocated = 0;
volatile char *alloc_max_ptr = NULL;
volatile char *alloc_min_ptr = (char*)-1;
volatile char *free_max_ptr = NULL;
volatile char *free_min_ptr = (char*)-1;

volatile int N_allocs = 0;
volatile int N_frees = 0;
volatile int Size_allocs = 0;

static DWORD CPCAPI
stdAllocMemory(LPCPC_MEMORY_ARENA pArena, CPC_SIZE_T dwSize, DWORD dwMemPoolId,
	       DWORD dwThreadId, LPVOID *pRes)
{
    void *ptr;
    DWORD r;
    char marker;	    /* dim:       */

    UNUSED(pArena);
    UNUSED(dwThreadId);
    UNUSED(dwMemPoolId);

    alloc_min_ptr = (&marker < alloc_min_ptr) ? &marker : alloc_min_ptr;
    alloc_max_ptr = (&marker > alloc_max_ptr) ? &marker : alloc_max_ptr;
    max_allocated = (dwSize > max_allocated) ? dwSize : max_allocated; 

    if(dwSize==0)
	dwSize = 1;
    r = dwSize / 16;
    if(dwSize % 16)
	r++;
    dwSize = r*16;

    N_allocs++;
    Size_allocs += dwSize;

    switch(dwMemPoolId) {
    case MP_BIG:
	ptr = vmalloc(dwSize);
	break;
    default:
	ptr = kmalloc(dwSize,GFP_ATOMIC);
	break;
    }
    if(!ptr){
	printk(KERN_ALERT MODNAME ": %s: %d: Too big arg for alloc() - %u (poolId=%u)\n",
	       __func__, __LINE__, (unsigned) dwSize, (unsigned) dwMemPoolId);
	return NTE_NO_MEMORY;
    } 
    memset (ptr, 0, dwSize);
    *pRes = ptr;
    return S_OK;
}

/*!
 * \ingroup MemoryManager
 * \brief  
 */
static DWORD CPCAPI
stdFreeMemory(LPCPC_MEMORY_ARENA pArena, VOID *pMem, DWORD dwMemPoolId)
{
    char marker;	    /* dim:       */
    UNUSED(dwMemPoolId);

    free_min_ptr = (&marker < free_min_ptr) ? &marker : free_min_ptr;
    free_max_ptr = (&marker > free_max_ptr) ? &marker : free_max_ptr;

    N_frees++;

    if(!pMem){
	printk(KERN_ALERT MODNAME ": %s: %d: Bad args\n", __func__, __LINE__);
	return NTE_FAIL;
    }
    switch(dwMemPoolId) {
    case MP_BIG:
	vfree (pMem);
	break;
    default:
	kfree (pMem);
	break;
    }
    return 0;
}

static void CPCAPI
stdValidateMemory(LPCPC_MEMORY_ARENA pArena)
{
    UNUSED(pArena);
}

static void CPCAPI
stdStatMemory (LPCPC_MEMORY_ARENA pArena, LPCPC_MEMORY_STATS pStats,
	       DWORD dwMemPoolId)
{
    UNUSED (pArena);
    UNUSED (pStats);
    UNUSED (dwMemPoolId);
}

static void CPCAPI
stdDoneMemory(LPCPC_MEMORY_ARENA pArena)
{
    UNUSED(pArena);
}

static CPC_MEMORY_ARENA Cfg;

static DWORD
stdInitMemory(LPCPC_MEMORY_ARENA *pArena, LONG *PoolSizes, DWORD nPools)
{
    memset (&Cfg, 0, sizeof (Cfg));
    Cfg.pValidateMemory = stdValidateMemory;
    Cfg.pDoneMemory = stdDoneMemory;
    Cfg.pAllocMemory = stdAllocMemory;
    Cfg.pFreeMemory = stdFreeMemory;
    Cfg.pStatMemory = stdStatMemory;
    *pArena = &Cfg;
    return S_OK;
}
#else
static CPC_LFMM_CONFIG Cfg;
/* dup from ipsec/windows/win_esp_test_driver/ipsec.c */
typedef struct _CRYPTMODULE_AND_MEMORY {
    HCRYPTMODULE hCPC;
    char* pMem;
} CRYPTMODULE_AND_MEMORY;
static CRYPTMODULE_AND_MEMORY CPCs[10];
static int CPCs_count = 0;

static HRESULT drvesp_lfmmInitMemory(LPCPC_MEMORY_ARENA * pArena, DWORD maxContexts)
{
    LONG PoolSizes[16];
    HRESULT code;
    memset (PoolSizes, 0, sizeof(PoolSizes));
    PoolSizes [MP_WORK] += 10000 * (250 + maxContexts); 
    PoolSizes [MP_BIG] += 10000 * (250 + maxContexts); 
    PoolSizes [MP_PRIME_M] += 1024 * (400 + maxContexts); 
    PoolSizes [MP_SEC_M] = 1024 * (400 + maxContexts); 
    PoolSizes [MP_WORK_M] += 2 * 1024 * (400 + maxContexts);
    memset (&Cfg,0, sizeof(Cfg));
    Cfg.Buffer=NULL; /* may sleep on request */
    Cfg.Size=0;
    Cfg.fSMP=FALSE;
    Cfg.PoolSizes=PoolSizes;
    Cfg.nPools=16;
    Cfg.nCPUs=1;
    code = CPCInitMemoryLF(pArena, &Cfg);
    if (code != NTE_NO_MEMORY) {
	printk(KERN_ALERT MODNAME "1-st CPCInitMemoryLF FAIL\n");
	return NTE_FAIL;
    }
    Cfg.Buffer=vmalloc(Cfg.Size);
    if(!Cfg.Buffer) {
	printk(KERN_ALERT MODNAME "vmalloc FAIL for %u bytes\n", Cfg.Size);
	return NTE_NO_MEMORY;
    }
    printk(KERN_ALERT MODNAME ": Allocated: %p %u\n", Cfg.Buffer, Cfg.Size);
    memset(Cfg.Buffer, 0, Cfg.Size);

    code = CPCInitMemoryLF(pArena, &Cfg);
    if(code != S_OK) {
	printk(KERN_ALERT MODNAME "2-nd CPCInitMemoryLF FAIL\n");
	vfree(Cfg.Buffer);
	return code;
    }
    return S_OK;
}
#endif	/* USE_STD_MM */

/* USE_USER_DEFINED_LOCKS
 *  ,   ,  
 *  -- default  (   SMP)
*/
#undef USE_USER_DEFINED_LOCKS
#if defined USE_USER_DEFINED_LOCKS
static DWORD CPCAPI
init_section(LPCPC_CRITICAL_SECTION pSection, DWORD cbSection, LPVOID lpArg)
{
    UNUSED(lpArg);
    if (cbSection<sizeof(struct semaphore))
	return NTE_BAD_DATA;
    sema_init((struct semaphore *)pSection, 1);
    return S_OK;
}

static VOID CPCAPI
delete_section(LPCPC_CRITICAL_SECTION pSection)
{
    UNUSED(pSection);
}

static VOID CPCAPI
enter_section(LPCPC_CRITICAL_SECTION pSection)
{
    down((struct semaphore *)pSection);
}

static VOID CPCAPI
leave_section(LPCPC_CRITICAL_SECTION pSection)
{
    up((struct semaphore *)pSection);
}
#endif	/* USE_USER_DEFINED_LOCKS */

static inline void CPCAPI
dprint_func(void *callback_arg, const TCHAR *str)
{
  printk(KERN_INFO "%s\n", str);
}

static inline void CPCAPI
eprint_func(void *callback_arg, const TCHAR *str)
{
  printk(KERN_ERR "%s\n", str);
}

static inline void CPCAPI
cprint_func(void *callback_arg, const TCHAR *str)
{
  return dprint_func(callback_arg, str);
}
 
static unsigned long CPCAPI
get_thread_id(void)
{
  return 0;
}

static DWORD CPCAPI
ESPGetDefaultConfig(LPCPC_CONFIG pConfig, DWORD max_sessions)
{
    const DWORD res = CPCGetDefaultConfig(pConfig, NULL);
    if(res)
	return res;
    pConfig->logConfig.name=MODNAME;
    pConfig->logConfig.level=0x1;
    pConfig->logConfig.format=0x1f;

    pConfig->logConfig.dprint_str=dprint_func;
    pConfig->logConfig.eprint_str=eprint_func;
    pConfig->logConfig.cprint_str=cprint_func;
    pConfig->logConfig.get_thread_id=get_thread_id;
//    pConfig->FuncStruct.UsesFunctions = CPC_FAST_CODE_NO;

#ifdef USE_STD_MM
    if(stdInitMemory(&pConfig->pArena, NULL, 0)) {
	return NTE_NO_MEMORY;
    }
#else
    if(drvesp_lfmmInitMemory(&pConfig->pArena, max_sessions)) {
	return NTE_NO_MEMORY;
    }
#endif /* USE_STD_MM */
#if defined USE_USER_DEFINED_LOCKS
    CSPConfig->lockFuncs.initialize_critical_section=init_section;
    CSPConfig->lockFuncs.delete_critical_section=delete_section;
    CSPConfig->lockFuncs.enter_critical_section=enter_section;
    CSPConfig->lockFuncs.leave_critical_section=leave_section;
#endif	/* USE_USER_DEFINED_LOCKS */
    return S_OK;
}

static const int Major = 100;	/* must be in sync with include/io_krn.h::MAJOR_NUM */

static int device_open;	/*  " ?" */

static int tstesp_open(struct inode *inode, struct file *file);
static int tstesp_release(struct inode *inode, struct file *file);

static 
    #ifdef TSTESP_IOCTL_INODE_ARG
	int 
    #else
        long
    #endif
	tstesp_ioctl(
    #ifdef TSTESP_IOCTL_INODE_ARG
		struct inode *inode,
    #endif
		struct file *file, 
		unsigned int ioctl_num, unsigned long ioctl_param);

static struct file_operations fops = {
    #if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
	.owner = THIS_MODULE,
    #endif
    #ifdef TSTESP_IOCTL_INODE_ARG
	.ioctl = tstesp_ioctl,
    #else
     	.unlocked_ioctl = tstesp_ioctl,
     	.compat_ioctl = tstesp_ioctl,
    #endif   
    .open    = tstesp_open,
    .release = tstesp_release
};

static int __init tstesp_init(void)
{
    int retcode;
    retcode = register_chrdev(Major, MODNAME, &fops);
    if(retcode != 0) {
	printk(KERN_ALERT MODNAME ": Registering failed: req Major=%d retcode %d\n", Major, retcode);
	return retcode;
    }

    printk(KERN_ALERT MODNAME ": Registered %d\n", Major);
    device_open = 0;

    return 0;
}

static __exit void tstesp_exit(void)
{
    unregister_chrdev(Major, MODNAME);
    printk(KERN_ALERT MODNAME ": Unregistered\n");
}

static int tstesp_open(struct inode *inode, struct file *file)
{
    if(device_open) {	 /* 2     */
	printk(KERN_ALERT MODNAME ": tstesp_open:device already opened\n");
	return -EBUSY;
    }
    device_open=1;		/* XXX dim: SMP unsafe */

    return 0;
}

static int tstesp_release(struct inode *inode, struct file *file)
{
    if(device_open)		/* XXX dim: SMP unsafe */
	device_open = 0;
    else
	printk(KERN_ALERT MODNAME ": try close closed device\n");

    return 0;
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(5,16,0)
#include <stdarg.h>
#else
#include <linux/stdarg.h>
#endif

static void CAPI_EXTC EspLog(void *pUfnAgr,
			      log_severity_t severity, unsigned uFlags,
			      const char *fmt, ...)
{
    va_list ap;
    UNUSED(pUfnAgr);
    UNUSED(severity);
    UNUSED(uFlags);

    if(fmt[0] == '-') {
	int x1, x2, x3, x4;
	va_start(ap,fmt);
	x1 = va_arg(ap, int);
	x2 = va_arg(ap, int);
	x3 = va_arg(ap, int);
	x4 = va_arg(ap, int);
	printk( KERN_ALERT "%s %x %x %x %x\n", fmt, x1, x2, x3, x4);
	va_end(ap);
    } else
    {
	va_start(ap,fmt);
	switch(severity) {
	case CAPI_EMERG:
	    printk(KERN_EMERG);
	    break;
	case CAPI_ALERT:
	    printk(KERN_ALERT);
	    break;
	case CAPI_CRIT:
	    printk(KERN_CRIT);
	    break;
	case CAPI_ERR:
	    printk(KERN_ERR);
	    break;
	case CAPI_WARNING:
	    printk(KERN_WARNING);
	    break;
	case CAPI_NOTICE:
	    printk(KERN_NOTICE);
	    break;
	case CAPI_INFO:
	    printk(KERN_INFO);
	    break;
	case CAPI_DEBUG:
	    printk(KERN_DEBUG);
	    break;
	}
	vprintk(fmt, ap);
	printk("\n");
	va_end(ap);
	return;			/*     esp_gost.ko */
    }
}

static void CAPI_EXTC 
EspSetLogLvl(void *pUfnArg, 
	     log_severity_t severity, unsigned uFlags)
{
    UNUSED(uFlags);
    UNUSED(severity);
    UNUSED(uFlags);
}

#else //!_WIN32

#define EFAULT 1
#define EINVAL EFAULT
#define KERN_ALERT
#define vmalloc(x) MemDrvAlloc(x)
#define vfree(x) MemDrvFree(x)
#define printk(...)
#define DRVSAMPLE_POOL 'DRVS'
#define MemDrvAlloc(x) ExAllocatePoolWithTag( NonPagedPool, x, DRVSAMPLE_POOL )
#define MemDrvFree(x) ExFreePoolWithTag( x, DRVSAMPLE_POOL )

int copy_from_user( char * buf, char * iobuf, int size )
{
    memcpy( buf, iobuf, size );
    return 0;
}
#define copy_to_user(x,y,z) copy_from_user(x,y,z)

#include <stdarg.h>
///    
static log_severity_t logger_level = CAPI_DEBUG;
static void CAPI_EXTC 
EspLog(void *a, 
	    log_severity_t severity, unsigned uFlags, 
	    const char *fmt, ...)
{
    va_list ap;
    (void)uFlags;
    (void)a;
    va_start(ap, fmt);
    if( severity <= logger_level )
	DbgPrint( fmt );
    va_end(ap);
}

static void CAPI_EXTC 
EspSetLogLvl(void *a, 
	      log_severity_t level, unsigned uFlags)
{
    (void)a;
    (void)level;
    (void)uFlags;
    logger_level = level;
}
HCRYPTMODULE getHCRYPTMODULE();
BOOL delHCRYPTMODULE( HCRYPTMODULE m );
#endif //!_WIN32

#ifdef _WIN32
int
tstesp_ioctl(struct inode *inode, struct file *file, 
	     unsigned int ioctl_num, ULONG_PTR ioctl_param)
#else //_WIN32
    #ifdef TSTESP_IOCTL_INODE_ARG
	int
    #else
	long
    #endif
	tstesp_ioctl(
    #ifdef TSTESP_IOCTL_INODE_ARG
	     struct inode *inode,
    #endif
	     struct file *file, 
	     unsigned int ioctl_num, unsigned long ioctl_param)
#endif //_WIN32
{
/*    drvcsp.ko */
    static const VTABLEPROVSTRUC VTABLE2001 = { 3, NULL, NULL, PROV_GOST_2001_DH, NULL, 0, (CHAR*)DEFAULT_PROV_NAME_A};

/*    esp_gost.ko */
    static struct esp_gost_in gin;
    static struct esp_gost_out gout;

    static esp_gost_handle any_h = 0; /*   handle    ESP.   .  example_ike_esp.cpp */

/*   user-space */
    static char iobuf[128*1024]; /* dim:      */

    static struct io_krn_hdr *hdr;
    static char *d;

    hdr = (struct io_krn_hdr *)iobuf;
    d = *(char **)&ioctl_param;

    (void)file;
    #ifdef TSTESP_IOCTL_INODE_ARG
	(void)inode;
    #endif

    memset( &gin, 0, sizeof(gin) );
    memset( &gout, 0, sizeof(gout) );

    /*   */
    switch(ioctl_num) {
    case CASE_CREATEHMODULE:
    case CASE_DESTROYHMODULE:
    case CASE_CREATEEPHEM:
    case CASE_DESERPUBKEY:
    case CASE_DESTROYPUB:
    case CASE_DESTROYPRIV:

    case CASE_INIT_MODULE:
    case CASE_SHUTDOWN_MODULE:
    case CASE_SPICREATE:
    case CASE_SPIDELETE:
    case CASE_SET_LOGLVL:
    case CASE_ENCAP:
    case CASE_DECAP:
	if(copy_from_user(iobuf, d, sizeof(struct io_krn_hdr))) {
	    return -EFAULT;
	}
	break;
    default:
	printk( KERN_ALERT "IOCTL:illegal ioctl_num %u\n", ioctl_num);
	return -EINVAL;
    }

    /*     */
    if(hdr->len) {		/*     */
	/*     */
	if(hdr->len > sizeof(iobuf)-sizeof(struct io_krn_hdr)) {
	    printk( KERN_ALERT "IOCTL:header.len(%u) > sizeof(internal_buf)\n", hdr->len);
	    return -EINVAL;
	}
	if(copy_from_user(iobuf+sizeof(struct io_krn_hdr), d+sizeof(struct io_krn_hdr), hdr->len)) {
	    printk( KERN_ALERT "IOCTL:copy_from_user() fail\n");
	    return -EFAULT;
	}
    }
    /*  iobuf     */

    /*      -EINVAL */
    switch(ioctl_num) {
    case CASE_CREATEHMODULE:
    {
	/*     
	 *  
	 * CPCCreateProvider
	 *  hProv
	 *  
	 *  hProv
	 *  handle CSP
	 */
	struct create_hmodule *cm = (struct create_hmodule*) iobuf;
	static HCRYPTMODULE m = 0;
	static DWORD res;
	static HCRYPTPROV hProv;
	static CRYPT_DATA_BLOB CBlob;

#ifdef _WIN32
	m = getHCRYPTMODULE();
	if(!m)
	    return -EINVAL;
#else //_WIN32

#if !defined USE_STD_MM
	int found_free = -1;
	unsigned int i;
#endif	/* USE_STD_MM */

	/* XXX dim: :   LFMM     100  ESP */
	CSPConfigBuf.cbSize = sizeof(CSPConfigBuf);
	res = ESPGetDefaultConfig(&CSPConfigBuf, 100);
	if(res) {
	    printk(KERN_ALERT "CREATEHMODULE:ESPGetDefaultConfig fail %u\n", res);
	    return -EINVAL;
	}

	res = CPCCreateProvider(&m, &CSPConfigBuf);
	if(res || !m) {
	    printk(KERN_ALERT "CREATEHMODULE:CPCCreateProvider fail res=%u m=%p\n", res, m);
	    return -EINVAL;
	}
	CSPConfig = &CSPConfigBuf;
	res = m->AcquireContext(m, &hProv, NULL, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001);
	if(res) {
	    printk(KERN_ALERT "CREATEHMODULE:AcquireContext fail %u\n", res);
	    return -EINVAL;
	}

	/*  ,       */
	if(hdr->len - sizeof(cm->hm) < 115) { /* dim: '115'    GetProvParm(..., 0, &dwDataLen, ...) */
	    m->ReleaseContext(m, hProv, 0);
	    printk(KERN_ALERT "CREATEHMODULE:req data < rcv data %d/%d\n", 115, (int)(hdr->len - sizeof(cm->hm)));
	    return -EINVAL;
	}

	CBlob.cbData = 115;
	CBlob.pbData = (BYTE*) &cm->rnd[0];
	res = m->SetProvParam(m, hProv, PP_RANDOM, (BYTE*)&CBlob, 0);
	if(res) {
	    m->ReleaseContext(m, hProv, 0);
	    printk(KERN_ALERT "CREATEHMODULE:SetProvParam(PP_RANDOM) fail %u\n", res);
	    return -EINVAL;
	}

	/* hProv    */
	res = m->ReleaseContext(m, hProv, 0);
	if(res) {
	    printk(KERN_ALERT "CREATEHMODULE:ReleaseContext fail %u\n", res);
	    return -EINVAL;
	}

#if !defined USE_STD_MM
	if( CPCs_count == sizeof(CPCs)/sizeof(CPCs[0])) {
	  printk(KERN_ALERT "CREATEHMODULE:too many HCRYPTMODULE %lu\n", (unsigned long)sizeof(CPCs)/sizeof(CPCs[0]));
	    return -EINVAL;
	}

	for(i = 0; i < sizeof(CPCs)/sizeof(CPCs[0]); i++) {
	    if(CPCs[i].hCPC == 0) {
		found_free = i;
		break;
	    }
	}
	if(found_free == -1) {
	    printk(KERN_ALERT "CREATEHMODULE: no free slot to store new HCRYPTMODULE info\n");
	    return -EINVAL;
	}

	CPCs[found_free].hCPC = m;
	CPCs[found_free].pMem = Cfg.Buffer; /* static var `Cfg' was set in ESPGetDefaultConfig --> drvesp_lfmmInitMemory call chain */
	CPCs_count++;
#endif	/* !USE_STD_MM */
#endif //_WIN32

	hdr->res = CAPI_NOERROR;
	hdr->len = sizeof(cm->hm);
	pp[++pc].module = m;
	cm->hm = pc;
	break;
    }


    case CASE_DESTROYHMODULE:
    {
	static struct destroy_hmodule *dm = (struct destroy_hmodule*) iobuf;
	static capi_result res;

#if defined(LINUX) && !defined(USE_STD_MM)
	int found = -1;
	unsigned int i;
#endif	/* USE_STD_MM */

	if(dm->hm == 0 || pp[dm->hm].module == 0) {
	    printk(KERN_ALERT "DESTROYHMODULE: HCRYPTMODULE == 0\n");
	    return -EINVAL;
	}
	
#if defined LINUX
#if !defined USE_STD_MM
	if(CPCs_count < 0) {
	    printk(KERN_ALERT "DESTROYHMODULE: try delete more than was created HCRYPTMODULEs 0x%x\n", dm->hm);
	    return -EINVAL;
	}

	for(i=0; i < sizeof(CPCs)/sizeof(CPCs[0]); i++) {
	    if(CPCs[i].hCPC == pp[dm->hm].module) {
		found = i;
		break;
	    }
	}
	if(found == -1) {
	    printk(KERN_ALERT "DESTROYHMODULE: try delete yet deleted or not created HCRYPTMODULE 0x%x\n", dm->hm);
	    return -EINVAL;
	}
#endif	/* !USE_STD_MM */

	res = pp[dm->hm].module->DestroyProvider(pp[dm->hm].module);
	if(res) {
	    printk(KERN_ALERT "DESTROYHMODULE: fail %u\n", res);
	    return -EINVAL;
	}

#if !defined USE_STD_MM
	vfree(CPCs[found].pMem);
	CPCs[found].hCPC = 0;
	CPCs[found].pMem = 0;
	CPCs_count--;
#endif	/* !USE_STD_MM */
#else
	UNUSED( res );
	if( delHCRYPTMODULE( pp[dm->hm].module ) )
	    return -EINVAL;
#endif	/* LINUX */

	hdr->res = CAPI_NOERROR;
	hdr->len = 0;
	break;
    }


    case CASE_CREATEEPHEM:
    {
        /*  handle CSP,      - PubKey
	 *  hProv
	 * CreateEphem
	 *  hPriv,   -  ,  
	 *
	 * ce->m = 0     
	 */
	static struct create_ephem *ce;
	static capi_result res;

	ce = (struct create_ephem*) iobuf;

	if(!any_h) {
	    printk(KERN_ALERT "CREATEEPHEM:not inited esp_gost\n");
	    return -EINVAL;
	}

	if(ce->hm && pp[ce->hm].module) {
	    /* hProv     DestroyPrivKey */
	    HCRYPTPROV hProv;
	    res = pp[ce->hm].module->AcquireContext(pp[ce->hm].module, &hProv, NULL, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001);
	    if(res) {
		printk(KERN_ALERT "CREATEEPHEM:AcquireContext fail %u\n", res);
		return -EINVAL;
	    }
	    {
		PRIVKEY priv = { 0, 0, 0 };
		res = any_h->sadb.CreateEphemFn(pp[ce->hm].module, hProv, hdr->uFlags, &priv, (unsigned char *)&ce->pcsadbSA[0], &ce->pusadbSALen);
		pp[++pc].key = priv.hKey;
		ce->hpK = pc;
		pp[++pc].module = priv.hModule;
		ce->hpM = pc;
		pp[++pc].prov = priv.hProv;
		ce->hpP = pc;
	    }
	    if(res != CAPI_NOERROR) {
		printk(KERN_ALERT "CREATEEPHEM:CreateEphemFn create fail %u\n", res);
	    }
	    hdr->res = res;
	    hdr->len = sizeof(ce->hm) + sizeof(ce->hpK) + sizeof(ce->hpM) + sizeof(ce->hpP) + sizeof(ce->pusadbSALen) + ce->pusadbSALen;
	    /* PRIVKEY,   -   CreateEphemFn */
	} else {		/*    */
	    res = any_h->sadb.CreateEphemFn(0, 0, 0, 0, 0, &ce->pusadbSALen);
	    if(res != CAPI_NOERROR) {
		printk(KERN_ALERT "CREATEEPHEM:CreateEphemFn size request fail %u\n", res);
	    }
	    hdr->res = res;
	    hdr->len = sizeof(ce->hm) + sizeof(ce->hpK) + sizeof(ce->hpM) + sizeof(ce->hpP) + sizeof(ce->pusadbSALen);
	    /*  -   CreateEphemFn() */
	    /* sizeof(HCRYPTMODULE) + sizeof(PRIVKEY)  -    
	     *      , ..    
	     */
	}
	break;
    }

    case CASE_DESERPUBKEY:
    {
        /*  handle ,   - PubKey,  
	 *  hProv
	 * deSerializePubKey
	 *  hProv
	 *  hPub
	 */
	static struct deserializePubKey *ds;
	static capi_result res;
	static HCRYPTPROV hProv;
	static PUBKEY_2012 key;

	ds = (struct deserializePubKey*) iobuf;

	memset( &key, 0, sizeof(key) );

	if(!ds->hm || !pp[ds->hm].module) {
	    printk(KERN_ALERT "DESERPUBKEY:ds->m == 0\n");
	    return -EINVAL;
	}
	if(!any_h) {
	    printk(KERN_ALERT "DESERPUBKEY:not inited esp_gost\n");
	    return -EINVAL;
	}
	res = pp[ds->hm].module->AcquireContext(pp[ds->hm].module, &hProv, NULL, CRYPT_VERIFYCONTEXT, (VTABLEPROVSTRUC*)&VTABLE2001);
	if(res) {
	    printk(KERN_ALERT "DESERPUBKEY:AcquireContext fail %u\n", res);
	    return -EINVAL;
	}

	res = any_h->sadb.deSerializePubKeyFn(pp[ds->hm].module, hProv, (unsigned char *)&ds->pcsadbSA[0], ds->pcsadbSALen, hdr->uFlags, &key, CSPConfig);
	if(res != CAPI_NOERROR) {
	    printk(KERN_ALERT "DESERPUBKEY:deSerializePubKeyFn fail %u\n", res);
	    return -EINVAL;
	}
	hdr->res = res;
	hdr->len = sizeof(ds->hm) + sizeof(ds->key);
	memcpy(&ds->key, &key, sizeof(PUBKEY_2012));
	
	/* hProv    */
	res = pp[ds->hm].module->ReleaseContext(pp[ds->hm].module, hProv, 0);
	if(res) {
	    printk(KERN_ALERT "DESERPUBKEY:ReleaseContext fail %u\n", res);
	    return -EINVAL;
	}
	break;
    }

    case CASE_DESTROYPUB:
    {
        /*  handle PubKey
	 * DestroyPubKey
	 */
	static struct destroyPubKey *dp;
	static capi_result res;
	static PUBKEY_2012 key;

	dp = (struct destroyPubKey*) iobuf;

	if(!any_h) {
	    printk(KERN_ALERT "DESTROYPUB:not inited esp_gost\n");
	    return -EINVAL;
	}
	memcpy(&key, &dp->key, sizeof(PUBKEY_2012));
	res = any_h->sadb.DestroyPubKeyFn(hdr->uFlags, &key);
	if(res != CAPI_NOERROR) {
	    printk(KERN_ALERT "DESTROYPUB:DestroyPubKey fail %u\n", res);
	    return -EINVAL;
	}
	hdr->res = res;
	hdr->len = 0;
	break;
    }

    case CASE_DESTROYPRIV:
    {
        /*  handle PrivKey
	 * DestroyPrivKey
	 *  hProv
	 */
	static struct destroyPrivKey *dp;
	static capi_result res;
	static HCRYPTMODULE m;
	static HCRYPTPROV   h;

	dp = (struct destroyPrivKey*) iobuf;
	m = pp[dp->hpM].module; /* DestroyKey erase hModule, hProve fields from dp->key */
	h = pp[dp->hpP].prov;

	if(!any_h) {
	    printk(KERN_ALERT "DESTROYPRIV:not inited esp_gost\n");
	    return -EINVAL;
	}
	{
	    PRIVKEY priv;
	    priv.hKey = pp[dp->hpK].key;
	    priv.hModule = pp[dp->hpM].module;
	    priv.hProv = pp[dp->hpP].prov;
	    res = any_h->sadb.DestroyPrivKeyFn(hdr->uFlags, &priv);
	    dp->hpK = 0;
	    dp->hpM = 0;
	    dp->hpP = 0;
	}
	
	if(res != CAPI_NOERROR) {
	    printk(KERN_ALERT "DESTROYPRIV:DestroyPrivKey fail %u\n", res);
	    return -EINVAL;
	}

	/* hProv    */
	res = m->ReleaseContext(m, h, 0);
	if(res) {
	    printk(KERN_ALERT "DESTROYPRIV:ReleaseContext fail %u\n", res);
	    return -EINVAL;
	}
	hdr->res = 0;
	hdr->len = 0;
	break;
    }

    case CASE_INIT_MODULE:
    {
	/*     -EINVAL ..,   
	    ,     */
	/*    ,     , 
	     kernel panic */
	static struct init_data *id;
	static capi_result res;
	static esp_gost_handle h;

	id = (struct init_data*) iobuf;

	if(hdr->len < 4*sizeof(unsigned)+id->datalen) {
	    printk(KERN_ALERT "INIT_MODULE:header->len(%u) < 4*sizeof(unsigned)+id->datalen(%u)\n",
		   hdr->len, id->datalen);
	    return -EINVAL;
	}

	memset(&gin, 0, sizeof(gin));
	gin.apiVersionMajor = id->major;
	gin.apiVersionMinor = id->minor;
	gin.maxSessions = id->num_session;
	gin.pUfnArg = 0;
	gin.LogUfn = EspLog;
	gin.SetLogLvlUfn = EspSetLogLvl;
	/*    */

	memset(&gout, 0, sizeof(gout));

	res = cpesp_init_gost(0, &gin, hdr->uFlags, &gout);
	if(res != CAPI_NOERROR) {
	    printk(KERN_ALERT "INIT_MODULE:first cpesp_init_gost() fail %u\n", res);
	    return -EINVAL;
	}
	h = (esp_gost_handle)vmalloc(gout.requiredMem);
	if(!h) {
	    printk(KERN_ALERT "INIT_MODULE:vmalloc() fail for %u\n", gout.requiredMem);
	    return -EINVAL;
	}

	gin.allocatedMem = gout.requiredMem; /*    */
	res = cpesp_init_gost(h, &gin, hdr->uFlags, &gout);

	/*     user-space     user-space */
	hdr->res = res;
	if(CAPI_NOERROR == res) {
	    any_h = h;		/*   . .   any_h */
	    id->u.eou = gout;
	    pp[++pc].pointer = (void *)h;
	    id->hh = pc;
	    /* -         */
	    hdr->len = 4*sizeof(unsigned) + sizeof(id->hh) + sizeof(struct esp_gost_out);
	    h->LogUfn(h->pUfnArg, 0, 0, "-IOCTL_INIT_MODULE:"
			"Alocated Kb:", gout.requiredMem/1024, 0, 0, 0);
	} else {
	    vfree(h);
	    h = 0;
	    any_h = 0;
	    printk(KERN_ALERT "INIT_MODULE:second cpesp_init_gost() fail %u\n", res);
	    return -EINVAL;
	}
    }
    break;

    case CASE_SHUTDOWN_MODULE:
    {
	static struct shutdown_data *sd;

	sd = (struct shutdown_data*) iobuf;

	if(hdr->len < sizeof(sd->hh)) {
	    printk(KERN_ALERT "SHUTDOWN_MODULE:header.len < sizeof(esp_gost_handle) %u < %u\n",
		   hdr->len, (unsigned)sizeof(sd->hh)); /*  gcc-3.4  4.3 */
	    return -EINVAL;
	}

	cpesp_shutdown_gost(pp[sd->hh].pointer, hdr->uFlags);
	if(pp[sd->hh].pointer)
	    vfree(pp[sd->hh].pointer);
	hdr->len = 0;
    }
    break;

    case CASE_SPICREATE:
    {
	static struct spi_create *sc;
	static esp_gost_handle h;

	sc = (struct spi_create*) iobuf;

	h = pp[sc->hh].pointer;

	if(!h) {
	    printk(KERN_ALERT "SPICREATE:header.handle is bad\n");
	    return -EINVAL;
	}
	if(!hdr->len) {
	    printk(KERN_ALERT "SPICREATE:header.len == 0\n");
	    return -EINVAL;
	}
	{
	    static ESP_HANDLE sid;
	    static PRIVKEY priv;

	    sid = 0;

	    priv.hKey = pp[sc->hpK].key;
	    priv.hModule = pp[sc->hpM].module;
	    priv.hProv = pp[sc->hpP].prov;
	    hdr->res = h->spiCreateFn(h, &priv, &sc->keyPub, (unsigned char *)&sc->pcIPsecSA[0], sc->uIPsecSALen, hdr->uFlags, &sid, CSPConfig);
	    pp[++pc].sid = sid;
	    sc->hsid = pc;
	}
	hdr->len = sizeof(sc->hsid);
    }
    break;

    case CASE_SPIDELETE:
    {
	static struct spi_delete *sd;
	if(!hdr->len) {
	    printk(KERN_ALERT "SPIDELETE:header.len == 0\n");
	    return -EINVAL;
	}
	if(!any_h) {
	    printk(KERN_ALERT "SPIDELETE:not inited esp_gost\n");
	    return -EINVAL;
	}

	sd = (struct spi_delete*) iobuf;
	any_h->destroyFn(hdr->uFlags, pp[sd->hsid].sid);
	hdr->len = 0;
    }
    break;

    case CASE_SET_LOGLVL:
    {
	static struct set_loglevel *ll;

	ll = (struct set_loglevel*) iobuf;

	if(!any_h) {
	    printk(KERN_ALERT "SET_LOGLVL:not inited esp_gost\n");
	    return -EINVAL;
	}
	if(hdr->len < sizeof(ll->level)) {
	    printk(KERN_ALERT "SET_LOGLVL:"
		    "headr.len < sizeof(log_severity_t)\n");
	    return -EINVAL;
	}

	any_h->SetLogLvlUfn(any_h->pUfnArg, ll->level, hdr->uFlags);
	hdr->len = 0;
    }
    break;

    case CASE_ENCAP:
    {
	static struct encap *ed;
	static capi_result res;

	ed = (struct encap*) iobuf;

	if(hdr->len < sizeof(ed->hsid) + sizeof(ed->datalen) + sizeof(ed->buflen)) { /*  NextProto   
										          */
	    printk(KERN_ALERT "ENCAP:"
		   "header.len < sizeof(sid)+2*sizeof(unsigned)\n");
	    return -EINVAL;
	}
	if(!any_h) {
	    printk(KERN_ALERT "ENCAP:not inited esp_gost\n");
	    return -EINVAL;
	}
	if(!ed->hsid || !pp[ed->hsid].sid) {
	    printk(KERN_ALERT "ENCAP:ed->sid = 0\n");
	    return -EINVAL;
	}
	if(ed->buflen==0) {	/*   */
	    res = any_h->espEncapFn(pp[ed->hsid].sid, hdr->uFlags, 0, 
				    0, &ed->datalen, 0, CSPConfig);
	    hdr->len =
		sizeof(ed->hsid) + sizeof(ed->datalen); /*   ed->datalen */
	} else {		/*  */
	    res = any_h->espEncapFn(pp[ed->hsid].sid, hdr->uFlags, (char *)&ed->NextProto,
				    &ed->d[0], &ed->datalen, ed->buflen, CSPConfig);
	    hdr->len =
		sizeof(ed->hsid) + sizeof(ed->datalen) + sizeof(ed->buflen)
		+ sizeof(ed->NextProto) + ed->datalen;
	}
	hdr->res = res;
    }
    break;

    case CASE_DECAP:
    {
	static struct decap *dd;
	static char NextProto;

	dd = (struct decap*) iobuf;

	if(hdr->len < sizeof(dd->hsid) + 2*sizeof(unsigned)+dd->datalen) {
	    printk(KERN_ALERT "DECAP:header.len(%u) < sizeof(sid)+2*sizeof(unsigned)+buflen(%u)\n", 
		   hdr->len, dd->datalen);
	    return -EINVAL;
	}
	if(!any_h) {
	    printk(KERN_ALERT "DECAP:not inited esp_gost\n");
	    return -EINVAL;
	}
	if(!dd->hsid || !pp[dd->hsid].sid) {
	    printk(KERN_ALERT "DECAP:dd->sid = 0\n");
	    return -EINVAL;
	}

	hdr->res = any_h->espDecapFn(pp[dd->hsid].sid, hdr->uFlags,
				     &NextProto, dd->d, &dd->datalen, CSPConfig);
	dd->NextProto = NextProto & 0xff;
	hdr->len = sizeof(dd->hsid) + 2*sizeof(unsigned) + dd->datalen;
    }
    break;

    default:			/*  .   */
	printk( KERN_ALERT "module corrupted\n");
	return -EINVAL;
    }
    if(copy_to_user(d, iobuf, sizeof(struct io_krn_hdr)+hdr->len)) {
	printk( KERN_ALERT "copy_to_user fail\n");
	return -EFAULT;
    }
    return 0;
}

#ifndef _WIN32
//EXPORT_SYMBOL(tstesp_ioctl);	/*   */

module_init(tstesp_init);
module_exit(tstesp_exit);

#endif //!_WIN32
