/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 149710 $
 * \date $Date:: 2016-12-02 19:08:11 +0300#$
 * \author $Author: sonina $
 *
 * \brief
 *
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef HAVE_CPRO_CONFIG_H
#include "myconfig.h"
#endif

#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#   include "platformstream.h"
#else
#   include <arpa/inet.h> // htonl()
#endif
#include "wincspc.h"

#include "ike_gost.h"
#include "init_plg.h"

#ifdef TEST_CONFORMITY
#   include "../../Conformity/ConformityIPSEC.h"
extern LPCONF_IPSEC pC2I,pC2R;
extern vblob **pikepckt;
extern LPCONF_IPSEC pC_pikepckt;
extern char pSA_i[40];
extern char pSA_r[28];
extern void SetSAp2();
#endif  /* TEST_CONFORMITY */
#define IKEPACKET_ENCRYPT 1

#include "example.h"

static char buf[10000];
static ikeHDR *ih = (ikeHDR*)buf;

unsigned
phase_2_qm(p2_ir_state *i2, p2_ir_state *r2, bool pfs, bool commit)
{
    unsigned rc;
    int line;

    unsigned enc_len, save_enc_len, dec_len;

    static const char d_M_ID[4] = { 'a', 'b', 'c', 'd'};
    static const vblob * M_ID = vcreate(GetCPCConfig(), DT_M_ID, (char *)d_M_ID, sizeof(d_M_ID));

    static const char d_IDci[4]={1,2,3,1}; /* ID_IPV4_ADDR- 4   */
    static const char d_IDcr[4]={3,2,125,2};
    static const vblob * IDci = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)d_IDci, sizeof(d_IDci));
    static const vblob * IDcr = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)d_IDcr, sizeof(d_IDcr));

    vblob *pKEqmi = 0;
    vblob *pKEqmr = 0;

    vblob *pHASH_1;
    vblob *pHASH_2;
    vblob *pHASH_3;
    vblob *pNi, *pNr;

#ifndef TEST_CONFORMITY
    static const char d_SAqm[] = {2,2,2,2};
    vblob * SAqm = vcreate(GetCPCConfig(), DT_SA, (char *)d_SAqm, sizeof(d_SAqm));
#else
    // SA    
    SetSAp2();
    vblob * SAqm_i, * SAqm_r;
    SAqm_i = vcreate(GetCPCConfig(), DT_SA, pSA_i, sizeof(pSA_i));
    SAqm_r = vcreate(GetCPCConfig(), DT_SA, pSA_r, sizeof(pSA_r));
#endif  /* TEST_CONFORMITY */

    // --------------Initiator
    CPIKE_GROUP_T group_id;
    group_id = CPIKE_GROUP_XchB;

    if(!pfs) {
	i2->plg->p1_SetParamFn(i2->p1,CPIKE_AC_PFS_Control,CPIKE_PFSC_Enable_Non_PFS,0,0);
	r2->plg->p1_SetParamFn(r2->p1,CPIKE_AC_PFS_Control,CPIKE_PFSC_Enable_Non_PFS,0,0);
    } else {
	i2->plg->p1_SetParamFn(i2->p1,CPIKE_AC_PFS_Control,CPIKE_PFSC_Disable_Non_PFS,0,0);
	r2->plg->p1_SetParamFn(r2->p1,CPIKE_AC_PFS_Control,CPIKE_PFSC_Disable_Non_PFS,0,0);
    }

    CERR(i2->plg->p2_CreateFn(i2->plg, i2->p1, IKE_INITIATOR, M_ID, 0, &i2->p2));

    if(pfs) {
	CERR(i2->plg->p2_SetParamFn(i2->p2, CPIPSEC_AT_Group_Description, group_id, 0, 0));
    }
    CERR(i2->plg->p2_SetupFn(i2->p2, 0, pfs ? &pKEqmi : 0, &pNi));

    // HASH(1) = prf(SKEYID_a, M-ID | SA | Ni [ | KEqmi ] [ | IDci | IDcr])
#ifndef TEST_CONFORMITY
    CERR(i2->plg->p2_HashAFn(i2->p2, 0, &pHASH_1, 5, SAqm, pNi, pKEqmi, IDci, IDcr));
#else
    CERR(i2->plg->p2_HashAFn(i2->p2, 0, &pHASH_1, 5, SAqm_i, pNi, pKEqmi, IDci, IDcr));
#endif /*TEST_CONFORMITY*/

#ifdef TEST_CONFORMITY
    FLGS FlgsI2,FlgsR2;
    FlgsI2.d=0;FlgsR2.d=0;
    FlgsI2.f.ConfType=CONF_IKE_P2;    FlgsR2.f.ConfType=CONF_IKE_P2;
    FlgsI2.f.isEnc1Pack=1;
    FlgsI2.f.isInit=1;
    FlgsI2.f.isPh2=1;	FlgsR2.f.isPh2=1;
    if(pfs) {
	FlgsI2.f.isPFS=1;
	FlgsR2.f.isPFS=1;
    }
    if(pC2I)
	CERR(reinitvblob(DT_DWORD, (LPBYTE)&FlgsI2,  sizeof(DWORD), &pC2I->Flgsp2, pC2I, __FUNCTION__, __LINE__));
    if(pC2R)
	CERR(reinitvblob(DT_DWORD, (LPBYTE)&FlgsR2,  sizeof(DWORD), &pC2R->Flgsp2, pC2R, __FUNCTION__, __LINE__));
    if(pC2I)
	CERR(reinitvblob(DT_BYTE, (LPBYTE)vref( pHASH_1 ), vsize( pHASH_1 ), &pC2I->HASH1_, pC2I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    // Send HDR*<HASH(1), SA, Ni, KEi, IDci, IDcr> [ ,  KEi == g(qm)^x]
    memset(buf, 0, sizeof(buf) );
    memcpy(ih->CKY_I, vref( (vblob *)i2->CKY ), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref( (vblob *)r2->CKY ), sizeof(ih->CKY_R));
    memcpy(ih->MessageID, vref( (vblob *)M_ID ), sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(pHASH_1, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(SAqm, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(pNi, buf, &enc_len, sizeof(buf)));
    if (pfs)
	CERR(send2buf(pKEqmi, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(IDci, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(IDcr, buf, &enc_len, sizeof(buf)));

    unsigned al;
    char *d;
    vblob *v;
    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate(GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    PLTYPE PlT;
    ih->next_header = tHash;
    ih->version = 1; 
    ih->exchange_type = 0;//Quick_Mode;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=Security_Association;	PlT.curr=tHash;
    CERR(send2bufex(PlT, pHASH_1, buf, &enc_len, sizeof(buf)));
    PlT.next=Nonce_;
    PlT.curr=Security_Association;
    CERR(send2bufex(PlT, SAqm_i, buf, &enc_len, sizeof(buf)));
    if(pfs)
	PlT.next=Key_Exchange;
    else
	PlT.next=Identification;
    PlT.curr=Nonce_;
    CERR(send2bufex(PlT, pNi, buf, &enc_len, sizeof(buf)));
    if (pfs) {
	PlT.next=Identification;	PlT.curr=Key_Exchange;
	CERR(send2bufex(PlT, pKEqmi, buf, &enc_len, sizeof(buf)));
    }
    PlT.next=Identification;	PlT.curr=Identification;
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, IDci, buf, &enc_len, sizeof(buf)));
    PlT.next=0;			PlT.curr=Identification;
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, IDcr, buf, &enc_len, sizeof(buf)));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(i2->plg->p2_EncapFn(i2->p2, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &pC2I->P2_1;
    pC_pikepckt = pC2I;
    //if(pC2I) CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2I->P2_1));
#endif  /* TEST_CONFORMITY */
    CERR(i2->plg->p2_EncapFn(i2->p2, 0, buf, &enc_len, sizeof(buf)));

    // --------------Responder
    // Receive HDR*<HASH(1), SA, Ni, KEi, IDci, IDcr>
    CERR(r2->plg->p2_CreateFn(r2->plg, r2->p1, IKE_RESPONDER, M_ID, 0, &r2->p2));

#ifdef TEST_CONFORMITY
    pC2I->P2_1=*pikepckt;
    if(pC2R)
	CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2R->P2_1, pC2R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(r2->plg->p2_DecapFn(r2->p2, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);

    {
	vblob *HASH_1_rcv;
	vblob *SAqm_rcv;
	vblob *Ni_rcv;
	vblob *KEqmi_rcv = 0;
	vblob *IDci_rcv;
	vblob *IDcr_rcv;
	//    vblob/    
#ifndef TEST_CONFORMITY
	CERR(recv4buf(&HASH_1_rcv, DT_HASH, buf, &dec_len, enc_len));
	CERR(recv4buf(&SAqm_rcv, DT_SA, buf, &dec_len, enc_len));
	CERR(recv4buf(&Ni_rcv, DT_NONCE, buf, &dec_len, enc_len));
	if (pfs)
	    CERR(recv4buf(&KEqmi_rcv, DT_KEY, buf, &dec_len, enc_len));
	CERR(recv4buf(&IDci_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&IDcr_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
#else
	PlT.curr=tHash;
	CERR(recv4bufex(&PlT, &HASH_1_rcv, DT_HASH, buf, &dec_len, enc_len));
	PlT.curr=Security_Association;
	CERR(recv4bufex(&PlT,&SAqm_rcv, DT_SA, buf, &dec_len, enc_len));
	PlT.curr=Nonce_;
	CERR(recv4bufex(&PlT,&Ni_rcv, DT_NONCE, buf, &dec_len, enc_len));
	if (pfs) {
	    PlT.curr=Key_Exchange;
	    CERR(recv4bufex(&PlT, &KEqmi_rcv, DT_KEY, buf, &dec_len, enc_len));
	}
	PlT.curr=Identification;
	CERR(recv4bufex(&PlT, &IDci_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Identification;
	CERR(recv4bufex(&PlT, &IDcr_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
#endif  /* TEST_CONFORMITY */
	// XXX dim:   HASH_1_rcv, HASH_1
	// XXX dim:   SAqm_rcv, SAqm
	// XXX dim:   Ni_rcv, Ni
	// XXX dim:   KEqmi_rcv, KEqmi
	// XXX dim:   IDci_rcv, IDci
	// XXX dim:   IDcr_rcv, IDcr
	vdelete(&HASH_1_rcv);
	vdelete(&Ni_rcv);
	vdelete(&KEqmi_rcv);
	vdelete(&IDci_rcv);
	vdelete(&IDcr_rcv);
#ifndef TEST_CONFORMITY
    //      -->   ""
    // Verify HASH(1) == prf(SKEYID_a, M-ID | SA | Ni [ | KEi ] [ | IDci | IDcr])

	CERR(r2->plg->p2_VerifyAFn(r2->p2, 0, pHASH_1, 5, SAqm, pNi, pKEqmi, IDci, IDcr));
#else
	CERR(r2->plg->p2_VerifyAFn(r2->p2, 0, pHASH_1, 5, SAqm_rcv, pNi, pKEqmi, IDci, IDcr));
#endif  /* TEST_CONFORMITY */
	vdelete(&SAqm_rcv);
	vdelete(&pHASH_1);
    }

    if(pfs) {
	CERR(r2->plg->p2_SetParamFn(r2->p2, CPIPSEC_AT_Group_Description, group_id, 0, 0));
    }
    CERR(r2->plg->p2_SetupFn(r2->p2, 0, pfs ? &pKEqmr : 0, &pNr));
    CERR(r2->plg->p2_AgreeFn(r2->p2, pKEqmi, pNi, 0));

    // HASH(2) = prf(SKEYID_a, M-ID | Ni_b | SA | Nr [ | KEr ] [ | IDci |IDcr])
#ifndef TEST_CONFORMITY
    CERR(r2->plg->p2_HashAFn(r2->p2, 0, &pHASH_2, 6, pNi, SAqm, pNr, 
						    pKEqmr, IDci, IDcr));
#else
    CERR(r2->plg->p2_HashAFn(r2->p2, 0, &pHASH_2, 6, pNi, SAqm_r, pNr, 
						    pKEqmr, IDci, IDcr));
#endif  /* TEST_CONFORMITY */
#ifdef TEST_CONFORMITY
    if(pC2R)
	CERR(reinitvblob(DT_BYTE, (LPBYTE)vref( pHASH_2 ), vsize( pHASH_2 ), &pC2R->HASH2_, pC2R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */

    // Send HDR*<HASH(2), SA, Nr, KEqmr, IDci, IDcr> [ ,  KEqmr == g(qm)^y]
    memset(buf, 0, sizeof(buf) );
    memcpy(ih->CKY_I, vref( (vblob *)i2->CKY ), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref( (vblob *)r2->CKY ), sizeof(ih->CKY_R));
    memcpy(ih->MessageID, vref( (vblob *)M_ID ), sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(pHASH_2, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(SAqm, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(pNr, buf, &enc_len, sizeof(buf)));
    if (pfs)
	CERR(send2buf(pKEqmr, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(IDci, buf, &enc_len, sizeof(buf)));
    CERR(send2buf(IDcr, buf, &enc_len, sizeof(buf)));

    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate(GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    ih->next_header = tHash;
    ih->version = 1; 
    ih->exchange_type = 0;//Quick_Mode;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=Security_Association;	PlT.curr=tHash;
    CERR(send2bufex(PlT, pHASH_2, buf, &enc_len, sizeof(buf)));
    PlT.next=Nonce_;	PlT.curr=Security_Association;
    CERR(send2bufex(PlT, SAqm_r, buf, &enc_len, sizeof(buf)));
    if(pfs)
	PlT.next=Key_Exchange;
    else
	PlT.next=Identification;
    PlT.curr=Nonce_;
    CERR(send2bufex(PlT, pNr, buf, &enc_len, sizeof(buf)));
    if (pfs) {
	PlT.next=Identification;	PlT.curr=Key_Exchange;
	CERR(send2bufex(PlT, pKEqmr, buf, &enc_len, sizeof(buf)));
    }
    PlT.next=Identification;	PlT.curr=Identification;
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, IDci, buf, &enc_len, sizeof(buf)));
    PlT.next=0;			PlT.curr=Identification;
    PlT.id=ID_IPV4_ADDR;
    CERR(send2bufex(PlT, IDcr, buf, &enc_len, sizeof(buf)));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(r2->plg->p2_EncapFn(r2->p2, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &pC2R->P2_2;
    pC_pikepckt = pC2R;
    //if(pC2R) CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2R->P2_2));
#endif  /* TEST_CONFORMITY */
    CERR(r2->plg->p2_EncapFn(r2->p2, 0, buf, &enc_len, sizeof(buf)));

    // --------------Initiator
    // Receive HDR*<HASH(2), SA, Nr, KEr, IDci, IDcr>
#ifdef TEST_CONFORMITY
    pC2R->P2_2=*pikepckt;
    if(pC2I)
	CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2I->P2_2, pC2I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(i2->plg->p2_DecapFn(i2->p2, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);
    {
	vblob *HASH_2_rcv;
	vblob *SAqm_rcv;
	vblob *Nr_rcv;
	vblob *KEqmr_rcv = 0;
	vblob *IDci_rcv;
	vblob *IDcr_rcv;
	//    vblob/    
#ifndef TEST_CONFORMITY
	CERR(recv4buf(&HASH_2_rcv, DT_HASH, buf, &dec_len, enc_len));
	CERR(recv4buf(&SAqm_rcv, DT_SA, buf, &dec_len, enc_len));
	CERR(recv4buf(&Nr_rcv, DT_NONCE, buf, &dec_len, enc_len));
	if (pfs)
	    CERR(recv4buf(&KEqmr_rcv, DT_KEY, buf, &dec_len, enc_len));
	CERR(recv4buf(&IDci_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	CERR(recv4buf(&IDcr_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
#else
	PlT.curr=tHash;
	CERR(recv4bufex(&PlT, &HASH_2_rcv, DT_HASH, buf, &dec_len, enc_len));
	PlT.curr=Security_Association;
	CERR(recv4bufex(&PlT, &SAqm_rcv, DT_SA, buf, &dec_len, enc_len));
	PlT.curr=Nonce_;
	CERR(recv4bufex(&PlT, &Nr_rcv, DT_NONCE, buf, &dec_len, enc_len));
	if (pfs) {
	    PlT.curr=Key_Exchange;
	    CERR(recv4bufex(&PlT, &KEqmr_rcv, DT_KEY, buf, &dec_len, enc_len));
	}
	PlT.curr=Identification;
	CERR(recv4bufex(&PlT, &IDci_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	PlT.curr=Identification;
	CERR(recv4bufex(&PlT, &IDcr_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
#endif  /* TEST_CONFORMITY */
	// XXX dim:   HASH_2_rcv, HASH_2
	// XXX dim:   SAqm_rcv, SAqm
	// XXX dim:   Nr_rcv, Nr
	// XXX dim:   KEqmr_rcv, KEqmr
	// XXX dim:   IDci_rcv, IDci
	// XXX dim:   IDcr_rcv, IDcr
	vdelete(&HASH_2_rcv);
	vdelete(&Nr_rcv);
	vdelete(&KEqmr_rcv);
	vdelete(&IDci_rcv);
	vdelete(&IDcr_rcv);
#ifndef TEST_CONFORMITY
	//      -->   ""
	// Verify HASH(2) = prf(SKEYID_a, M-ID | Ni_b | SA | Nr [ | KEqmr ] [ | IDci |IDcr])
	CERR(i2->plg->p2_VerifyAFn(i2->p2, 0, pHASH_2, 6, pNi, SAqm, pNr, 
						    pKEqmr, IDci, IDcr));
#else
	CERR(i2->plg->p2_VerifyAFn(i2->p2, 0, pHASH_2, 6, pNi, SAqm_rcv, pNr, 
						    pKEqmr, IDci, IDcr));
#endif  /* TEST_CONFORMITY */
	vdelete(&SAqm_rcv);
	vdelete(&pNi);
    }
    
#ifdef TEST_CONFORMITY
    if(pC2I)
	CERR(reinitvblob(DT_BYTE, (LPBYTE)vref( pHASH_2 ), vsize( pHASH_2 ), &pC2I->HASH2_, pC2I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    vdelete(&pHASH_2);

    CERR(i2->plg->p2_AgreeFn(i2->p2, pKEqmr, pNr, 0));
    vdelete(&pNr);

    // HASH(3) = prf(SKEYID_a, 0 | M-ID | Ni_b | Nr_b)
    CERR(i2->plg->p2_Hash3Fn(i2->p2, 0, &pHASH_3));
#ifdef TEST_CONFORMITY
    if(pC2I)
	CERR(reinitvblob(DT_BYTE, (LPBYTE)vref( pHASH_3 ), vsize( pHASH_3 ), &pC2I->HASH3_, pC2I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */

    // Send HDR*<HASH(3)>
    memset(buf, 0, sizeof(buf));
    memcpy(ih->CKY_I, vref( (vblob *)i2->CKY ), sizeof(ih->CKY_I));
    memcpy(ih->CKY_R, vref( (vblob *)r2->CKY ), sizeof(ih->CKY_R));
    memcpy(ih->MessageID, vref( (vblob *)M_ID ), sizeof(ih->MessageID));
    enc_len=sizeof(ikeHDR);
#ifndef TEST_CONFORMITY
    CERR(send2buf(pHASH_3, buf, &enc_len, sizeof(buf)));

    al = 42;
    al *= 4;			//  Payloads ..  4
    d = (char*) calloc(al,1);
    v = vcreate(GetCPCConfig(), DT_EXTDATA, d, al);
    CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
    vdelete(&v);
    free(d);
#else
    ih->next_header = tHash;
    ih->version = 1; 
    ih->exchange_type = 0;//Quick_Mode;
    ih->flags = IKEPACKET_ENCRYPT;
    PlT.next=0;	PlT.curr=tHash;
    CERR(send2bufex(PlT, pHASH_3, buf, &enc_len, sizeof(buf)));
#endif  /* TEST_CONFORMITY */

    save_enc_len = enc_len;
    CERR(i2->plg->p2_EncapFn(i2->p2, 0, NULL, &enc_len, sizeof(buf)));
    ih->Length = htonl(enc_len);
    ih->flags = IKEPACKET_ENCRYPT;
    enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
    pikepckt = &pC2I->P2_3;
    pC_pikepckt = pC2I;
    //if(pC2I) CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2I->P2_3));
#endif  /* TEST_CONFORMITY */
    CERR(i2->plg->p2_EncapFn(i2->p2, 0, buf, &enc_len, sizeof(buf)));

    // --------------Responder
    // Receive HDR*<HASH(3)>
#ifdef TEST_CONFORMITY
    pC2I->P2_3=*pikepckt;
    if(pC2R)
	CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2R->P2_3, pC2R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
    CERR(r2->plg->p2_DecapFn(r2->p2, 0, buf, &enc_len));
    dec_len=sizeof(ikeHDR);
    {
	vblob *HASH_3_rcv;
	//    vblob/    
#ifndef TEST_CONFORMITY
	CERR(recv4buf(&HASH_3_rcv, DT_HASH, buf, &dec_len, enc_len));
#else
	PlT.curr=tHash;
	CERR(recv4bufex(&PlT, &HASH_3_rcv, DT_HASH, buf, &dec_len, enc_len));
#endif  /* TEST_CONFORMITY */
	// XXX dim:   HASH_3_rcv, HASH_3
	vdelete(&HASH_3_rcv);
    }

    //      -->   ""
    // HASH(3) = prf(SKEYID_a, 0 | M-ID | Ni_b | Nr_b)
    CERR(r2->plg->p2_Verify3Fn(r2->p2, pHASH_3, 0));
    vdelete(&pHASH_3);

    if(commit) {    
	//    C(ommit Bit) 
	//   "CONNECTED Notify Message"

	// --------------Responder [continue, if C(ommit Bit) set]
	char Connected[2];
	vblob *pHASH_4;

	Connected[0] = 16384/256;
	Connected[1] = 16384%256;
	vblob * NtfyDel = vcreate(GetCPCConfig(), DT_EXTDATA, (char *)Connected, sizeof(Connected));

	// HASH(1') = prf(SKEYID_a, M-ID | Notify)
	CERR(r2->plg->p2_HashAFn(r2->p2, 0, &pHASH_4, 1, NtfyDel));
#ifdef TEST_CONFORMITY
	if(pC2R)
	    CERR(reinitvblob(DT_BYTE, (LPBYTE)vref( pHASH_4 ), vsize( pHASH_4 ), &pC2R->HASH4_, pC2R, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */

	// Send HDR*<HASH(1'), Notify>
	memset(buf, 0, sizeof(buf) );
	memcpy(ih->CKY_I, vref( (vblob *)i2->CKY ), sizeof(ih->CKY_I));
	memcpy(ih->CKY_R, vref( (vblob *)r2->CKY ), sizeof(ih->CKY_R));
	memcpy(ih->MessageID, vref( (vblob *)M_ID ), sizeof(ih->MessageID));
	enc_len=sizeof(ikeHDR);
	CERR(send2buf(pHASH_4, buf, &enc_len, sizeof(buf)));
	CERR(send2buf(NtfyDel, buf, &enc_len, sizeof(buf)));

#ifdef TEST_CONFORMITY
	unsigned al;
	char *d;
	vblob *v;
#endif  /* TEST_CONFORMITY */

	al = 42;
	al *= 4;			//  Payloads ..  4
	d = (char*) calloc(al,1);
	v = vcreate(GetCPCConfig(), DT_EXTDATA, d, al);
	CERR(send2buf(v, buf, &enc_len, sizeof(buf)));
	vdelete(&v);
	free(d);

	save_enc_len = enc_len;
	CERR(r2->plg->p2_EncapFn(r2->p2, 0, NULL, &enc_len, sizeof(buf)));
	ih->flags = IKEPACKET_ENCRYPT;
	ih->Length = htonl(enc_len);
        enc_len = save_enc_len;
#ifdef TEST_CONFORMITY
	pikepckt = &pC2R->P2_4;
	pC_pikepckt = pC2R;
	//if(pC2R) CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2R->P2_4));
#endif  /* TEST_CONFORMITY */
	CERR(r2->plg->p2_EncapFn(r2->p2, 0, buf, &enc_len, sizeof(buf)));

	// Receive HDR*<HASH(1'), Notify>
#ifdef TEST_CONFORMITY
	pC2R->P2_4=*pikepckt;
	if(pC2I)
	    CERR(reinitvblob(DT_BYTE, (LPBYTE)buf,  enc_len, &pC2I->P2_4, pC2I, __FUNCTION__, __LINE__));
#endif  /* TEST_CONFORMITY */
	CERR(i2->plg->p2_DecapFn(i2->p2, 0, buf, &enc_len));
	dec_len=sizeof(ikeHDR);
	{
	    vblob *HASH_4_rcv;
	    vblob *NtfyDel_rcv;

	    CERR(recv4buf(&HASH_4_rcv, DT_HASH, buf, &dec_len, enc_len));
	    CERR(recv4buf(&NtfyDel_rcv, DT_EXTDATA, buf, &dec_len, enc_len));
	    // HASH_4 == HASH_4_rcv
	    // NtfyDel == NtfyDel_rcv
	    vdelete(&HASH_4_rcv);
	    vdelete(&NtfyDel_rcv);
	}
	// Verify HASH(1') = prf(SKEYID_a, M-ID | Notify)
	CERR(i2->plg->p2_VerifyAFn(i2->p2, 0, pHASH_4, 1, NtfyDel));
	vdelete(&pHASH_4);
	vdelete(&NtfyDel);
    }
    if(pKEqmi)
	vdelete(&pKEqmi);
    if(pKEqmr)
	vdelete(&pKEqmr);
#if defined TEST_CONFORMITY
    vdelete(&SAqm_i);
    vdelete(&SAqm_r);
#else
    vdelete(&SAqm);
#endif	// TEST_CONFORMITY

    return 0;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    return rc;
}
