/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*!
 * \file $RCSfile: example.h,v $
 * \version $Revision: 185076 $
 * \date $Date:: 2018-11-26 17:33:40 +0300#$
 * \author $Author: maxdm $
 *
 * \brief
 *
 */

#ifndef EXAMPLE_H_INCLUDED
#define EXAMPLE_H_INCLUDED 1

#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#else
#   include <CSP_WinCrypt.h>
#endif
#include "ike_gost.h"
#include "esp_gost.h"
#include "ike_cert.h"

#ifndef EXAMPLE_LOG_LEVEL
#if defined _DEBUG
    #define EXAMPLE_LOG_LEVEL   CAPI_DEBUG
#else
    #define EXAMPLE_LOG_LEVEL   CAPI_INFO
#endif // _DEBUG
#endif //EXAMPLE_LOG_LEVEL

/*
 *      
 *  CERR(x)    :
 *	unsigned     rc   -  ;
 *	unsigned     line -  ;
 *      err:              -   ;
 */
#define CERR_START unsigned rc; unsigned line
#define CERR_END   return CAPI_NOERROR; err
#define CERR(x) { \
	    rc = (x);\
	    if ( rc ) {\
		line=__LINE__;\
		goto err;\
	    }\
	}
//#define STACK_PRINT
#ifdef STACK_PRINT
#include "../samples/support/checkstack.h"
#undef EXAMPLE_LOG_LEVEL
#define EXAMPLE_LOG_LEVEL CAPI_EMERG
#define CERRSTACK(x,c) { \
	    volatile cp_stack_t * cpstack = 0;\
	    cpstack = ConditionalGetP( 0, 3 );\
	    rc = (x);\
	    ConditionalCheckP( cpstack, 0, 3, &last_stack_size );\
	    if ( rc & c ) {\
		line=__LINE__;\
		goto err;\
	    }\
	}
#else //STACK_PRINT
#define CERRSTACK(x,c) { \
	    rc = (x);\
	    if ( rc & c ) {\
		line=__LINE__;\
		goto err;\
	    }\
	}
#endif //STACK_PRINT
#define CERRASSERT(x, error)   {\
	    if (!(x)) {\
	        rc = (error);\
		LOG(CAPI_ERR, (line = __LINE__), sid, "FAIL: %s", #x);\
		goto err;\
	    }\
	}

#if (__STDC_VERSION__ >= 199901L || defined(__GNUC__)) || _WIN32
// gcc extension ##
# define LOG(level, line, sid, text, ...) printf(/*level,*/	\
                  "%s:%d. " text, __FUNCTION__, line,\
		  /*sid,*/ ##__VA_ARGS__)
#endif

typedef struct sa_type {
    CPIKE_AUTH_T am;
    CPIKE_ENC_T enc_mac_id;
    CPIKE_HASH_T hash_id;
    CPIKE_GTYPE_T gtype_id;
    CPIKE_GROUP_T group_id;
} sa_type_t;

#define IPhdrlen    20	// len of ip header for AH

class p1_ir_state {
  public:
  p1_ir_state(const vblob *vid[5],
	      const vblob * sai_b, const sa_type_t & satype,
	      const vblob * cky,
	      vblob * idb,
	      const vblob * netid, const vblob * site_id, const vblob * psk, const vblob * site_psk,
	      PBYTE pbpin, PCHAR pszcont, PCHAR pszprov, DWORD dwpt, DWORD dwpwf)
      : Vendor_IDs(vid),
	SA_b(sai_b), SAtype(satype),
	CKY(cky),
	ID_b(idb),
	NetID(netid), Site_ID(site_id), PSK(psk), Site_PSK(site_psk),
	pbPIN(pbpin), pszCont(pszcont), pszProv(pszprov), dwPT(dwpt), dwPFW(dwpwf)
    {};

    ~p1_ir_state() {};

    const vblob ** Vendor_IDs;

    const vblob * SA_b; //  ISAKMP SA,   
    const sa_type_t SAtype;	//  ISAKMP SA

    const vblob * CKY; //    DoS,  

    vblob * ID_b;

    const vblob * NetID;
    const vblob * Site_ID;
    const vblob * PSK;
    const vblob * Site_PSK;

    PBYTE pbPIN;
    PCHAR pszCont;
    PCHAR pszProv;
    const DWORD dwPT;
    const DWORD dwPFW;

    /*   */
    ike_gost_handle plg;
    vblob * CERT_b;
    vblob * BLOB_b;

    vblob * p1_data;

    P1_HANDLE p1;
    P1_HANDLE p1_from_cache; //   

  private:
    /*  default */
    p1_ir_state();
    p1_ir_state(const p1_ir_state&);
    p1_ir_state& operator=(const p1_ir_state&);
};

typedef struct saqm_type {
    CPIKE_GROUP_T group_id;
} saqm_type_t;

struct p2_ir_state {
    p2_ir_state() {};
    ~p2_ir_state() {};

    p1_ir_state *parent;
    ike_gost_handle plg;
    P1_HANDLE p1;
    P1_HANDLE p1_from_cache;
    P2_HANDLE p2;
    esp_gost_handle esp;

    const vblob* CKY;	    /*     1 */

private:
    p2_ir_state(const p2_ir_state&);
    p2_ir_state& operator=(const p2_ir_state&);
};

typedef struct psk_data {
	// PSK 
    const vblob * NetID;
    const vblob * Site_ID;
    const vblob * PSK;
    const vblob * Site_PSK;
} psk_data_t;

typedef struct cert_data {
	// CERT   ike
    PBYTE pbPIN;
    PCHAR pszCont;
    PCHAR pszProv;
    DWORD dwPT;
    DWORD dwPFW;
    HCRYPTPROV hCertProv;
} cert_data_t;

#if defined TEST_CONFORMITY
class user_space {
public:
	user_space();
	~user_space();
	
	//     user-space 
	const vblob **Vendor_IDs;		// 
	psk_data_t psk_data[1];			//    psk
	cert_data_t cert_data[1];		//     ( )
	vblob * IDc;				// ip  
	const vblob * CKY;			// cookies

	ike_gost_handle ike_plg;		//     ike (p1, p2)
	ike_gost_handle sadb_plg;		//    SADB ( serialize, deserialize )
	
	PRIVKEY hPrivSADB;			//     SADB
	PRIVKEY hPrivKERNEL;			//    
	BYTE buf[512];				//     
	CRYPT_DATA_BLOB PublicData;		//      
	BYTE bufkern[512];			//       
	CRYPT_DATA_BLOB PublicDataKERNEL;	//        
	PUBKEY_2012 hPubSADB;			//    SADB
	PUBKEY_2012 hPubKERNEL;			//   

	PUBKEY_2012 hPubs[2];			//    ( sadb_s)

	HCRYPTPROV hProvSADB;			//   sadb_plg
	LPCTSTR pszProv;			//  
	DWORD dwPT;				// PROV_GOST_2001_DH 

	p1_ir_state * p1[1];			//   p1
	p2_ir_state * p2[1];			//   p2
  private:
    user_space(const user_space&);
    user_space& operator=(const user_space&);
};

class kernel_space {
public:
	kernel_space();
	kernel_space( unsigned n );
	~kernel_space();
	
	esp_gost_handle esp_plg;		//     esp (spi)

	HCRYPTPROV hProvKERNEL;			//    kernel <-> user
	PRIVKEY hPrivKERNEL;			//    user
	PUBKEY_2012 hPubUSERSPACE;			//   user

	BYTE buf[512];				//     
	CRYPT_DATA_BLOB PublicData;		//      

	ESP_HANDLE spi[10];			//   esp
  private:
    kernel_space(const kernel_space&);
    kernel_space& operator=(const kernel_space&);
};
#endif	/* TEST_CONFORMITY */

/* IKE  */
typedef struct tIKEpktHeader {
    BYTE CKY_I[8];	 /*    */
    BYTE CKY_R[8];	 /*    */
    BYTE next_header;
    BYTE version;
    BYTE exchange_type;
    BYTE flags;		 /*   E (1) */
    BYTE MessageID[4];	 /*   */
    DWORD Length;	 /*   */
} ikeHDR;

extern void 
example_certificate_usage();

extern capi_result
correct_p1_LifeDur(ike_gost_handle plg, P1_HANDLE p1, time_t tNotAfter);

extern capi_result
send2buf(const vblob *v, char *pcData, unsigned *uDataLen, unsigned uBufLen);

extern capi_result
recv4buf(vblob **v, DATA_TYPE dp, const char *pcData, unsigned *uDataLen, unsigned uBufLen);

extern unsigned 
ph1_PSK_Main(p1_ir_state* i, p1_ir_state* r, unsigned uFlags );

extern unsigned
ph1_PSK_Aggressive(p1_ir_state* i, p1_ir_state* r);

extern unsigned
ph1_SIGNATURE_Main(p1_ir_state* i, p1_ir_state* r, bool is_cfgmode);

extern unsigned
ph1_SIGNATURE_Aggressive(p1_ir_state* i, p1_ir_state* r);

extern  unsigned
phase_2_qm(p2_ir_state* i, p2_ir_state* r, bool pfs, bool commit);

extern unsigned
phase_2_inf(p2_ir_state* i, p2_ir_state* r, bool new_group, bool is_cfgmode);

extern unsigned
ike_esp(p2_ir_state* i, p2_ir_state* r, 
#ifdef TEST_CONFORMITY
	user_space* sadb_s, 
	DWORD is_iov,
#endif
	CPIPSEC_PROTOCOL_ID_T satype, CPESP_TRANSFORM_ID_T encrypt, CPAH_TRANSFORM_ID_T auth);

#define CapiAcquireContext(m,pp,cn,pr,ty,fl,vt)     (m->AcquireContext(m,pp,cn,fl,vt))
#define CapiReleaseContext(m,p,a1)		 	(m->ReleaseContext(m,p,a1))
#define CapiSetProvParam(m,p,a1,a2,a3)	        (m->SetProvParam(m,p,a1,a2,a3))
#define CapiGetProvParam(m,p,a1,a2,a3,a4)	        (m->GetProvParam(m,p,a1,a2,a3,a4))
#define CapiGenKey(m,p,a1,a2,a3)		        (m->GenKey(m,p,a1,a2,a3))
#define CapiDestroyKey(m,p,a1)		        (m->DestroyKey(m,p,a1))
#define CapiCreateHash(m,p,a1,a2,a3,a4)	        (m->CreateHash(m,p,a1,a2,a3,a4))
#define CapiDestroyHash(m,p,a1)		        (m->DestroyHash(m,p,a1))
#define CapiEncrypt(m,p,a1,a2,a3,a4,a5,a6,a7)	(m->Encrypt(m,p,a1,a2,a3,a4,a5,a6,a7))
#define CapiDecrypt(m,p,a1,a2,a3,a4,a5,a6)	 	(m->Decrypt(m,p,a1,a2,a3,a4,a5,a6))
#define CapiDeriveKey(m,p,a1,a2,a3,a4)	        (m->DeriveKey(m,p,a1,a2,a3,a4))
#define CapiDuplicateKey(m,p,a1,a2,a3,a4)	        (m->DuplicateKey(m,p,a1,a2,a3,a4))
#define CapiDuplicateHash(m,p,a1,a2,a3,a4)	 	(m->DuplicateHash(m,p,a1,a2,a3,a4))
#define CapiExportKey(m,p,a1,a2,a3,a4,a5,a6)	(m->ExportKey(m,p,a1,a2,a3,a4,a5,a6))
#define CapiGenRandom(m,p,a1,a2)		        (m->GenRandom(m,p,a1,a2))
#define CapiGetHashParam(m,p,a1,a2,a3,a4,a5)	(m->GetHashParam(m,p,a1,a2,a3,a4,a5))
#define CapiGetKeyParam(m,p,a1,a2,a3,a4,a5)		(m->GetKeyParam(m,p,a1,a2,a3,a4,a5))
#define CapiGetUserKey(m,p,a1,a2)		        (m->GetUserKey(m,p,a1,a2))
#define CapiHashData(m,p,a1,a2,a3,a4)		(m->HashData(m,p,a1,a2,a3,a4))
#define CapiHashSessionKey(m,p,a1,a2,a3)	        (m->HashSessionKey(m,p,a1,a2,a3))
#define CapiImportKey(m,p,a1,a2,a3,a4,a5)	        (m->ImportKey(m,p,a1,a2,a3,a4,a5))
#define CapiSetHashParam(m,p,a1,a2,a3,a4)	        (m->SetHashParam(m,p,a1,a2,a3,a4))
#define CapiSetKeyParam(m,p,a1,a2,a3,a4)		(m->SetKeyParam(m,p,a1,a2,a3,a4))
#define CapiSignHash(m,p,a1,a2,a3,a4,a5,a6)		(m->SignHash(m,p,a1,a2,a3,a4,a5,a6))
#define CapiVerifySignature(m,p,a1,a2,a3,a4,a5,a6)	(m->VerifySignature(m,p,a1,a2,a3,a4,a5,a6))

static const VTABLEPROVSTRUC VTABLE2001 = { 3, NULL, NULL, PROV_GOST_2001_DH, NULL, 0, (CHAR*)DEFAULT_PROV_NAME_A};
extern HCRYPTMODULE hModuleIke;

bool GetNewModule( HCRYPTMODULE * h, bool bVerbose, const CPC_FAST_CODE *pcfcCfg );
CPC_CONFIG * GetCPCConfig();
HCRYPTMODULE GetNewModule_Crypt();
void ReleaseModule_Crypt( HCRYPTMODULE h );

#endif /* EXAMPLE_H_INCLUDED */
