#!/bin/bash
# vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[]
#
# Copyright(C) 2005-2013  
#
#    , 
#    .
#
#        ,
# ,    ,
#     ,
# ,      
#     
#      .
#
#  ,    , 
#         
#   .
#
#  -   
#     .
#
#
#
# commands to build example, example_io_krn
# required in current dir
# example sources:   example.cpp example.h init_plg.cpp init_plg.h example_ike_esp.cpp example_inf.cpp example_p2.cpp
# example_psk.cpp example_sign.cpp ike_cert.cpp ike_cert.h
# build_example.sh
# includes:   ike_gost.h esp_gost.h psk_gost.h ipsec_version.h typedefs.h cp-ike-gost.h cp-ipsec-gost.h
# precompiled files: libike_gost.so libesp.so IPSecPSK.o
#
# You must have root priviliges to install libike_gost.so and libesp_gost.so
#
# You must run script from directory with distribution files.
#

b=${CSP_DIR:-/opt/cprocsp}
i=${CSP_INCLUDE:-$CSP_DIR/include}
s=`uname -s`

CPCCC=${CXX:-$CCC}
if [ -z "$CPCCC" ] ; then
    printf "error: CXX or CCC must be set. Use setenv.sh.\n" 1>&2
    exit 1
fi
${CPCCC} -v 2>&1|grep -q pie && CPCCC="${CPCCC} -no-pie"

CXXFLAGS="-I$i/../ipsec/include -I$i -I$i/cpcsp/ -I. -DUNIX"

case $s in
FreeBSD)
    CXXFLAGS="$CXXFLAGS -DFREEBSD"
    EXTRA_LIB=
    ;;
Linux)
    CXXFLAGS="$CXXFLAGS -DLINUX"
    EXTRA_LIB=-ldl
    ;;
*)
    ;;
esac

CXXFLAGS="$CXXFLAGS $add_CPPFLAGS -DSIZEOF_VOID_P=$SIZEOF_VOID_P \
		-fno-exceptions -fno-rtti -Wall -g"
CXXFLAGS_IO_KRN="$CXXFLAGS -DESP_IO_KERNEL"

OBJS="example.o init_plg.o \
	example_ike_esp.o example_inf.o example_p2.o \
	example_psk.o example_sign.o ike_cert.o"

${CPCCC} ${CXXFLAGS} -c -o example.o example.cpp && \
${CPCCC} ${CXXFLAGS} -c -o init_plg.o init_plg.cpp && \
${CPCCC} ${CXXFLAGS} -c -o example_ike_esp.o example_ike_esp.cpp && \
${CPCCC} ${CXXFLAGS} -c -o example_inf.o example_inf.cpp && \
${CPCCC} ${CXXFLAGS} -c -o example_p2.o example_p2.cpp && \
${CPCCC} ${CXXFLAGS} -c -o example_psk.o example_psk.cpp && \
${CPCCC} ${CXXFLAGS} -c -o example_sign.o example_sign.cpp && \
${CPCCC} ${CXXFLAGS} -c -o ike_cert.o ike_cert.cpp && \
${CPCCC} -o example ${add_ldflags} ${OBJS} -g -L${CSP_LIB} -like_gost -lesp_gost -lrdrsup -lcapi10 -lcapi20 -lcpcdrv_emul $CSP_EXTRA_LIBS $EXTRA_LIB && \
rm -f ${OBJS}
e=$?
if [ $e != 0 ] ; then
    printf "error: Build of example\n" 1>&2
    exit $e
fi
if [ FreeBSD = $s ] ; then
    printf "warning: TODO:XX Need example_io_krn for FreeBSD\n" 1>&2
    exit 0
fi
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o example.o example.cpp && \
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o init_plg.o init_plg.cpp && \
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o example_ike_esp.o example_ike_esp.cpp && \
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o example_inf.o example_inf.cpp && \
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o example_p2.o example_p2.cpp && \
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o example_psk.o example_psk.cpp && \
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o example_sign.o example_sign.cpp && \
${CPCCC} ${CXXFLAGS_IO_KRN} -c -o ike_cert.o ike_cert.cpp && \
${CPCCC} -o example_io_krn ${add_ldflags} ${OBJS} -g -L${CSP_LIB} -like_gost -lesp_gost -lrdrsup -lcapi10 -lcapi20 -lcpcdrv_emul $CSP_EXTRA_LIBS $EXTRA_LIB && \
rm -f ${OBJS}
e=$?
if [ $e != 0 ] ; then
    printf "error: Build of example_io_krn\n" 1>&2
    exit $e
fi
