/*
 * Copyright(C) 2005-2010
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 *
 * \brief   ESP  IKE  user mode
 *
 */

#if !defined _IO_KRN_H_
#define _IO_KRN_H_

/* esp_gost.h */
extern EspSetLogLvlDecl io_krn_SetLogLvl;
extern espEncapDecl io_krn_espEncap;
extern espDecapDecl io_krn_espDecap;
extern destroyDecl io_krn_destroy;
extern spiCreateDecl io_krn_spiCreate;

/* sadb.h */
extern CreateEphemDecl io_krn_CreateEphem;
extern deSerializePubKeyDecl io_krn_deSerializePubKey;
extern DestroyPrivKeyDecl io_krn_DestroyPrivKey;
extern DestroyPubKeyDecl io_krn_DestroyPubKey;

#pragma pack(push,4)
#if defined _WIN32
#pragma warning(disable:4200) // char rnd[0];
#pragma warning(disable:4121) // alignment of a member was sensitive to packing
#endif			      /* _WIN32 */
/*
 *    .
 *       
 *  len  .. 
*/
struct io_krn_hdr {
    unsigned uFlags;		/*  0 */
    unsigned len;		/*      */
    capi_result res;		/*   */
};

/*      .   HCRYPTMODULE */
struct create_hmodule {
    struct io_krn_hdr hdr;
    unsigned hm; /* OUT */
    char rnd[0];    /* IN */
};

struct destroy_hmodule {
    struct io_krn_hdr hdr;
    unsigned hm; 		/* IN */
};

struct create_ephem {
    struct io_krn_hdr hdr;
    unsigned hm;       /* IN */
/* hProv      */
    unsigned hpK;          /* OUT     */
    unsigned hpM;          /* OUT     */
    unsigned hpP;          /* OUT     */
    unsigned pusadbSALen; /* OUT       */
    char pcsadbSA[0];     /* OUT      */
};

struct deserializePubKey {
    struct io_krn_hdr hdr;
    unsigned hm;
/* hProv      */
    PUBKEY_2012 key;          /* OUT     */
    unsigned pcsadbSALen;/* IN        */
    char pcsadbSA[0];	 /* IN      */
};

struct destroyPrivKey {
    struct io_krn_hdr hdr;
    unsigned hpK; /* IN handle     */
    unsigned hpM; /* IN handle     */
    unsigned hpP; /* IN handle     */
    /* hProv      */
};

struct destroyPubKey {
    struct io_krn_hdr hdr;
    PUBKEY_2012 key; /* IN handle     */
};

struct init_data {
    struct io_krn_hdr hdr;
    unsigned major;		/* IPSEC_MAJOR */
    unsigned minor;		/* IPSEC_MINOR */
    unsigned num_session;
    unsigned datalen;		/*    union */
    unsigned hh;			/* esp_handle    cpesp_shutdown */
    union {
    	char cin[0]; /*  ,       */
	struct esp_gost_out eou;
    } u;
};

struct shutdown_data {
    struct io_krn_hdr hdr;
    unsigned hh;			/* esp_handle   
				 * spiCreate  cpesp_shutdown */
};

struct set_loglevel {
    struct io_krn_hdr hdr;
    log_severity_t level;
};

struct spi_create {
    struct io_krn_hdr hdr;
    unsigned hsid;
    unsigned hh;
    unsigned hpK;
    unsigned hpM;
    unsigned hpP;
    PUBKEY_2012 keyPub;
    unsigned uIPsecSALen; /*    */
    char pcIPsecSA[0];	  /*  
			   *  ,
			   *      */
};

struct spi_delete {
    struct io_krn_hdr hdr;
    unsigned hsid;
};

struct encap {
    struct io_krn_hdr hdr;
    unsigned hsid;
    unsigned datalen;	       /* IN/OUT */
    unsigned buflen;	       /* IN.  0 -->   */
    unsigned NextProto;	       /* - char */
    char d[0];		       /* IN/OUT     */
};

struct decap {
    struct io_krn_hdr hdr;
    unsigned hsid;
    unsigned datalen;	      /* IN/OUT */
    unsigned NextProto;	      /* - char */
    char d[0];		      /* IN/OUT.     */
};
#ifndef _WIN32
#include <linux/ioctl.h>
#endif //_WIN32

#define MAJOR_NUM 100 /* must be in sync with esp/tstesp.c::Major */
#define TSTESP_CREATEHMODULE 0
#define TSTESP_DESTROYHMODULE 90
#define TSTESP_CREATEEPHEM 1
#define TSTESP_DESERPUBKEY 2
#define TSTESP_DESTROYPUB  3
#define TSTESP_DESTROYPRIV 4

#define TSTESP_INIT         10
#define TSTESP_SHUTDOWN     20
#define TSTESP_SPICREATE    40
#define TSTESP_DELETE       50
#define TSTESP_SETLOGLVL    60
#define TSTESP_ENCAP        70
#define TSTESP_DECAP        80

#ifndef _WIN32
		//       TSTESP_
#define IOCTL_CREATEHMODULE   \
	    _IOWR(MAJOR_NUM, TSTESP_CREATEHMODULE, struct create_hmodule*)
#define IOCTL_CREATEHMODULE32 \
	    _IOWR(MAJOR_NUM, TSTESP_CREATEHMODULE, compat_uptr_t)
		    /* create HCRYPTMODULE,
		       transfer data for PRNG init from user,
		       return CSP-handle */
#define IOCTL_DESTROYHMODULE  \
	    _IOWR(MAJOR_NUM, TSTESP_DESTROYHMODULE, struct destroy_hmodule*)
#define IOCTL_DESTROYHMODULE32\
	    _IOWR(MAJOR_NUM, TSTESP_DESTROYHMODULE, compat_uptr_t)

#define IOCTL_CREATEEPHEM     \
	    _IOWR(MAJOR_NUM, TSTESP_CREATEEPHEM, struct create_ephem*)
#define IOCTL_CREATEEPHEM32   \
	    _IOWR(MAJOR_NUM, TSTESP_CREATEEPHEM, compat_uptr_t)
		    /* create ephem key */
#define IOCTL_DESERPUBKEY     \
	    _IOWR(MAJOR_NUM, TSTESP_DESERPUBKEY, struct deserializePubKey*)
#define IOCTL_DESERPUBKEY32   \
	    _IOWR(MAJOR_NUM, TSTESP_DESERPUBKEY, compat_uptr_t)
		    /*  */
#define IOCTL_DESTROYPUB      \
	    _IOWR(MAJOR_NUM, TSTESP_DESTROYPUB, struct destroyPubKey*)
#define IOCTL_DESTROYPUB32    \
	    _IOWR(MAJOR_NUM, TSTESP_DESTROYPUB, compat_uptr_t)
	       	    /*  */
#define IOCTL_DESTROYPRIV     \
	    _IOWR(MAJOR_NUM, TSTESP_DESTROYPRIV, struct destroyPrivkey*)
#define IOCTL_DESTROYPRIV32   \
	    _IOWR(MAJOR_NUM, TSTESP_DESTROYPRIV, compat_uptr_t)
		    /*  */

#define IOCTL_INIT_MODULE     \
	    _IOWR(MAJOR_NUM, TSTESP_INIT, struct init_data*)
#define IOCTL_INIT_MODULE32   \
	    _IOWR(MAJOR_NUM, TSTESP_INIT, compat_uptr_t)
		    /* init esp, transfer init data from user space, 
		       return handle */
#define IOCTL_SHUTDOWN_MODULE \
	    _IOWR(MAJOR_NUM, TSTESP_SHUTDOWN, struct shutdown_data*)
#define IOCTL_SHUTDOWN_MODULE32 \
	    _IOWR(MAJOR_NUM, TSTESP_SHUTDOWN, compat_uptr_t)
		    /* shutdown */
#define IOCTL_SET_LOGLVL      \
	    _IOWR(MAJOR_NUM, TSTESP_SETLOGLVL, struct set_loglevel*)
#define IOCTL_SET_LOGLVL32    \
	    _IOWR(MAJOR_NUM, TSTESP_SETLOGLVL, compat_uptr_t)
		    /* set log level */

#define IOCTL_SPICREATE       \
	    _IOWR(MAJOR_NUM, TSTESP_SPICREATE, struct spi_create*)
#define IOCTL_SPICREATE32     \
	    _IOWR(MAJOR_NUM, TSTESP_SPICREATE, compat_uptr_t)
		    /* create esp session, return sid */
#define IOCTL_SPIDELETE       \
	    _IOWR(MAJOR_NUM, TSTESP_DELETE, struct spi_delete*)
#define IOCTL_SPIDELETE32     \
	    _IOWR(MAJOR_NUM, TSTESP_DELETE, compat_uptr_t)
		    /* delete esp session */
#define IOCTL_ENCAP           \
	    _IOWR(MAJOR_NUM, TSTESP_ENCAP, struct encap*)
#define IOCTL_ENCAP32         \
	    _IOWR(MAJOR_NUM, TSTESP_ENCAP, compat_uptr_t)
	            /* can ask length, protect data */
#define IOCTL_DECAP           \
	    _IOWR(MAJOR_NUM, TSTESP_DECAP, struct decap*)
#define IOCTL_DECAP32         \
	    _IOWR(MAJOR_NUM, TSTESP_DECAP, compat_uptr_t)
	            /* unprotect data */

#else //_WIN32
	    // TODO:XXX       TSTESP_*
	    //  0x800+TSTESP_*
#define IOCTL_CREATEHMODULE   CTL_CODE(0x12,0x800,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* create HCRYPTMODULE,
										    transfer data for PRNG init from user,
										    return CSP-handle */
#define IOCTL_DESTROYHMODULE  CTL_CODE(0x12,0x810,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_CREATEEPHEM     CTL_CODE(0x12,0x801,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* create ephem key */
#define IOCTL_DESERPUBKEY     CTL_CODE(0x12,0x802,METHOD_BUFFERED,FILE_ANY_ACCESS)  /*  */
#define IOCTL_DESTROYPUB      CTL_CODE(0x12,0x803,METHOD_BUFFERED,FILE_ANY_ACCESS)  /*  */
#define IOCTL_DESTROYPRIV     CTL_CODE(0x12,0x804,METHOD_BUFFERED,FILE_ANY_ACCESS)  /*  */

#define IOCTL_INIT_MODULE     CTL_CODE(0x12,0x805,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* init esp, transfer init data from user space, return handle */
#define IOCTL_SHUTDOWN_MODULE CTL_CODE(0x12,0x806,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* shutdown */
#define IOCTL_SET_LOGLVL      CTL_CODE(0x12,0x807,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* set log level */
#define IOCTL_SPICREATE       CTL_CODE(0x12,0x808,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* create esp session, return sid */
#define IOCTL_SPIDELETE       CTL_CODE(0x12,0x809,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* delete esp session */
#define IOCTL_ENCAP           CTL_CODE(0x12,0x80A,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* can ask length, protect data */
#define IOCTL_DECAP           CTL_CODE(0x12,0x80B,METHOD_BUFFERED,FILE_ANY_ACCESS)  /* unprotect data */
#endif //_WIN32

#if !defined(_WIN32) && defined(__x86_64__) 
		// TODO:XXX     
		//      
		//  Windows
#define CASE_CREATEHMODULE   IOCTL_CREATEHMODULE:   case IOCTL_CREATEHMODULE32
#define CASE_DESTROYHMODULE  IOCTL_DESTROYHMODULE:  case IOCTL_DESTROYHMODULE32
#define CASE_CREATEEPHEM     IOCTL_CREATEEPHEM:     case IOCTL_CREATEEPHEM32
#define CASE_DESERPUBKEY     IOCTL_DESERPUBKEY:     case IOCTL_DESERPUBKEY32
#define CASE_DESTROYPUB      IOCTL_DESTROYPUB:      case IOCTL_DESTROYPUB32
#define CASE_DESTROYPRIV     IOCTL_DESTROYPRIV:     case IOCTL_DESTROYPRIV32

#define CASE_INIT_MODULE     IOCTL_INIT_MODULE:     case IOCTL_INIT_MODULE32
#define CASE_SHUTDOWN_MODULE IOCTL_SHUTDOWN_MODULE: case IOCTL_SHUTDOWN_MODULE32
#define CASE_SET_LOGLVL      IOCTL_SET_LOGLVL:      case IOCTL_SET_LOGLVL32

#define CASE_SPICREATE       IOCTL_SPICREATE:       case IOCTL_SPICREATE32
#define CASE_SPIDELETE       IOCTL_SPIDELETE:       case IOCTL_SPIDELETE32
#define CASE_ENCAP           IOCTL_ENCAP:           case IOCTL_ENCAP32
#define CASE_DECAP           IOCTL_DECAP:           case IOCTL_DECAP32

#else 

#define CASE_CREATEHMODULE   IOCTL_CREATEHMODULE
#define CASE_DESTROYHMODULE  IOCTL_DESTROYHMODULE
#define CASE_CREATEEPHEM     IOCTL_CREATEEPHEM
#define CASE_DESERPUBKEY     IOCTL_DESERPUBKEY
#define CASE_DESTROYPUB      IOCTL_DESTROYPUB
#define CASE_DESTROYPRIV     IOCTL_DESTROYPRIV

#define CASE_INIT_MODULE     IOCTL_INIT_MODULE
#define CASE_SHUTDOWN_MODULE IOCTL_SHUTDOWN_MODULE
#define CASE_SET_LOGLVL      IOCTL_SET_LOGLVL

#define CASE_SPICREATE       IOCTL_SPICREATE
#define CASE_SPIDELETE       IOCTL_SPIDELETE
#define CASE_ENCAP           IOCTL_ENCAP
#define CASE_DECAP           IOCTL_DECAP

#endif

#pragma pack(pop)

#endif	/* _IO_KRN_H_ */
