/* * Copyright(C) 2005-2012
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 *
 * This is proprietary information of
 * Crypto-Pro company.
 *
 * Any part of this file can not be copied,
 * corrected, translated into other languages,
 * localized or modified by any means,
 * compiled, transferred over a network from or to
 * any computer system without preliminary
 * agreement with Crypto-Pro company
 */

/*
 * \version $Revision: 185076 $
 * \author $Author: maxdm $
 */

#ifndef _IKE_GOST_H_
#define _IKE_GOST_H_

#include "ike_gost_types.h"	// forward declarations
#include "cp-ike-gost.h"
#include "typedefs.h"
#include "vblob.h"
#include "psk_gost.h"
#include "sadb.h"
#include "ipsec_version.h"

/* callbacks */
/*
 * External log function
 *
 * severity [in] severity level
 * fmt [in] format string. Syntax as in printf()
*/
typedef void CAPI_EXTC
IkeLogDecl(void * pUfnAgr, log_severity_t severity, unsigned uFlags, const char *fmt, ...);

typedef void CAPI_EXTC
IkeSetLogLvlDecl(void * pUfnAgr, log_severity_t severity, unsigned uFlags);

/* function prototypes */
/* init library function uses types declared later and is declared itself at the end of header */
/* shutdown func declared at the end of header too */

/* Functions data serialization/deserialization/reserialization */
/*  p1 IKE */
typedef capi_result CAPI_EXTC
p1_SerializeDecl(
    const P1_HANDLE sid,
    PRIVKEY * hPriv, /*    hPriv */
    PUBKEY_2012 * hPub,   /*   hPub */
    unsigned uFlags,
    vblob ** p1_data
);

/*  p1 IKE */
typedef capi_result CAPI_EXTC
p1_deSerializeDecl(
    ike_gost_handle h,
    PRIVKEY * hPriv, /*    hPriv */
    PUBKEY_2012 * hPub,   /*   hPub  */
    const vblob * p1_data,
    unsigned uFlags,
    P1_HANDLE * sid
);

/*  p1 */
typedef capi_result CAPI_EXTC
p1_reSerializeDecl(
    ike_gost_handle h,
    PRIVKEY * hPriv_from, /*    hPriv_from */
    PRIVKEY * hPriv_to,	 /*    hPriv_to */
    PUBKEY_2012 * hPub_from,	 /*   from */
    PUBKEY_2012 * hPub_to,	 /*   to */
    const vblob * p1_data_from,
    unsigned uFlags,
    vblob ** p1_data_to
);

/*  spi */
typedef capi_result CAPI_EXTC
spiSerializeDecl(
    P2_HANDLE sid,
    PRIVKEY * hPriv, /*    hPriv */
    PUBKEY_2012 * hPub,   /*   hPub */
    const vblob * spi,
    CPESP_DIRECTION_T dir,
    CPIPSEC_PROTOCOL_ID_T ip_satype,
    CPESP_TRANSFORM_ID_T ip_encrypt,
    CPAH_TRANSFORM_ID_T ip_auth,
    unsigned uFlags,
    vblob ** spi_data
);

/*  spi */
typedef capi_result CAPI_EXTC
spireSerializeDecl(
    ike_gost_handle h,
    PRIVKEY * hPriv_from, /*    hPriv_from */
    PRIVKEY * hPriv_to,	 /*    hPriv_to */
    PUBKEY_2012 * hPub_from,	 /*   from */
    PUBKEY_2012 * hPub_to,	 /*   to */
    const vblob * spi_data_from,
    unsigned uFlags,
    vblob ** spi_data_to
);

/* CreateEphemFn, deSerializePubKeyFn, DestroyPrivKeyFn, DestroyPubKeyFn are declared in sadb.h */

/* function answer question 'how long PSK will live'. Answer in time_t. */
typedef capi_result CAPI_EXTC
getPSKnotAfterDecl(ike_gost_handle h,
		   const vblob * pSitePSK, const vblob * pSiteNetID, const vblob * pSiteID,
		   unsigned uFlags,
		   time_t * ptNotAfter);

/* phase 1 */
/* get Vendor IDs */
typedef capi_result CAPI_EXTC
p1_GetVendorIDsDecl(ike_gost_handle h,
		    unsigned uFlags,
		    vblob ** vendors,
		    unsigned * arraysize);

/* phase 1 */
/* create session phase 1 */
typedef capi_result CAPI_EXTC
p1_CreateDecl(ike_gost_handle h,
	      const vblob ** pcVendor_ID_b,
	      CPIKE_AUTH_T am,
	      IKE_ROLE role,
	      CPIKE_ENC_T enc_mac_id, CPIKE_HASH_T hash_id,
	      CPIKE_GTYPE_T gtype_id, CPIKE_GROUP_T group_id,
	      unsigned uFlags,
	      P1_HANDLE * sid);

/* destroy session */
typedef void CAPI_EXTC
p1_DestroyDecl(P1_HANDLE sid, unsigned uFlags);

/* set/get session parameters */
typedef capi_result CAPI_EXTC
p1_SetParamDecl(P1_HANDLE sid, CPIKE_AC_T iacAtrCls,
		uintptr_t upClsVal, unsigned upClsType,
		unsigned uFlags);

typedef capi_result CAPI_EXTC
p1_GetParamDecl(const P1_HANDLE sid,
		CPIKE_AC_T iacAtrCls, unsigned upClsType,
		unsigned uFlags,
		void * pClsVal, unsigned * puValLen);

/* generate own parameters */
typedef capi_result CAPI_EXTC
p1_SetupDecl(P1_HANDLE sid, const vblob * CKY,
	     unsigned uFlags,
	     vblob ** KEx_b, vblob ** Nx_b);

/* process other side' parameters */
typedef capi_result CAPI_EXTC 
p1_AgreeDecl(P1_HANDLE sid,
	     const vblob * SAi_b, const vblob * KEx_b,
	     const vblob * Nx_b, const vblob * CKY,
	     unsigned uFlags);

/* Session's private key is used for exchanges/authorization */
/* set session private key from PSK */
typedef capi_result CAPI_EXTC
p1_SetPSKDecl(P1_HANDLE sid,
	      const vblob* psk, const vblob* SiteNetID, const vblob* SiteID,
	      unsigned uFlags);

/* set session private key from certificate's key's container */
typedef capi_result CAPI_EXTC
p1_SetMyCertProvDecl(P1_HANDLE sid, PRIVKEY * hPriv, vblob * myCert, unsigned uFlags);

/* set other side Certificate */
typedef capi_result CAPI_EXTC
p1_SetOtherCertDecl(P1_HANDLE sid, vblob * otherPublic, vblob * otherCert, unsigned uFlags);

/* calculate/check HASH_I/HASH_R or SIG_I/SIG_R accordingly to auth method */
typedef capi_result CAPI_EXTC
p1_Auth_irDecl(P1_HANDLE sid, const vblob *IDix_b, unsigned uFlags, vblob** hs);

typedef capi_result CAPI_EXTC
p1_Verify_irDecl(P1_HANDLE sid, const vblob* IDx_b, vblob* hash,
		 unsigned uFlags);

/* data Encap/Decap */
typedef capi_result CAPI_EXTC
p1_EncapDecl(P1_HANDLE sid, unsigned uFlags,
	     void *pData, unsigned *puDataLen, unsigned uBufLen);

typedef capi_result CAPI_EXTC
p1_DecapDecl(P1_HANDLE sid, unsigned uFlags,
	     void *pData, unsigned *puDataLen);

/* generates NatDHash */
typedef capi_result CAPI_EXTC
p1_NatDHashDecl(P1_HANDLE sid, const vblob* CKY,
		const vblob* IP, const vblob* Port, unsigned uFlags, vblob** NatDHash);

/* Phase 2 */
/* create session phase 2 */
typedef capi_result CAPI_EXTC
p2_CreateDecl(ike_gost_handle h,
	      P1_HANDLE p1sid, IKE_ROLE role,
	      const vblob *MID,
	      unsigned uFlags,
	      P2_HANDLE *p2sid);

/* destroy session */
typedef void CAPI_EXTC
p2_DestroyDecl(P2_HANDLE sid, unsigned uFlags);

/* set/get session parameters */
typedef capi_result CAPI_EXTC
p2_SetParamDecl(P2_HANDLE sid, CPIPSEC_AT_T iatAtrCls,
		uintptr_t upClsVal, unsigned upClsType,
		unsigned uFlags);

typedef capi_result CAPI_EXTC
p2_GetParamDecl(const P2_HANDLE sid,
		CPIPSEC_AT_T iatAtrCls, unsigned upClsType,
		unsigned uFlags,
		void *pClsVal, unsigned *puValLen);

/* generate own parameters */
typedef capi_result CAPI_EXTC
p2_SetupDecl(P2_HANDLE sid, unsigned uFlags, vblob** PFSKey, vblob** Nx_b);

/* process other side' parameters */
typedef capi_result CAPI_EXTC
p2_AgreeDecl(P2_HANDLE sid, const vblob* PFSKey, const vblob* Nx_b, unsigned uFlags);

/* check HASH(3) value */
typedef capi_result CAPI_EXTC
p2_Hash3Decl(P2_HANDLE sid, unsigned uFlags, vblob** HASH3_b);

typedef capi_result CAPI_EXTC
p2_Verify3Decl(P2_HANDLE sid, const vblob* HASH3_b, unsigned uFlags);

/* data Encap/Decap */
typedef capi_result CAPI_EXTC
p2_EncapDecl(P2_HANDLE sid, unsigned uFlags,
	     void *data, unsigned *puDataLen, unsigned uBufLen);

typedef capi_result CAPI_EXTC
p2_DecapDecl(P2_HANDLE sid, unsigned uFlags,
	     void *data, unsigned *puDataLen);

/* functions not directly related to any phase */
/* calculate/verify and return HASH_A value */
/* N args of type 'const vblob*' required */
typedef capi_result CAPI_EXTC
p2_HashADecl(P2_HANDLE sid, unsigned uFlags, vblob** hash, unsigned N, ...);

typedef capi_result CAPI_EXTC
p2_VerifyADecl(P2_HANDLE sid, unsigned uFlags, const vblob* hash, unsigned N, ...);

/* This structure is filled by the cpike_init_gost().
   A pointer to this structure is passed with every function call to any
   IKE function.
*/

/*!
 * \ingroup ikeData
 * \struct ike_gost
 * \brief    IKE. 
 *
 */
typedef struct ike_gost {
    void *pUfnArg;
    /*!< \brief    .*/
    IkeLogDecl *LogUfn;
    /*!< \brief   #LogUfn.*/
    IkeSetLogLvlDecl *SetLogLvlUfn;
    /*!< \brief    #SetLogLvlUfn.*/
    getPSKnotAfterDecl *getPSKnotAfterFn;
    /*!< \brief  #getPSKnotAfterFn.*/
    p1_CreateDecl *p1_CreateFn;
    /*!< \brief  #p1_CreateFn.*/
    p1_DestroyDecl *p1_DestroyFn;
    /*!< \brief  #p1_DestroyFn.*/
    p1_SetParamDecl *p1_SetParamFn;
    /*!< \brief  #p1_SetParamFn.*/
    p1_GetParamDecl *p1_GetParamFn;
    /*!< \brief  #p1_GetParamFn.*/
    p1_SetupDecl *p1_SetupFn;
    /*!< \brief  #p1_SetupFn.*/
    p1_NatDHashDecl *p1_NatDHashFn;
    /*!< \brief  #p1_NatDHashFn.*/
    p1_AgreeDecl *p1_AgreeFn;
    /*!< \brief  #p1_AgreeFn.*/
    p1_SetPSKDecl *p1_SetPSKFn;
    /*!< \brief  #p1_SetPSKFn.*/
    p1_SetMyCertProvDecl *p1_SetMyCertProvFn;
    /*!< \brief  #p1_SetMyCertProvFn.*/
    p1_SetOtherCertDecl *p1_SetOtherCertFn;
    /*!< \brief  #p1_SetOtherCertFn.*/
    p1_Auth_irDecl *p1_AuthIRFn;
    /*!< \brief  #p1_AuthIRFn.*/
    p1_Verify_irDecl *p1_VerifyIRFn;
    /*!< \brief  #p1_VerifyIRFn.*/
    p1_EncapDecl *p1_EncapFn;
    /*!< \brief  #p1_EncapFn.*/
    p1_DecapDecl *p1_DecapFn;
    /*!< \brief  #p1_DecapFn.*/
    p2_CreateDecl *p2_CreateFn;
    /*!< \brief  #p2_CreateFn.*/
    p2_DestroyDecl  *p2_DestroyFn;
    /*!< \brief  #p2_DestroyFn.*/
    p2_SetParamDecl *p2_SetParamFn;
    /*!< \brief  #p2_SetParamFn.*/
    p2_GetParamDecl *p2_GetParamFn;
    /*!< \brief  #p2_GetParamFn.*/
    p2_SetupDecl *p2_SetupFn;
    /*!< \brief  #p2_SetupFn.*/
    p2_AgreeDecl *p2_AgreeFn;
    /*!< \brief  #p2_AgreeFn.*/
    p2_Hash3Decl *p2_Hash3Fn;
    /*!< \brief  #p2_Hash3Fn.*/
    p2_Verify3Decl *p2_Verify3Fn;
    /*!< \brief  #p2_Verify3Fn.*/
    p2_EncapDecl *p2_EncapFn;
    /*!< \brief  #p2_EncapFn.*/
    p2_DecapDecl *p2_DecapFn;
    /*!< \brief  #p2_DecapFn.*/
    p2_HashADecl *p2_HashAFn;
    /*!< \brief  #p2_HashAFn.*/
    p2_VerifyADecl *p2_VerifyAFn;
    /*!< \brief  #p2_VerifyAFn.*/
    p1_SerializeDecl *p1_SerializeFn;
    /*!< \brief  #p1_SerializeFn.*/
    p1_deSerializeDecl *p1_deSerializeFn;
    /*!< \brief  #p1_deSerializeFn.*/
    p1_reSerializeDecl *p1_reSerializeFn;
    /*!< \brief  #p1_reSerializeFn.*/
    spiSerializeDecl *spiSerializeFn;
    /*!< \brief  #spiSerializeFn.*/
    spireSerializeDecl *spireSerializeFn;
    /*!< \brief  #spireSerializeFn.*/
    GEN_SADB sadb;
    /*!< \brief   #GEN_SADB.*/
    HCRYPTMODULE hModule; 
    /*!< \brief   " CSP".*/
    CPC_CONFIG * config; 
    /*!< \brief   CPC_CONFIG    HCRYPTMODULE.*/
    p1_GetVendorIDsDecl *p1_GetVendorIDsFn;
    /*!< \brief  #p1_GetVendorIDsFn.*/
    void* reserved[4];
    /*!< \brief ,  ,  .*/
}IKE_GOST;

/*!
 * \ingroup ikeData
 * \struct ike_gost_in
 * \brief     IKE   #cpike_init_gost. 
 *
 */
typedef struct ike_gost_in {
    unsigned	     apiVersionMajor;
    /*!< \brief  major  .*/
    unsigned	     apiVersionMinor;
    /*!< \brief  minor  .*/
    unsigned         maxSessions;
    /*!< \brief   ,      , 0 -   (  ).*/
    void             *pUfnArg;
    /*!< \brief    .*/
    IkeLogDecl	     *LogUfn;
    /*!< \brief   #LogUfn,   0.*/
    IkeSetLogLvlDecl *SetLogLvlUfn;
    /*!< \brief    #SetLogLvlUfn,    #LogUfn.*/
    unsigned         allocatedMem;
    /*!< \brief    ike_gost_handle  (  requiredMem  #ike_gost_out).*/
    const char*	     sczDebugKey;
    /*!< \brief           .
         (     ).*/
    HCRYPTMODULE hModule; 
    /*!< \brief  CSP.*/
    CPC_CONFIG * config; 
    /*!< \brief   CPC_CONFIG    HCRYPTMODULE.*/
    void*            reserved[5];
    /*!< \brief ,  ,  .*/
} IKE_GOST_IN;

/*!
 * \ingroup ikeData
 * \struct ike_gost_out
 * \brief      IKE   #cpike_init_gost. 
 *
 */
typedef struct ike_gost_out {
    unsigned requiredMem;
    /*!< \brief   ike_gost_handle  .*/
    char     cVID[32];
    /*!< \brief  Vendor ID (  IKE/ESP/AH).*/
    unsigned cVIDLen;
    /*!< \brief  Vendor ID.*/
    UINT_PTR apiVersionMajor;
    /*!< \brief   .*/
    UINT_PTR apiVersionMinor;
    /*!< \brief   .*/
    void*    reserved[6];
    /*!< \brief ,  ,  .*/
} IKE_GOST_OUT;

/* init/shutdown library and misc functions */
#if defined __cplusplus
extern "C" {
#endif
    capi_result CAPI_EXTC
    cpike_init_gost(ike_gost_handle h, const IKE_GOST_IN*,
		    unsigned uFlags, IKE_GOST_OUT*);
    void CAPI_EXTC
    cpike_shutdown_gost(ike_gost_handle h, unsigned uFlags);
#if defined __cplusplus
}
#endif
#endif /* _IKE_GOST_H_ */
