#ifndef _CRYPT_MODULE_HPP_
#define _CRYPT_MODULE_HPP_

#include "reader/support.h"
#include "reader/dprint.h"

#include "cp_srdtsc.h"

#ifndef TEST_CONFORMITY
#ifdef _M_IX86
#pragma comment(lib,"..\\..\\..\\CSP\\out\\win32\\release\\dcpcspi.lib")
#else //_M_IX86
#pragma comment(lib,"..\\..\\..\\CSP\\out\\x64\\release\\dcpcspi.lib")
#endif //_M_IX86
#endif // not TEST_CONFORMITY

static const VTABLEPROVSTRUC VTABLE = { 3, NULL, NULL, PROV_GOST_2001_DH, NULL, 0, (CHAR*)DEFAULT_PROV_NAME_A};
static const PVTABLEPROVSTRUC PVTABLE = (PVTABLEPROVSTRUC)&VTABLE;

CPC_MEMORY_ARENA arena;
CPC_CONFIG config;

#define MAX_SESSIONS 1000
#define MAX_CONTEXTS 10
#define POOLS 16

LONG PoolSizes[POOLS];

CPC_CONFIG * GetCPCConfig(void);

CPC_CONFIG * GetCPCConfig(void)
{
    return &config;
}

static DWORD CPCAPI stdAllocMemory( LPCPC_MEMORY_ARENA pArena, CPC_SIZE_T dwSize, DWORD dwMemPoolId, DWORD dwThreadId, LPVOID *pRes )
{
    void * pMem = malloc (dwSize);
    UNUSED(pArena);
    UNUSED(dwThreadId);
    UNUSED(dwMemPoolId);
    if(!pMem)
	return (DWORD) NTE_NO_MEMORY;  
    *pRes = pMem;
    memset(pMem, 0, dwSize);
    return 0;
}
static DWORD CPCAPI stdFreeMemory( LPCPC_MEMORY_ARENA pArena, VOID *pMem, DWORD dwMemPoolId )
{ 
    UNUSED(dwMemPoolId);
    UNUSED(pArena);
    free (pMem);
    return 0;
}
static void CPCAPI stdValidateMemory( LPCPC_MEMORY_ARENA pArena ){ UNUSED(pArena); }
static void CPCAPI stdDoneMemory( LPCPC_MEMORY_ARENA pArena ){ UNUSED(pArena); }

static void CPCAPI TestPrintStr(void *v, const TCHAR *s)
{
    (void)v;
    _tprintf(_TEXT("%s\n"), s);
}

static unsigned long CPCAPI TestGetThreadId(void)
{
    return 0;
}

typedef struct timeval support_timeval;

#ifndef FREEBSD
#include <sys/timeb.h>
#endif

/*++++
 *    .
 ++++*/
#if defined WIN32
DWORD support_gettimeofday( support_timeval *stv )
{
/* FIXME dim      ?   Win  gettimeofday()?  */
#if defined _WIN32
   struct  __timeb64  tb;
   /*    ,   ,   support-,     */
    _ftime64( &tb );
    /* . -   64-    32-!
         2038  :) */
    stv->tv_sec = (long)tb.time;
    if( tb.time != stv->tv_sec )
	return (DWORD)NTE_PROVIDER_DLL_FAIL;
    stv->tv_usec= tb.millitm * 1000;
#else
    support_timeval tv;
    gettimeofday (&tv, (struct timezone *)0);
    stv->tv_sec = tv.tv_sec;
    stv->tv_usec= tv.tv_usec;
#endif	/* _WIN32 */
    return ERROR_SUCCESS;
}
#endif

static DWORD CPCAPI
TestGetTimeOfDay(CPC_timeval *pTV, LPVOID lpArg)
{
    support_timeval tv;
    (void)lpArg;

    tv.tv_sec = pTV->tv_sec;
    tv.tv_usec = pTV->tv_usec;
    if(support_gettimeofday(&tv) != ERROR_SUCCESS) {
	return (DWORD)NTE_FAIL;
    }
    pTV->tv_sec = tv.tv_sec;
    pTV->tv_usec = tv.tv_usec;
    return S_OK;
}

bool GetNewModule( HCRYPTMODULE * h, bool bVerbose, const CPC_FAST_CODE *pcfcCfg );
bool GetNewModule( HCRYPTMODULE * h, bool bVerbose, const CPC_FAST_CODE *pcfcCfg )
{
    static bool first = true;
    if( first )
    {
	memset( &config, 0, sizeof( config ) );
	config.cbSize = sizeof( config );
	config.pArena = &arena;
	{
	    arena.pAllocMemory = stdAllocMemory;
	    arena.pDoneMemory = stdDoneMemory;
	    arena.pFreeMemory = stdFreeMemory;
	    arena.pValidateMemory = stdValidateMemory;
	}
    }
    config.logConfig.name = TEXT("IPsecTest");
    config.logConfig.level = N_DB_ERROR;
    if (bVerbose) {
	config.logConfig.level |= N_DB_CALL|N_DB_TRACE|N_DB_LOG;
    }
    config.logConfig.format = SUPPORT_DBFMT_TEXT|SUPPORT_DBFMT_MODULE|
	SUPPORT_DBFMT_THREAD|SUPPORT_DBFMT_FLINE;
    config.logConfig.lpArg = NULL; // stderr
    config.logConfig.dprint_str = (bVerbose ? TestPrintStr : 0);
    config.logConfig.eprint_str = TestPrintStr;
    config.logConfig.cprint_str = TestPrintStr;
    config.logConfig.elprint_str = TestPrintStr;
    config.logConfig.get_thread_id = TestGetThreadId;
    config.timeFuncs.get_time_of_day = TestGetTimeOfDay;
    config.timeFuncs.read_tsc = cp_read_tsc;

    if (pcfcCfg) {
	config.FuncStruct.UsesFunctions = pcfcCfg->UsesFunctions;
	config.FuncStruct.UsedMask = pcfcCfg->UsedMask;
    }

    
#ifndef TEST_CONFORMITY
    if( !CPCCreateProvider( h, &config ) )
	return true;
    return false;
#else
    (void)h;
    return true;
#endif
}

static SUP_INLINE bool GetNewProv( HCRYPTMODULE m, HCRYPTPROV * phProv )
{
    LPCSTR DHoid = OID_ECCDHPRO, Ciphoid = OID_CipherVar_1, Hashoid = OID_HashVerbaO;
    VTABLEPROVSTRUC VTable = {3, NULL, NULL, PROV_GOST_2001_DH};
    if( !m->AcquireContext( m, phProv, NULL, CRYPT_VERIFYCONTEXT | CRYPT_SILENT, &VTable ) &&
	!m->SetProvParam( m, *phProv, PP_DHOID, (PBYTE)DHoid, 0 ) &&
	!m->SetProvParam( m, *phProv, PP_CIPHEROID, (PBYTE)Ciphoid, 0 ) &&
	!m->SetProvParam( m, *phProv, PP_HASHOID, (PBYTE)Hashoid, 0 ) )
	return true;
    return false;
}

#endif //_CRYPT_MODULE_HPP_
