/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2005-2014
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 *
 * This is proprietary information of
 * Crypto-Pro company.
 *
 * Any part of this file can not be copied, 
 * corrected, translated into other languages,
 * localized or modified by any means,
 * compiled, transferred over a network from or to
 * any computer system without preliminary
 * agreement with Crypto-Pro company
 */

/*
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 * 
 * \brief    IKEv1  CP-IKE-GOST
 *
 *   [IKE]   [draft.CPIKE]  
 *  IKE   .
 *
 * :
 *   [ipsec-registry] Internet Key Exchange (IKE) Attributes 
 *                    <http://www.iana.org/assignments/ipsec-registry>
 *   [IKE]            The Internet Key Exchange (IKE)
 *                    <http://tools.ietf.org/html/rfc2409#page-34>
 *   [rus.CPIKE]        28147-89,   34.11-94  
 *                      34.10-2001    IKE  
 *                    ISAKMP
 *                    <rus-fedchenko-cpike-ipsecme-gost-NN>
 *   [CPALGS]         Additional Cryptographic Algorithms for Use 
 *                    with GOST 28147-89, GOST R 34.10-94, 
 *                    GOST R 34.10-2001, and GOST R 34.11-94 
 *                    Algorithms
 *                    <http://tools.ietf.org/html/rfc4357>
 *   [DOI]            The Internet IP Security Domain of Interpretation 
 *                    for ISAKMP
 *                    <http://tools.ietf.org/html/rfc2407#section-4.4.3>
 *
 */

#ifndef _CP_IKE_GOST_H_
#define _CP_IKE_GOST_H_ 1

/*
 * IKE GOST Private attribute classes and class values
 * SHOULD announce by Vendor ID 
 */
    // [draft.CPIKE]
#define CPIKE_Ver_Major 1
#define CPIKE_Ver_Minor 1
#define CPIKE_Base_VID \
    '\x03', '\x10', '\x17', '\xE0', '\x7F', '\x7A', '\x82', '\xE3', \
    '\xAA', '\x69', '\x50', '\xC9', '\x99', '\x99' 
static const 
char CPIKE_Vendor_ID_1_1[] = {
    CPIKE_Base_VID,
    CPIKE_Ver_Major,
    CPIKE_Ver_Minor
};

static const
char CPIKE_Vendor_ID_1_0[] = {
    CPIKE_Base_VID,
    1,
    0
};

// Current
#define CPIKE_Vendor_ID_Current CPIKE_Vendor_ID_1_1

// [CheckPoint R75]
#define CPIKE_Vendor_ID_R75 CPIKE_Vendor_ID_1_1

// [CheckPoint R71]
#define CPIKE_Vendor_ID_R71 CPIKE_Vendor_ID_1_0

// [CheckPoint R65]
static const 
char CPIKE_Vendor_ID_R65[] = {
    '\xf4', '\xed', '\x19', '\xe0', '\xc1', '\x14', '\xeb', '\x51',
    '\x6f', '\xaa', '\xac', '\x0e', '\xe3', '\x7d', '\xaf', '\x28',
    '\x07', '\xb4', '\x38', '\x1f'
};

/*
 * Version specific ID
 */
typedef enum CPIKE_VER_SPEC {
    CPIKE_VER_SPEC_UNKNOWN = 0,
    CPIKE_VER_SPEC_R65,
    CPIKE_VER_SPEC_R71,
    CPIKE_VER_SPEC_CURRENT
} CPIKE_VER_SPEC_T;

// CFGMODE Vendor ID
static const 
char CPIKE_CFGMODE_Vendor_ID[] = { '\x09', '\x00', '\x26', '\x89', '\xDF', '\xD6', '\xB7', '\x12' };

/*
 * Attribute Classes
 */
typedef enum CPIKE_AC {
	// [IKE]
    CPIKE_AC_Encryption_Algorithm = 1,
    CPIKE_AC_Hash_Algorithm = 2,
    CPIKE_AC_Authentication_Algorithm = 3,
    CPIKE_AC_Group_Description = 4,
    CPIKE_AC_Group_Type = 5,
    CPIKE_AC_Life_Type = 11, // ID  (Attribute Class)
                             //       CPIKE_AC_Life_Duration.
                             //  API " IPsec"  ,
                             //   CPIKE_LIFET_KILOBYTES/CPIKE_LIFET_SECONDS
                             //    upClsType  p1_SetParamFn  p1_GetParamFn
    CPIKE_AC_Life_Duration = 12,
	// [draft.CPIKE]
    CPIKE_AC_Max_Messages = 32506,  // . -  2 ( 
				    // ,   QM)
    CPIKE_AC_PFS_Control = 32507,   // /  
				    // QM  PFS
    CPIKE_AC_Own_CFGMODE_Status = 32508,
    CPIKE_AC_Peer_CFGMODE_Status = 32509,
    //     Vendor ID  [draft.CPIKE]
    CPIKE_ACP_Get_Vendor_ID = 999990
} CPIKE_AC_T;

/*
 * Hash Algorithm (   PRF())
 */
typedef enum CPIKE_HASH {
	// [CPIKE], [draft.CPIKE], [CPALGS]
    CPIKE_HASH_A = 65501,   // id-GostR3411-94-CryptoProParamSet
	// [rus.CPIKEbis]
    // CPIKE_GOST_R_34_11_2012_256 = 65521,
    CPIKE_GOST_R_34_11_2012_512 = 65522
} CPIKE_HASH_T;

/*
 * Encryption Algorithm
 */
typedef enum CPIKE_ENC {
	// [CPIKE], [draft.CPIKE], [CPALGS]
    CPIKE_ENC_A = 65502,    // id-Gost28147-89-CryptoPro-A-ParamSet
    CPIKE_ENC_B = 65503,    // id-Gost28147-89-CryptoPro-B-ParamSet
    CPIKE_ENC_C = 65504,    // id-Gost28147-89-CryptoPro-C-ParamSet
    CPIKE_ENC_D = 65505,    // id-Gost28147-89-CryptoPro-D-ParamSet
	// [rus.CPIKEbis]
    CPIKE_ENC_TC26Z = 65523 // id-tc26-gost-28147-param-Z (GOST-Z-CFB-IMIT)
} CPIKE_ENC_T;

/*
 * Authentication Algorithm
 */
typedef enum CPIKE_AUTH {
	// [CPIKE], [draft.CPIKE]
    CPIKE_AUTH_GOST_PSK = 65506,	// IKE-GOST-PSK
    CPIKE_AUTH_GOST_SIGNATURE = 65508,  // IKE-GOST-SIGNATURE
    CPIKE_AUTH_GSS_API = 65001,		// IKE-GSS-API (works traditionally thats why no -GOST- word)
    CPIKE_AUTH_HYBRID_INIT_GOST = 65225,// IKE-GOST-HYBRID-INITIATOR 
    CPIKE_AUTH_HYBRID_RESP_GOST = 65226 // IKE-GOST-HYBRID-RESPONDER
} CPIKE_AUTH_T;

/*
 * Group Description
 */
typedef enum CPIKE_GROUP {
	// [CPIKE], [draft.CPIKE], [CPALGS]
    CPIKE_GROUP_XchA = 65509,	// id-GostR3410-2001-CryptoPro-XchA-ParamSet
				// id-GostR3411-94-CryptoProParamSet
    CPIKE_GROUP_XchB = 65510,	// id-GostR3410-2001-CryptoPro-XchB-ParamSet
				// id-GostR3411-94-CryptoProParamSet
	// [rus.CPIKEbis]
    CPIKE_VKO_GOST_R_34_10_2012_256A = 65524,	// id-GostR3410-2001-CryptoPro-XchA-ParamSet 
						// id-tc26-gost3411-12-256
    CPIKE_VKO_GOST_R_34_10_2012_256B = 65525,	// id-GostR3410-2001-CryptoPro-XchB-ParamSet 
    						// id-tc26-gost3411-12-256
    CPIKE_VKO_GOST_R_34_10_2012_512A = 65526,	// id-tc26-gost-3410-12-512-paramSetA 
						// id-tc26-gost3411-12-256
    CPIKE_VKO_GOST_R_34_10_2012_512B = 65527	// id-tc26-gost-3410-12-512-paramSetB 
    						// id-tc26-gost3411-12-256
} CPIKE_GROUP_T;

/*
 * Group Type
 */
typedef enum CPIKE_GTYPE {
    // [draft.CPIKE], [CPALGS]
    CPIKE_GTYPE_VKO_GOST_R_34_10 = 65511	// [CPALGS] par. 5.2
} CPIKE_GTYPE_T;

#define CPIKE_GTYPE_VKO_GOST_R_34_10_2001 CPIKE_GTYPE_VKO_GOST_R_34_10

/*
 * Life Type
 */
typedef enum CPIKE_LIFET {
	// [IKE]
    CPIKE_LIFET_SECONDS = 1,
    CPIKE_LIFET_KILOBYTES = 2
} CPIKE_LIFET_T;

/*
 * Life Duration
 */
    // [IKE] 
    //   long long     .
typedef unsigned int CPIKE_LDURATION_T;

    // [DOI] If unspecified, the default value shall be assumed to be
    // 28800 seconds (8 hours).
static const 
CPIKE_LDURATION_T CPIKE_DFLT_SEC_LDURATION = 8*60*60;

    // [draft.CPIKE] IKE    2^22 
static const
CPIKE_LDURATION_T CPIKE_DFLT_KILOBYTES_LDURATION = 4*1024;

    // [draft.CPIKE] IKE    24 
static const
CPIKE_LDURATION_T CPIKE_MAX_SEC_LDURATION = 24*60*60;
    // [draft.CPIKE] IKE    2^31-1024 
static const
CPIKE_LDURATION_T CPIKE_MAX_KILOBYTES_LDURATION = 2*1024*1024-1;

/*
 * Max Auth Error
 */
    // [draft.CPIKE]
typedef unsigned int CPIKE_MAX_AUTH_ERR_T;

    //      CPIKE_DFLT_MAX_AUTH_ERR  
static const
CPIKE_MAX_AUTH_ERR_T CPIKE_DFLT_MAX_AUTH_ERR = (1000*1000);

/*
 * Max Messages
 */
    // [draft.CPIKE]
typedef unsigned int CPIKE_MAX_MSGS_T;

    //    2,       1, 
    //      PFS,    2^16
static const
CPIKE_MAX_MSGS_T CPIKE_PFSONLY_MAX_MSGS = (1<<16);
    //    2,      1,  
    //     PFS   
    // ,    2^14
static const 
CPIKE_MAX_MSGS_T CPIKE_NONPFS_MAX_MSGS = (1<<14);

/*
 * PFS Control
 */
typedef enum CPIKE_PFSC {
	// [draft.CPIKE]
    CPIKE_PFSC_Enable_Non_PFS = 65512,	//   QM  PFS
					// CPIKE_AC_Max_Messages == 2^14
    CPIKE_PFSC_Disable_Non_PFS = 65513	//      QM   PFS
					// CPIKE_AC_Max_Messages == 2^16
} CPIKE_PFSC_T;

/*
 * CFGMODE Status
 */
typedef enum CPIKE_CFGMODE_STATUS {
	// [draft.CPIKE]
    CPIKE_CFGMODE_OK = 1,	    // OK
    CPIKE_CFGMODE_FAIL = 0    // NO AUTH
} CPIKE_CFGMODE_STATUS_T;

static const BYTE CPIKE_CFGMODE_TRANSACTION_EXCHANGE = 6;
static const BYTE CPIKE_QUICK_MODE_EXCHANGE = 32;
static const BYTE CPIKE_NEW_GROUP_MODE_EXCHANGE = 33;

/*
 *    () Vendor ID
 */
typedef const char **CPIKE_GET_VENDOR_ID_T;

#endif /* _CP_IKE_GOST_H_ */
