#ifndef CPPCADESDATE_H_
#define CPPCADESDATE_H_

#include "cplib/DateTime.h"
#include "atlcrypt2.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesDateObject
{
public:
    CPPCadesDateObject();
    ~CPPCadesDateObject();

    HRESULT Assign(ATL2::CCertStore* value);

    BOOL Item(unsigned int index, PCCERT_CONTEXT);
    BOOL Count(unsigned int* count);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesDateObject);
    CryptoPro::CDateTime m_date;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADESDATE_H_
