#ifndef CPPCADESCPATTRIBUTES_H_
#define CPPCADESCPATTRIBUTES_H_
#include "CPPCadesCPAttribute.h"
#include <vector>

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPAttributesObject
{
public:
    CPPCadesCPAttributesObject();
    ~CPPCadesCPAttributesObject();

    HRESULT get_Count(long* pVal);
    HRESULT get_Item(long Index,
        boost::shared_ptr<CPPCadesCPAttributeObject>& pVal);

    HRESULT Add(const boost::shared_ptr<CPPCadesCPAttributeObject>& pNewAttr);
    HRESULT Remove(long Index);
    HRESULT Clear();
    HRESULT Assign(PCCRYPT_ATTRIBUTES pAttrs);
    PCCRYPT_ATTRIBUTES get_CryptAttributesStruct();
    std::vector<boost::shared_ptr<CPPCadesCPAttributeObject> > m_pAttributes;

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPAttributesObject);
    void fill_CryptAttributesStruct();

    CRYPT_ATTRIBUTES m_CryptAttributes;
#ifndef UNIX
#pragma warning(push)
#pragma warning(disable: 4251)
#endif
    std::vector<CRYPT_ATTRIBUTE> m_pCryptAttributes;
#ifndef UNIX
#pragma warning(pop)
#endif
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADESCPATTRIBUTES_H_
