#ifndef CPPCADES_CP_ALGORITHM_OBJECT_H_
#define CPPCADES_CP_ALGORITHM_OBJECT_H_

#include "cppcades.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPAlgorithmObject
{
public:
    CPPCadesCPAlgorithmObject(void);
    ~CPPCadesCPAlgorithmObject(void);

    HRESULT get_Name(CADESCOM_ENCRYPTION_ALGORITHM *pVal);
    HRESULT put_Name(CADESCOM_ENCRYPTION_ALGORITHM pVal);
    HRESULT get_KeyLength(CAPICOM_ENCRYPTION_KEY_LENGTH *pVal);
    HRESULT put_KeyLength(CAPICOM_ENCRYPTION_KEY_LENGTH pVal);

    //internal use

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPAlgorithmObject);

    CADESCOM_ENCRYPTION_ALGORITHM m_alg;
    CAPICOM_ENCRYPTION_KEY_LENGTH m_length;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_ALGORITHM_OBJECT_H_

