/*
* Copyright(C) 2000  
*
*    , 
*    .
*
*        ,
* ,    ,
*     ,
* ,      
*     
*      .
*/

/*!
* \brief  ,     .    rdr.h - .
*/

#if !defined( _READER_INDEPENDENT_RDR_H )
#define _READER_INDEPENDENT_RDR_H

#include "reader/sup_syse.h"
#include "reader.kit/sup_sys.h"

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif /* HAVE_LIMITS_H */

#include "reader/support.h"
#include "BaseArithmDef_64.h"

#if defined( _MSC_VER )
#pragma warning( push )
#pragma warning( disable: 4100 4115 4201 4214 )

#include <windows.h>

#pragma warning( pop )
#endif /* defined( _MFC_VER ) */

/* **** **** defines **** **** */

/*! 
* \addtogroup rdr_ext_fkc_type
* \{
*/

/*! 
* \defgroup rdr_auth_type_const  ,    
* \brief     
* \{
*/

/*! 
* \defgroup rdr_auth_type_const_types  
* \brief   
* \{
*/

//!   PUK.       .    .
#define AUTH_TYPE_TYPE_PUK 0x10
//!   .       .    NULL-. 
#define AUTH_TYPE_TYPE_ROOT 0x20
//!   .       .
#define AUTH_TYPE_TYPE_CONT 0x30
//!     1
#define AUTH_TYPE_TYPE_USER_PIN1 0x40
//!     2
#define AUTH_TYPE_TYPE_USER_PIN2 0x50
//!   .       auth_type.
#define AUTH_TYPE_TYPE_MASK 0xF0

/*!* \} */

/*! 
* \defgroup rdr_auth_flags     .
* \brief     .   #READER_FUN_GET_PARAM TCEP_auth_types
* \{
*/

//!   PUK               ( ).
#define AUTH_FLAG_TYPE_PUK 1
//!   ROOT ()     .
#define AUTH_FLAG_TYPE_ROOT (AUTH_FLAG_TYPE_PUK<<1)
//!   CONT ( )      (),   . CONT -   (),     ,      .
#define AUTH_FLAG_TYPE_CONT (AUTH_FLAG_TYPE_ROOT<<1)
//!   .
#define AUTH_FLAG_TYPE_USER_PIN1 (AUTH_FLAG_TYPE_CONT<<1)
//!   .
#define AUTH_FLAG_TYPE_USER_PIN2 (AUTH_FLAG_TYPE_USER_PIN1<<1)
//!        . ,     ,       .        pin.
#define AUTH_FLAG_TYPE_ROOT_CONT (AUTH_FLAG_TYPE_USER_PIN2<<1)
//!   ROOT    .    PUK_ROOT,     AUTH_FLAG_TYPE_ROOT.
#define AUTH_FLAG_TYPE_PUK_ROOT (AUTH_FLAG_TYPE_ROOT_CONT<<1)
//!         .
#define AUTH_FLAG_TYPE_RESETS_COUNTERS (AUTH_FLAG_TYPE_PUK_ROOT<<1)
//! Depricated, not used
#define AUTH_FLAG_TYPE_SET_COUNTERS_ONLY (AUTH_FLAG_TYPE_PUK_ROOT<<1)
//!             READER_FUN_CLEAR_TRIES.
#define AUTH_FLAG_TYPE_CAN_RESET_COUNTERS (AUTH_FLAG_TYPE_RESETS_COUNTERS<<1)
//!            . 
#define AUTH_FLAG_TYPE_CAN_CHANGE_AUTH (AUTH_FLAG_TYPE_CAN_RESET_COUNTERS<<1)
//!       .      ,          .
//!  ,       
#define AUTH_FLAG_TYPE_IS_DEF_ROOT (AUTH_FLAG_TYPE_CAN_CHANGE_AUTH<<1)
//!       
#define AUTH_FLAG_TYPE_CAN_RESET_ROOT_DEF (AUTH_FLAG_TYPE_IS_DEF_ROOT<<1)
//!         
#define AUTH_FLAG_TYPE_RESTORE_CONT_AFTER_FOLDER_OPEN (AUTH_FLAG_TYPE_CAN_RESET_ROOT_DEF<<1)
//!           -  . ,    5 .
#define AUTH_FLAG_TYPE_HARDWARE_RESET_ROOT_DEF (AUTH_FLAG_TYPE_RESTORE_CONT_AFTER_FOLDER_OPEN<<1)
//!      ,   .
#define AUTH_FLAG_TYPE_USE_PASSWORD_TO_CHANGE (AUTH_FLAG_TYPE_HARDWARE_RESET_ROOT_DEF<<1)
//!      .       .   unique (XXX_123456)       . 
#define AUTH_FLAG_TYPE_COMMON_AUTH (AUTH_FLAG_TYPE_USE_PASSWORD_TO_CHANGE<<1)
//!       ,    PUK
#define AUTH_FLAG_TYPE_MAIN_CANT_CHANGE_ITSELF (AUTH_FLAG_TYPE_COMMON_AUTH<<1)
//! PUK     .       PUK,           PUK.
//!  ,       
#define AUTH_FLAG_TYPE_IS_DEF_PUK (AUTH_FLAG_TYPE_MAIN_CANT_CHANGE_ITSELF<<1)
//!   ,    ""  (  )
#define AUTH_FLAG_TYPE_AUTO_FORMAT (AUTH_FLAG_TYPE_IS_DEF_PUK<<1)

/*!* \} */

/*! 
* \defgroup rdr_auth_algs  .
* \brief ,     () . 
* \{
*/
//!    ,   .          . 
#define AUTH_TYPE_AUTH_NO 0x00
//!     (,    ).
#define AUTH_TYPE_AUTH_SELF 0x01
//!     -  (  VERIFY,   -).
#define AUTH_TYPE_AUTH_SIMPLE 0x02
//!    SESPAKE. 
#define AUTH_TYPE_AUTH_SESPAKE 0x03
//!    DH   (    ).  .
#define AUTH_TYPE_AUTH_DH 0x04
//!   
#define AUTH_TYPE_AUTH_MASK 0x0F

/*!* \} */

/*! 
* \defgroup rdr_auth_errs   
* \brief   ,     . 
* \{
*/
//!       ( ).
#define CPR_ERR_RDR_RETCODE (CPR_ERR_RETCODE + 0x1000)
//!     ( ).
#define CPR_ERR_RDR_NEED_AUTH (CPR_ERR_RDR_RETCODE + 0x0200)
//!   PUK
#define CPR_ERR_RDR_NEED_PUK_AUTH (CPR_ERR_RDR_NEED_AUTH + AUTH_TYPE_TYPE_PUK) 
//!    
#define CPR_ERR_RDR_NEED_ROOT_AUTH (CPR_ERR_RDR_NEED_AUTH + AUTH_TYPE_TYPE_ROOT)
//!    .
#define CPR_ERR_RDR_NEED_CONT_AUTH (CPR_ERR_RDR_NEED_AUTH + AUTH_TYPE_TYPE_CONT)
//!       ( 1 ).
#define CPR_ERR_RDR_NEED_USER_PIN1_AUTH (CPR_ERR_RDR_NEED_AUTH + AUTH_TYPE_TYPE_USER_PIN1) 
//!       ( 2 ).
#define CPR_ERR_RDR_NEED_USER_PIN2_AUTH (CPR_ERR_RDR_NEED_AUTH + AUTH_TYPE_TYPE_USER_PIN2) 
/*!* \} */
/*!* \} */

/*! 
* \defgroup rdr_return_errs    
* \brief   ,      - . 
* \{
*/
//!     .
#define CPR_ERR_RDR_NEED_CONNECT (CPR_ERR_RDR_RETCODE + 0x0301)
//!   .
#define CPR_ERR_RDR_NEED_APPLET (CPR_ERR_RDR_RETCODE + 0x0302)
//!   .
#define CPR_ERR_RDR_NEED_OPEN_FOLDER (CPR_ERR_RDR_RETCODE + 0x0303)
//!   .
#define CPR_ERR_RDR_NEED_OPEN_FILE (CPR_ERR_RDR_RETCODE + 0x0304)
//!    .
#define CPR_ERR_RDR_SM (CPR_ERR_RDR_RETCODE + 0x0305)
//!   .
#define CPR_ERR_RDR_FORMAT (CPR_ERR_RDR_RETCODE + 0x0306)

//!       .
#define CPR_ERR_RDR_CHANGE_PASSWORDS (CPR_ERR_RDR_RETCODE + 0x0400)
//!      PUK.
#define CPR_ERR_RDR_CHANGE_PUK (CPR_ERR_RDR_CHANGE_PASSWORDS + AUTH_TYPE_TYPE_PUK)
//!       .
#define CPR_ERR_RDR_CHANGE_ROOT (CPR_ERR_RDR_CHANGE_PASSWORDS + AUTH_TYPE_TYPE_ROOT)
//!       .
#define CPR_ERR_RDR_CHANGE_CONT (CPR_ERR_RDR_CHANGE_PASSWORDS + AUTH_TYPE_TYPE_CONT)
//!       1.
#define CPR_ERR_RDR_CHANGE_USER_PIN1 (CPR_ERR_RDR_CHANGE_PASSWORDS + AUTH_TYPE_TYPE_USER_PIN1)
//!       2.
#define CPR_ERR_RDR_CHANGE_USER_PIN2 (CPR_ERR_RDR_CHANGE_PASSWORDS + AUTH_TYPE_TYPE_USER_PIN2)

/*!* \} */

/*! 
* \defgroup rdr_reader_flags ,     
* \brief  ,   #SUPSYS_FUN_FLAGS
* \{
*/
//!     
#define RDR_FLAG_BLOCK_RDR 0x3000
//!     . 
#define RDR_FLAG_RDR_REMOVABLE 0
//!    ,    ,  
#define RDR_FLAG_RDR_UNIQUE 1
//!   ,    ,  .    HSM.
#define RDR_FLAG_RDR_PROTECTED 2
//!   .      ,   .
#define RDR_FLAG_RDR_VIRTUAL 3
//!  .  .
#define RDR_FLAG_RDR_VERSION_6 (RDR_FLAG_RDR_VIRTUAL+1)
//!   .        .
#define RDR_FLAG_RDR_SLOW 4
//!  .  .
#define RDR_FLAG_RDR_VERSION_7 (RDR_FLAG_RDR_SLOW+1)
//!  ,              .
#define RDR_FLAG_RDR_MINOR_INFO 5
//!  .  .
#define RDR_FLAG_RDR_VERSION_8 (RDR_FLAG_RDR_MINOR_INFO+1)

//!       RDR_FLAG_RDR_*  
#define TO_CP_FLAG(flag, value) ((value)<<(7-(flag))) 
/*!* \} */

/*! 
* \defgroup rdr_enum_flags ,     
* \brief ,     #READER_FUN_FOLDER_ENUM_OPEN
* \{
*/
//!     .
#define RDR_FOLDER_ENUM_FLAG_OPEN 0x0
//!    ,   .         .
#define RDR_FOLDER_ENUM_FLAG_NEW 0x1
//!   .       . 
#define RDR_FOLDER_ENUM_FLAG_END 0x2
/*!* \} */

/*! 
* \defgroup rdr_size_const ,     
* \brief    
* \{
*/
//!    . 
#define RDR_FOLDER_NAME_MAX_SIZE		(256)
//!  ,       256 
#define RDR_FKC_COORD_SIZE_256			(256/8)		// 32
//!  ,      256 
#define RDR_FKC_POINT_SIZE_256			(RDR_FKC_COORD_SIZE_256 * 2) // 64
//!  ,        256 
#define RDR_FKC_ORDER_SIZE_256			(256/8)		// 32
//!  ,  UKM  
#define RDR_FKC_UKM_SIZE_256			(64/8)		// 8
//!  ,  -  -256
#define RDR_FKC_HASH_VALUE_SIZE_256		RDR_FKC_ORDER_SIZE_256

//!  ,       512 
#define RDR_FKC_COORD_SIZE_512			(512/8)		// 64
//!  ,      512 
#define RDR_FKC_POINT_SIZE_512			(RDR_FKC_COORD_SIZE_512 * 2) // 128
//!  ,        512 
#define RDR_FKC_ORDER_SIZE_512			(512/8)		// 64
//!  ,   UKM
#define RDR_FKC_UKM_SIZE_512			(128/8)		// 16
//!  ,  -  -512
#define RDR_FKC_HASH_VALUE_SIZE_512		RDR_FKC_ORDER_SIZE_512
//!   SALT   SESPAKE
#define RDR_FKC_RNDM_SIZE_512			16
//!  ,  -  SHA-1
#define RDR_FKC_HASH_VALUE_SIZE_SHA1		20
//!  ,  -  SHA-224
#define RDR_FKC_HASH_VALUE_SIZE_SHA224		(224/8)
//!  ,  -  SHA-384
#define RDR_FKC_HASH_VALUE_SIZE_SHA384		(384/8)
//!  ,     ( )    34.12-2015   28147-89
#define RDR_EXCHANGE_KEY_LENGTH                 32
//!  ,     ( )  512 
#define RDR_EXCHANGE_KEY_512_LENGTH             64

//!  ,       192 
#define RDR_FKC_COORD_SIZE_192			(192/8)		// 24
//!  ,       224 
#define RDR_FKC_COORD_SIZE_224			(224/8)		// 28
//!  ,       384 
#define RDR_FKC_COORD_SIZE_384			(384/8)		// 48

//!  ,   RSA
#define RDR_FKC_RSA_MAX_MODULUS_BYTES		(1024)
/*!* \} */

/*!* \} */

/*!
* \defgroup reader_types     
*/

/*!
* \ingroup reader_types
* \defgroup rdr_ext_fkc_type     
* \{
*/

/*!
* \brief    
*/
typedef enum {
    CF_INVALID_FILE_NUMBER = 0,
    CF_MIN_FILE_NUMBER = 1, /*!<    */
    CF_MASKS = CF_MIN_FILE_NUMBER, /*!<     . */
    CF_PRIMARY, /*!<    . */
    CF_HEADER, /*!<      . */
    CF_MASKS2, /*!<     . */
    CF_PRIMARY2, /*!<    . */
    CF_NAME, /*!<    . */
    CF_DEF, /*!<       . */
    CF_MAX_FILE_NUMBER = CF_DEF, /*!<       */
    CF_CERT_KX, /*!<       AT_KEYEXCHANGE. (\ref csp_interface) */
    CF_CERT_SIG, /*!<       AT_SIGNATURE. (\ref csp_interface) */
    CF_EXT, /*!<    . (\ref csp_interface) */
    CF_MAX_FILE_NUMBER_CSP_INT = CF_EXT /*!<        csp_interface */
} TRdrFileNumber;

//!     .
#define MASKS_KEY_NAME _TEXT("masks.key")
//!    .
#define PRIMARY_KEY_NAME _TEXT("primary.key")
//!      .
#define HEADER_KEY_NAME _TEXT("header.key")
//!     .
#define MASKS2_KEY_NAME _TEXT("masks2.key")
//!    .
#define PRIMARY2_KEY_NAME _TEXT("primary2.key")
//!    . 
#define NAME_KEY_NAME _TEXT("name.key")
//!       .
#define DEF_KEY_NAME _TEXT("def.key")
//!       AT_KEYEXCHANGE. (\ref csp_interface)
#define CERTIFICATE_KX_KEY_NAME _TEXT("certificate_kx.key")
//!       AT_SIGNATURE. (\ref csp_interface)
#define CERTIFICATE_SIG_KEY_NAME _TEXT("certificate_sig.key")
//!    . (\ref csp_interface)
#define EXTENSIONS_KEY_NAME _TEXT("extensions.key")

/*! 
* \brief     .       (\ref rdr_auth_algs)   (\ref rdr_auth_type_const_types).
*/
typedef unsigned int TRdrLoginInfoType;

struct TRdrFolderEnumContext_;

/*! 
* \brief   ,  .
*/
typedef struct TRdrFolderEnumContext_ TRdrFolderEnumContext;

/*!
* \brief  ,  .
*/
typedef struct TRdrHashContext_ TRdrHashContext;

//!   
typedef struct
{
    BYTE x[RDR_FKC_COORD_SIZE_512]; /*!<  (mod p) x  big-endian.    2001 ,     .*/
    BYTE y[RDR_FKC_COORD_SIZE_512]; /*!<  (mod p) y  big-endian.    2001 ,     .*/
} TRdrFkcPoint;

typedef struct {
    DWORD exponent;
    DWORD modulus_size;
    BYTE modulus[RDR_FKC_RSA_MAX_MODULUS_BYTES]; /*big-endian*/
} TRdrFkcRsaKey;

typedef union {
    TRdrFkcPoint point;	    //!<  -  ,   
    TRdrFkcRsaKey rsa_key;  //!< RSA blob -  ,   
} TRdrPublicKey;

//!       
typedef BYTE TRdrFkcOrder[RDR_FKC_ORDER_SIZE_512];	/*!<     (mod q)  big-endian.    2001 ,     .*/

//! UKM   
typedef BYTE TRdrFkcUKM[RDR_FKC_UKM_SIZE_512];	/*!<    2001 ,     .*/

//!   -  SESPAKE.
typedef BYTE TRdrFkcRndm12[RDR_FKC_RNDM_SIZE_512];

//!     OID,  
#define RDR_MAX_OIDS_COUNT 50

//!       34.10-2001(2012)  EC DSA
typedef enum 
{
    RDR_FKC_IDG_CP_PARAM_START = 0,                                 /*!<  ,    .*/
    RDR_FKC_IDG_CP_OPTIONAL_PARAMSET = RDR_FKC_IDG_CP_PARAM_START,  /*!<  ,  256- ,  .*/
    RDR_FKC_IDG_CP_B_PARAMSET = 1,                                  /*!<  id-GostR3410-2001-CryptoPro-B-ParamSet (1.2.643.2.2.35.2)*/
    RDR_FKC_IDG_CP_A_PARAMSET = 2,                                  /*!<  id-GostR3410-2001-CryptoPro-A-ParamSet (1.2.643.2.2.35.1)*/
    RDR_FKC_IDG_CP_C_PARAMSET = 3,                                  /*!<  id-GostR3410-2001-CryptoPro-C-ParamSet (1.2.643.2.2.35.3)*/
    RDR_FKC_IDG_CP_A_256_PARAMSET = 4,                              /*!<   id-tc26-gost-3410-2012-256-paramSetA (1.2.643.7.1.2.1.1.1) */
    RDR_FKC_IDG_CP_OPTIONAL_512_PARAMSET = 8,                       /*!<  ,  512- ,  .*/
    RDR_FKC_IDG_CP_A_512_PARAMSET = 9,                              /*!<  id-tc26-gost-3410-12-512-paramSetA (1.2.643.7.1.2.1.2.1).*/
    RDR_FKC_IDG_CP_B_512_PARAMSET = 10,                             /*!<  id-tc26-gost-3410-12-512-paramSetB (1.2.643.7.1.2.1.2.2).*/
    RDR_FKC_IDG_CP_C_512_PARAMSET = 11,                             /*!<   id-tc26-gost-3410-12-512-paramSet (1.2.643.7.1.2.1.2.3).*/
    
    RDR_FKC_IDG_NIST_PRIME_192_V1 = 12,                             /*!<  prime192v1 (1.2.840.10045.3.1.1).*/
    RDR_FKC_IDG_NIST_SECP_224_R1 = 13,                              /*!<  secp224r1 (1.3.132.0.33).*/
    RDR_FKC_IDG_NIST_PRIME_256_V1 = 14,                             /*!<  prime256v1 (1.2.840.10045.3.1.7).*/
    RDR_FKC_IDG_NIST_SECP_384_R1 = 15,                              /*!<  secp384r1 (1.3.132.0.34).*/

    RDR_FKC_IDG_CP_PARAM_END = RDR_FKC_IDG_NIST_SECP_384_R1         /*!<  ,    .*/
} TRdrFkcEllipticPointParam;

//!   
typedef enum {
    TKeyAlgType_Unknown = 0x00,/*!<  ,  .*/
    TKeyAlgType_2001 = 0x01,  /*!<   34.10-2001*/
    TKeyAlgType_2012_256 = 0x02, /*!<   34.10-2012 (256)*/
    TKeyAlgType_2012_512 = 0x03, /*!<   34.10-2012 (512)*/
    TKeyAlgType_ECDSA = 0x04, /*!< NIST */
    TKeyAlgType_RSA = 0x05 /*!< RSA */
} TKeyAlgType;

/*! 
* \brief     SESPAKE
* \sa #rdr_folder_get_param, #rdr_folder_set_param, #rdr_get_auth_type
* 
*/
typedef enum {
    TSespakeCounterType_SESPAKE,		/*!<   SESPAKE*/
    TSespakeCounterType_fail, 			/*!<   */
    TSespakeCounterType_cfail, 			/*!<    */
    TSespakeCounterType_MAX_V1			/*!<    */
} TRdrFkcInfoSespakeCounter;

typedef enum {
    TRdrFkcSecureMessagingType_FKC,
    TRdrFkcSecureMessagingType_ISO,
    TRdrFkcSecureMessagingType_FKC_2015,
    TRdrFkcSecureMessagingType_FKC_AES
} TRdrFkcSecureMessagingType;

/*! \ingroup rdr_ext_folder_fkc_struct
* \brief     ()      .
*/
typedef enum {
    TCEP_sespake_counters,		/*!<    SESPAKE   .    BE- : cSESPAKE, cFail, cCFail.*/
    TCEP_default_password,		/*!< deprecated.  - TCEP_default_password_auth_type_ascii.      ROOT-. */
    TCEP_disable_default_password,	/*!< deprecated (not used)*/
    TCEP_fkc_flags, 			/*!<   ,     (#TRdrUniversalCarrierFlags functional_container == 1)*/
    TCEP_fkc_crypt_flags,		/*!< deprecated (not used)*/
    TCEP_auth_types,			/*!<  ,      */
    TCEP_uni_flags,			/*!<   ,   */
    TCEP_auth_state,		    	/*!<    . ERROR_SUCCESS - ; SCARD_W_CHV_BLOCKED - ; CPR_ERR_RDR_NEED_***_AUTH -  /  .*/
    TCEP_header,		        /*!<   header.key (Cloud).*/
    TCEP_cloud_auth_server,		/*!<    (Cloud).*/
    TCEP_cloud_sign_server,		/*!<    (Cloud).*/
    TCEP_cloud_username,		/*!<   (Cloud).*/
    TCEP_cloud_password,		/*!<   (Cloud).*/
    TCEP_cloud_OAuth2_auth_token,	/*!< access_token,    OAuth2 (Cloud).*/
    TCEP_cloud_OAuth2_id_token,		/*!< id_token,    OAuth2 (Cloud).*/
    TCEP_cloud_certificate,		/*!< C,  .     "" (Cloud).*/
    TCEP_cloud_certificate_id,		/*!<  ,    (Cloud).*/
    TCEP_fkc_csp_interface_container,	/*!<     .   .  ,  . */
    TCEP_default_password_auth_type,	/*!< deprecated.   TCEP_default_password_auth_type_ascii.      , 
					      auth_type,   TCHAR. deprecated. */
    TCEP_default_password_auth_type_ascii, /*!<      ,  auth_type,  ASCIIZ- (char*).*/
    TCEP_sm_params,			/*!<    .*/
    TCEP_cloud_extensions,		/*!<    (Cloud).*/
    TCEP_cloud_permissions		/*!<  (Cloud).*/
} TRdrFkcFolderEnumParam;

/*! \ingroup rdr_ext_folder_fkc_struct
* \brief ,    SESPAKE  BE- : cSESPAKE, cFail, cCFail.
* \sa \ref rdr_ext_folder_fkc_struct, #rdr_folder_get_param, #rdr_folder_set_param, #rdr_auth_info, #TRdrFkcInfoCounter
* 
*/
typedef DWORD TRdrFkcSespakeCounters[TSespakeCounterType_MAX_V1];

/*! \ingroup rdr_ext_trans_struct
* \brief     .
* \sa #rdr_sespake_first_step
* 
*/
typedef DWORD TRdrFkcTrID;

/*!
* \brief ,     
*/
typedef struct {
    unsigned folders : 1; /*!<       .  0     ,   .*/
    unsigned long_names : 1; /*!<     .  1,      ,   ,    (#READER_FUN_FOLDER_ENUM_OPEN).    ,  (folders == 1). */
    unsigned can_create_folder : 1; /*!<    ( -    ).    ,  (folders == 1). */
    unsigned functional_container : 1;  /*!<     (  , ).*/
    unsigned premapped_files : 1; /*!<         :      can_create_folder == 0*/
} TRdrUniversalCarrierFlags;

/*!
* \brief   
*/
typedef struct {
    unsigned SM : 1;		     /*!<       .  SESPAKE      1.*/
    unsigned genKey : 1;	     /*!<   /  .*/
    unsigned setKey : 1;	     /*!<       .*/
    unsigned presentFN : 1;	     /*!< deprecated, not used*/
    unsigned presentHash : 1;	     /*!<   ,    .*/
    unsigned ableDH : 2;             /*!<   VKO: 0 -  ; 1 -  VKO  ; 2 -   VKO.*/
    unsigned real_edwards_auth : 1;  /*!<    :   SESPAKE     .*/
    unsigned csp_interface : 1;      /*!<  :      .        0. (\ref csp_interface) */
    unsigned dh_supported_algid : 2; /*!<   VKO-: 0 -  ; 1 -  VKO GOST R 34.10-2001; 2 -  VKO GOST R 34.10-2012; 3 - .*/
    unsigned bad_rng : 1;            /*!<     ,  .        . */
    unsigned weak_airithmetic : 1;   /*!<     ,    . */
    unsigned gen_key_with_cert : 1;  /*!<            .  csp_interface. */
    unsigned support_ECDH : 1;       /*!<     VKO  ECDSA.  dh_supported_algid. */
} TRdrFkcCarrierFlags;


/*! 
* \defgroup rdr_cipher_modes   .
* \brief ,      .
* \{
*/
//!    CBC
#define RDR_FKC_CIPHER_MODE_CBC 0 
//!    CFB
#define RDR_FKC_CIPHER_MODE_CFB 1 //!<    CFB
//!    CNT
#define RDR_FKC_CIPHER_MODE_CNT 2 //!<    CNT ()
/*! \}*/

/*! 
* \brief   
 */
typedef struct {
    void * _pCallCtx; //!<  ,     .       READER_FUN_LOCK.
    void * _current_params; //!<  .
    const void * _pCont; //!<  .
    void * _hwnd; //!<    ,  .
    DWORD flags; //!<  .    CRYPT_SILENT.
    unsigned license; //!<  .
    BOOL isService; //!<     
} TProvCallCtx;

/*!
* \defgroup rdr_buttons     .
* \brief ,    ,     .
* \{
*/
//!   
#define RDR_MESSAGE_BUTTON_OK 1
//!   Cancel
#define RDR_MESSAGE_BUTTON_CANCEL 2
/*! \}*/

/*!
* \brief  ,     
*/
typedef WORD TRdrButtonsMask;

/*!
* \brief   
*/
typedef DWORD(*TFunComputeMac)(TProvCallCtx, const BYTE *, size_t, BYTE *, size_t *);

/*!
* \brief  
*/
typedef DWORD(*TFunEncrypt)(TProvCallCtx, const BYTE *, size_t, BYTE *, size_t *, BOOL *);

/*!
* \brief  
*/
typedef DWORD(*TFunDecrypt)(TProvCallCtx, const BYTE *, size_t, BYTE *, size_t *);

/*!
* \brief      
*/
typedef DWORD(*TFunGetCachePassword)(TProvCallCtx, DWORD, TSupSysInfoAsciiText *);

/*!
* \brief        
*/
typedef BOOL(*TWindowCheckCloseCallback)(void *);

/*!
* \brief      
*/
typedef DWORD(*TFunShowMessage)(TProvCallCtx, const TCHAR *, TWindowCheckCloseCallback, void *, TRdrButtonsMask);

/*!
* \brief    
*/
typedef DWORD(*TFunComputeHash)(TProvCallCtx, unsigned int /*algid*/, BYTE * /*data*/, size_t /*data_length*/, BYTE * /*hash*/, size_t * /*hash_length*/ );

/*!
* \brief    HMAC
*/
typedef DWORD(*TFunComputeHMAC)(TProvCallCtx, unsigned int /*algid*/, const BYTE * /*key*/, size_t /*key_length*/, const BYTE * /*data*/, size_t /*data_length*/, BYTE * /*out_hmac*/, size_t * /*out_hmac_length*/);

/*!
* \brief    
*/
typedef DWORD(*TFunGenRandom)(TProvCallCtx, BYTE * /*out_random*/, size_t /*in random_length*/);

/*!
* \brief       
*/
typedef void*(*TFunProtectedStoreCreate)(TProvCallCtx);

/*!
* \brief    
*/
typedef void(*TFunProtectedStoreDestroy)(void * /*store_handle*/);

/*!
* \brief     <->   
*/
typedef DWORD(*TFunProtectedStorePut)(TProvCallCtx, void * /*store_handle*/, BOOL /*isLM*/, const TCHAR * /*key*/, const BYTE * /*value*/, const size_t /*value_length*/);

/*!
* \brief         
*/
typedef DWORD(*TFunProtectedStoreGet)(TProvCallCtx, const void * /*store_handle*/, BOOL /*isLM*/, const TCHAR * /*key*/, BYTE * /*value*/, size_t * /*value_length*/);

/*!
* \brief         
*/
typedef void(*TFunProtectedStoreRemove)(void * /*store_handle*/, BOOL /*isLM*/, const TCHAR * /*key*/);

typedef TRdrFkcRsaKey TRdrAsn1BlobType_RSA_pubkey_struct; /*struct for TRdrAsn1BlobType_RSA_pubkey blob type*/

/*  ASN.1-*/
typedef enum {
  TRdrAsn1BlobType_RSA_pubkey /*PKCS#1   ;    TRdrAsn1BlobType_RSA_pubkey_struct*/
} TRdrAsn1BlobType;

/*!
* \brief      ASN.1-
*/
typedef DWORD (*TFunDecodeASN1Blob)(TProvCallCtx, TRdrAsn1BlobType /*blob_type*/, const BYTE* /*asn1blob*/, DWORD /*asn1blob_size*/, void* /*decoded_struct_buf*/, DWORD* /*decoded_struct_buf_size*/);

/*!
* \brief     
*/
typedef struct {
    TFunEncrypt encrypt; //!<     
    TFunDecrypt decrypt; //!<     
    TFunComputeMac compute_mac; //!<      
    TFunGetCachePassword get_password; //!<      
    TFunShowMessage show_message; //!<      
    TFunComputeHash compute_hash; //!<    
    TFunComputeHMAC compute_hmac; //!<    HMAC
    TFunGenRandom gen_random; //!<       
    TFunProtectedStoreCreate create_store; //!<       
    TFunProtectedStoreDestroy destroy_store; //!<    
    TFunProtectedStorePut put_to_store; //!<     <->   
    TFunProtectedStoreGet get_from_store; //!<         
    TFunProtectedStoreRemove remove_from_store; //!<         
    TFunDecodeASN1Blob decode_asn1_blob; //!<     ASN.1-  
} TCarrierCallbacks;

#endif /* !_READER_INDEPENDENT_RDR_H */
