/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/****
 * $Id: f12kunl.c 213792 2020-06-18 13:22:39Z frolov $
 *
 *       (READER).
 *
 *   /      (FAT12).
 *
 *   /      .
 *   .
 *
 * : fat12_unlink
 ****/

#include "fat12prj.h" /*+ Project (READER/FAT12) include.
     include    (READER/FAT12). +*/

/*++++ 
 *   .
 ++++*/
DWORD fat12_unlink( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TCHAR *file_name;
    TCHAR *fname;
    TReaderInfoUnlink *inf = (TReaderInfoUnlink*)info;
    TFat12Context *ctx = (TFat12Context*)context;

    SUPSYS_PRE_CONTEXT( context, TFat12Context );
    SUPSYS_PRE_INFO( info, TReaderInfoUnlink );
    SUPSYS_PRE_STRING_PTRS( inf->name.text, inf->name.length );
#ifdef UNIX
    SUPSYS_PRE( ctx->handle == NULL );
#else
    SUPSYS_PRE( ctx->handle == INVALID_HANDLE_VALUE );
#endif
    SUPSYS_PRE( ctx->path != NULL );

    fname = inf->name.text;
    file_name = malloc( ( _tcslen( fname )
	+ 2 + _tcslen( ctx->path )
	+ 1 + ( ctx->folder ? _tcslen( ctx->folder ) : 0 )
	+ 1 /* '\0' */ ) * sizeof( TCHAR ) );

    if( file_name == NULL )
	return (DWORD)NTE_NO_MEMORY;
    _tcscpy( file_name, ctx->path );
    if( ctx->folder )
    {
	_tcscat( file_name, ctx->folder );
	_tcscat( file_name, _TEXT( "/" ) );
    }
    _tcscat( file_name, fname );
#ifdef UNIX
    if( remove( file_name ) )
    {
        DWORD code = fat12_os_error();
        free(file_name);
        return code;
    }
#else
    {
        int tryes = SHARING_VIOLATION_TRIES;
        while (tryes > 0) {
            DWORD code;
            if (DeleteFile(file_name))
                break;
            code = fat12_os_error_inside();
            if (code == ERROR_CONTINUE) {
                code = (DWORD)SCARD_E_READER_UNAVAILABLE;
                tryes--;
                Sleep(5);
            }
            else {
                free(file_name);
                return code;
            }
        }
    }
#endif /* UNIX*/
    free( file_name );
    return ERROR_SUCCESS;
}

/*+ end of file: $Id: f12kunl.c 213792 2020-06-18 13:22:39Z frolov $ +*/
