#ifndef SUPPORT_TIME_H
#define SUPPORT_TIME_H
#if defined(UNIX) && !defined CSP_LITE
#   include <sys/time.h>
static SUP_INLINE void support_ms_sleep(int ms) {
    struct timespec tim, tim2;
    tim.tv_sec = 0;
    tim.tv_nsec = ms * 1000 * 1000; //ns = 1000us = 1000*1000ms
    nanosleep(&tim, &tim2);
}
#elif defined(_WIN32)
#define support_ms_sleep Sleep
#endif /* UNIX && !CSP_LITE */
#endif //SUPPORT_TIME_H
