/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*
 * \file $RCSfile$
 * \version $Revision: 206532 $
 * \date $Date:: 2020-02-12 14:10:57 +0300#$
 * \author $Author: sagafyin $
 * \brief      
 *  .
 */

#if !defined( _SUPPORT_SUP_SYS_H )
#define _SUPPORT_SUP_SYS_H

#include "reader/support.h"
#include "reader/sup_syse.h"

/*-------DBPrint----------------------------*/
#define SUPSYS_FTEXT(x) SUPPORT_DBFTEXT_(support_context_io, DTEXT( x ) )
#define SUPSYS_PRINTSTR(level,param) CONCAT(SUPPORT_DB_QPRINT_,level)(support_context_io,N_##level,param)
#define SUPSYS_PRINTHEX(level,buffer,length) CONCAT(SUPPORT_DB_QPRINT_HEX_,level)(support_context_io,N_##level,DTEXT(__FILE__), __LINE__, SFUNC,NULL,buffer,length)

/*    */
#define SUPSYS_TYPEO_ERROR CONS
#define SUPSYS_TYPEO_TRACE CONS
#define SUPSYS_TYPEO_TEST CONS

#ifdef DEBUG
#define SUPSYS_PRE_ACTION SUP_STOP
#else
#define SUPSYS_PRE_ACTION return (DWORD)ERROR_INVALID_PARAMETER
#endif

#define SUPSYS_PRE(x) { if( !(x) ) SUPSYS_PRE_ACTION; }
#define SUPSYS_PRE_INFO(x,t) SUPSYS_PRE_WRITE_PTRS(x,sizeof(t));// \
    //SUPSYS_PRE( ( *(size_t*)info ) >= (sizeof(t)) )
#define SUPSYS_PRE_CONTEXT(x,t) SUPSYS_PRE_WRITE_PTRS(x,sizeof(t))
#define SUPSYS_PRE_CCONTEXT(x,t) SUPSYS_PRE_READ_PTRS(x,sizeof(t))
#define SUPSYS_PRE_READ_PTRS(x,s) { if( !IS_READ_PTRS(x,s) ) SUPSYS_PRE_ACTION; }
#define SUPSYS_PRE_WRITE_PTRS(x,s) { if( !IS_WRITE_PTRS(x,s) ) SUPSYS_PRE_ACTION; }
#define SUPSYS_PRE_READ_PTR(x) { if( !IS_READ_PTR(x) ) SUPSYS_PRE_ACTION; }
#define SUPSYS_PRE_WRITE_PTR(x) { if( !IS_WRITE_PTR(x) ) SUPSYS_PRE_ACTION; }
#define SUPSYS_PRE_STRING_PTRS(x,s) { if( !IS_STRING_PTRS(x,s) ) SUPSYS_PRE_ACTION; }
#define SUPSYS_PRE_STRING_PTR(x) { if( !IS_STRING_PTR(x) ) SUPSYS_PRE_ACTION; }
#define SUPSYS_PRE_FUN(x) { if( !IS_FUN_PTR(x) ) SUPSYS_PRE_ACTION; }

#define SUPSYS_FUN_VERSION 0
#define SUPSYS_FUN_NICKNAME 0x1
#define SUPSYS_FUN_NAME 0x2
#define SUPSYS_FUN_COPYRIGHT 0x3
#define SUPSYS_FUN_ERROR 0x4	/* deprecated */
#define SUPSYS_FUN_INSTANCE 0x5
#define SUPSYS_FUN_CONTEXT_DUP 0x6
#define SUPSYS_FUN_CONTEXT_FREE 0x7
#define SUPSYS_FUN_IDS_BLOCK 0x8
#define SUPSYS_FUN_ITEM_ICON 0x9 /* 2016-may-31: sagafyin ,      */
#define SUPSYS_FUN_DETAIL_NAME 0xA /* ,     iOS */
#define SUPSYS_FUN_COMPANY 0xB
#define SUPSYS_FUN_FLAGS 0xC
#define SUPSYS_FUN_CALL 0xD
#define SUPSYS_FUN_GROUP_ENUM_OPEN 0xE
#define SUPSYS_FUN_GROUP_ENUM_NEXT 0xF
#define SUPSYS_FUN_GROUP_ENUM_CLOSE 0x10
#define SUPSYS_FUN_GROUP_NICKNAME 0x11 /* deprecated */
#define SUPSYS_FUN_VERSIONSUPPORT 0x12
#define SUPSYS_FUN_GROUP_CHANGED 0x13 /* deprecated */
#define SUPSYS_FUN_APPLET_TERM 0x14

#define SUPSYS_FUN_REGISTER 0x1000
#define SUPSYS_FUN_UNREGISTER 0x1001
#define SUPSYS_FUN_PRODUCER 0x1002
#define SUPSYS_FUN_PRODUCER_VERSION 0x1003
#define SUPSYS_FUN_CONNECT_OPEN 0x1004
#define SUPSYS_FUN_CONNECT_NEXT 0x1005
#define SUPSYS_FUN_CONNECT_CLOSE 0x1006
#define SUPSYS_FUN_CONNECT_VALID 0x1007 /*  dallas */
#define SUPSYS_FUN_CONNECT 0x1008
#define SUPSYS_FUN_DISCONNECT 0x1009
#define SUPSYS_FUN_CONNECT_REMOVE 0x100A

#define SUPSYS_FUN_START (UINT_MAX) /* deprecated */

#define SUPSYS_FLAG_BLOCK_CONNECT 1
#define SUPSYS_FLAG_CONNECT_MANY 0
#define SUPSYS_FLAG_CONNECT_COM 1
#define SUPSYS_FLAG_CONNECT_LPT 2
#define SUPSYS_FLAG_CONNECT_AUTO 3
#define SUPSYS_FLAG_CONNECT_VERSION_1 4
#define SUPSYS_FLAG_CONNECT_MULTY 4
#define SUPSYS_FLAG_CONNECT_VERSION_2 5
#define SUPSYS_FLAG_CONNECT_PNPGROUP 5
#define SUPSYS_FLAG_CONNECT_VERSION_3 6

#define SUPSYS_CONNECT_START 0
#define SUPSYS_CONNECT_AUTO 1
#define SUPSYS_CONNECT_COM1 0x10
#define SUPSYS_CONNECT_COM2 0x11
#define SUPSYS_CONNECT_COM3 0x12
#define SUPSYS_CONNECT_COM4 0x13
#define SUPSYS_CONNECT_COM_MAX SUPSYS_CONNECT_COM4
#define SUPSYS_CONNECT_LPT1 0x20
#define SUPSYS_CONNECT_LPT2 0x21
#define SUPSYS_CONNECT_LPT_MAX SUPSYS_CONNECT_LPT2
#define SUPSYS_CONNECT_USER 0x100
#define SUPSYS_CONNECT_MAX UINT_MAX

#define SUPSYS_IDS_BLOCK_BASE 0
#define SUPSYS_IDS_BLOCK_ERROR 1
#define SUPSYS_IDS_BLOCK_ICON 2
#define SUPSYS_IDS_BLOCK_ICON_EXTENDED 7

#define SUPSYS_IDS_BASE 0x1000
#define SUPSYS_IDS_NAME 0
#define SUPSYS_IDS_NICKNAME 1
#define SUPSYS_IDS_DETAIL_NAME 2
#define SUPSYS_IDS_PRODUCER 3
#define SUPSYS_IDS_GROUP_NICKNAME 4
#define SUPSYS_IDS_GROUP_NAME 5
#define SUPSYS_IDS_APPLET_TERM 6
#define SUPSYS_IDS_BASE_QUANT_V1 ( SUPSYS_IDS_GROUP_NICKNAME + 1 )
#define SUPSYS_IDS_BASE_QUANT_V2 ( SUPSYS_IDS_GROUP_NAME + 1 )
#define SUPSYS_IDS_BASE_QUANT_V3 ( SUPSYS_IDS_APPLET_TERM + 1)

#define SUPSYS_IDS_ERROR_BASE 0x1100
#define SUPSYS_IDS_ERROR_QUANT_V1 0xEFF

#define SUPSYS_IDS_ICON_BASE 0x1000
#define SUPSYS_IDS_ICON_ITEM 0
#define SUPSYS_IDS_ICON_QUANT_V1 ( SUPSYS_IDS_ICON_ITEM + 1 )

#define SUPSYS_IDS_ICON_BASE_EXTENDED 0x1020
#define SUPSYS_IDS_ICON_ITEM_INSERTED 1
#define SUPSYS_IDS_ICON_ITEM_ERROR 2
#define SUPSYS_IDS_ICON_ITEM_UNKNOWN 3
#define SUPSYS_IDS_ICON_ITEM_BLOCKED 4
#define SUPSYS_IDS_ICON_EXTENDED_QUANT_V1 ( SUPSYS_IDS_ICON_ITEM_BLOCKED + 1 )
#define SUPSYS_IDS_ICONS_NUMBER (SUPSYS_IDS_ICON_EXTENDED_QUANT_V1)

typedef void TSupSysInfo;
typedef void TSupSysContext;

typedef struct TSupSysInfoUntyped_
{
    size_t length;
    unsigned char *info;
} TSupSysInfoUntyped;

typedef struct TSupSysInfoAsciiText_ {
    size_t length;
    char *text;
} TSupSysInfoAsciiText;

typedef struct TSupSysMultiStringAsciiText_ {
    size_t buf_len;
    char* buf;
} TSupSysMultiStringAsciiText;

typedef struct TSupSysInfoText_
{
    size_t length;
    TCHAR *text;
} TSupSysInfoText;

typedef struct
{
    size_t bits;
    unsigned char *string;
} TSupSysInfoBitString;

/*   -->    */
typedef struct TSupSysInfoNickname_
{
    TSupSysNickname nickname;
} TSupSysInfoNickname;

typedef unsigned TSupSysInfoVersion[4];

/*   -->    */
typedef struct TSupSysInfoContextDup_
{
    TSupSysContext *dest_context;
} TSupSysInfoContextDup;

typedef struct TSupSysInfoIDSBaseItem_
{
    size_t block;
    int base;
    size_t quant;
} TSupSysInfoIDSBaseItem;

typedef struct TSupSysInfoIDSBase_
{
    size_t blocks;
    const TSupSysInfoIDSBaseItem *items;
} TSupSysInfoIDSBase;

typedef struct
{
    const TSupSysEContext *context;
    TSupSysInfoText name;
    unsigned num;
    TSupSysInfoUntyped add_info;
} TSupSysInfoConnectEnum;

typedef struct TSupSysInfoConnect_
{
    TSupSysInfoText name;
    unsigned num;
} TSupSysInfoConnect;

typedef struct TSupSysInfoConnect_ TSupSysInfoConnectValid;

typedef struct TSupSysInfoConnect_ TSupSysInfoConnectRemove;

typedef struct TSupSysInfoFlags_
{
    size_t type;
    TSupSysInfoBitString string;
} TSupSysInfoFlags;

typedef DWORD(*TSupSysFunction) (TSupSysContext *context, TSupSysInfo *info);

//    CRC   . 
//      ,  \0,     (ASCIIZZ).
typedef void(*TSupSysComputeCheckMark) (const TCHAR * reader_list, unsigned short *mark);

typedef struct TSupSysInfoCall_
{
    unsigned num;
    TSupSysFunction fun;
    TSupSysInfo *info;
} TSupSysInfoCall;

typedef struct TSupSysInfoRegister_
{
    TSupSysContext *context;
    TSupSysInfoText in_group_name;
    TSupSysInfoText path_to_item;
    TSupModuleInstance support_module;
} TSupSysInfoRegister;

typedef struct TSupSysFunctionTableItem_
{
    unsigned num;
    TSupSysFunction function;
} TSupSysFunctionTableItem;

typedef struct TSupSysFunctionTable_
{
    size_t quant;
    const TSupSysFunctionTableItem *table;
} TSupSysFunctionTable;

typedef struct {
    const TSupSysEContext *context;
    TSupSysInfoText name;
    TSupSysInfoUntyped add_info;
    unsigned short change_mark;
    TSupSysComputeCheckMark compute_mark_func;
} TSupSysInfoGroupEnum;

typedef const TSupSysFunctionTable* (*TSupSysExportFunction)( void );
#endif /* !_SUPPORT_SUP_SYS_H */
