/*
* Copyright(C) 2000  
*
*    , 
*    .
*
*        ,
* ,    ,
*     ,
* ,      
*     
*      .
*/

/****
* $Id: f12grpc.c 204903 2020-01-14 08:00:11Z dim $
*
*       (READER).
*
*   /      (FAT12).
*
*      .
*     .
*
* : fat12_group_enum_close
****/

#include "fat12prj.h"

DWORD fat12_group_enum_close(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TSupSysInfoGroupEnum *inf = (TSupSysInfoGroupEnum*)info;
    TFat12ConnectEnum *enum_ptr;

    UNUSED( context );
    SUPSYS_PRE_INFO( info, TSupSysInfoGroupEnum);

    enum_ptr = (TFat12ConnectEnum*)inf->add_info.info;
    if( enum_ptr == NULL )
    {
	inf->add_info.length = 0;
	return ERROR_SUCCESS;
    }
#ifdef UNIX
    if( enum_ptr->drive_strings ){
	TFat12ConnectEnumElem *el=enum_ptr->drive_strings;

	for(enum_ptr->cur=el;enum_ptr->cur;enum_ptr->cur=el){
	    el=enum_ptr->cur->next;
	    free(enum_ptr->cur->connect_str);
	    free(enum_ptr->cur);
	}
    }
#else /* UNIX */
    free(enum_ptr->drive_strings);
#endif
    free( enum_ptr );
    inf->add_info.length = 0;
    inf->add_info.info = NULL;
    return ERROR_SUCCESS;
}
