/*!
* \file $RCSfile$
* \version $Revision: 133768 $
* \date $Date:: 2016-02-03 09:22:15 +0300#$
* \author $Author: spv $
*
* \brief   atlbase.h   ATL Microsoft.
*
*   .
*/
#ifndef _ATLEXCEPT2_H_INCLUDED
#define _ATLEXCEPT2_H_INCLUDED

#include <atlexcept.h>

namespace ATL2 {

#if _ATL_VER < 0x0800
#ifndef AtlThrow
#ifndef _ATL_CUSTOM_THROW
#define AtlThrow ATL::AtlThrow
#endif
#endif // AtlThrow
#endif // _ATL_VER < 0x0800

ATL_NOINLINE __declspec(noreturn) inline void WINAPI AtlThrowWin32(DWORD dwError)
{
    AtlThrow( HRESULT_FROM_WIN32( dwError ) );
}

ATL_NOINLINE inline void WINAPI AtlThrowIfError(HRESULT hr)
{
    if (FAILED(hr))
	AtlThrow( hr );
}

ATL_NOINLINE inline void WINAPI AtlThrowWin32IfError(DWORD dwError)
{
    if (dwError)
	AtlThrowWin32( dwError );
}

} // namespace ATL2

#ifndef _ATL2_NO_AUTOMATIC_NAMESPACE
using namespace ATL2;
#endif //!_ATL2_NO_AUTOMATIC_NAMESPACE

#endif // _ATLEXCEPT2_H_INCLUDED
