<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>


<xsl:template match="Certificate" name="Certificate">
<xsl:param name="Included"/>

<xsl:if test="$Included = 'false'">

    <!-- Header   -->

	<!--    -->
  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
      <fo:block text-align="left" font-size="8pt">      

	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_serial_num</xsl:with-param> </xsl:call-template> 		<!--  -->

	<xsl:value-of select="tbsCertificate/serialNumber"/>
      </fo:block>

       <!--     -->
      <!-- <fo:block text-align="center" font-size="8pt">
      </fo:block>
      <fo:block text-align="right" font-size="8pt">     
	<fo:inline text-decoration="underline">

 	  <xsl:call-template name="printPERS"> <xsl:with-param name="persID">form_nf_cert_title</xsl:with-param> </xsl:call-template>

	</fo:inline>
      </fo:block> -->
    </fo:block>
  </fo:static-content>



      <!-- Footer -->

  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>






          
	<!--   -->
  <fo:flow flow-name="xsl-region-body">

    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"
	      space-before="32pt"
	      space-after="16pt"
	      space-before.precedence="0"               
	      space-after.precedence="3"
	      keep-with-next="always"
	      >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Certificate_header</xsl:with-param> </xsl:call-template>
    </fo:block>


            <!--     -->	  
    <xsl:call-template name="uc_title"/>



         <!--     -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Certificate_info</xsl:with-param> </xsl:call-template>              <!--  -->
    </fo:block>

	
	<!--  TBSCertificate-->

    <xsl:for-each select="./tbsCertificate">  
	<xsl:call-template name="TBSCertificate"/>
    </xsl:for-each>
 


	<!-- :-->
     <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithm"/>
    </xsl:for-each>



	<!--   -->
     <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>




	<!-- Footer  -->

	<!--    -->	
<!--     <xsl:call-template name="skzi_list"/> -->


	<!--     /   -->
    <xsl:call-template name="stamp-issuer-or-subject">
      <xsl:with-param name="title">
	<xsl:call-template name="printPERS"> <xsl:with-param name="persID">pers_ul_title</xsl:with-param> </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>

	<!--     /  |   -->
<!--     <xsl:call-template name="stamp-issuer-or-subject">
      <xsl:with-param name="title">
	<xsl:choose>
	  <xsl:when test="$IsSelfSigned = 0">
		<xsl:call-template name="printPERS"> <xsl:with-param name="persID">pers_vl_title</xsl:with-param> </xsl:call-template>
	  </xsl:when>
	  <xsl:otherwise>
		<xsl:call-template name="printPERS"> <xsl:with-param name="persID">pers_ul_ufo_title</xsl:with-param> </xsl:call-template>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:with-param>
    </xsl:call-template>
-->


    <fo:block id="end of certificate">
    </fo:block>





  </fo:flow>
</xsl:if>


<xsl:if test="$Included != 'false'">

         <!--     -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Certificate_info</xsl:with-param> </xsl:call-template>              <!--  -->
    </fo:block>

	
	<!--  TBSCertificate-->

    <xsl:for-each select="./tbsCertificate">  
	<xsl:call-template name="TBSCertificate"/>
    </xsl:for-each>
 


	<!-- :-->
     <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithm"/>
    </xsl:for-each>



	<!--   -->
     <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>

</xsl:if>

</xsl:template>








<!--             !!! --> 


	<!--  TBSCertificate-->
<xsl:template name="TBSCertificate" match="TBSCertificate">


    <!--   -->	
     <xsl:for-each select="./version">  
	<xsl:call-template name="Version"/>
    </xsl:for-each>


    <!--    -->	
     <xsl:for-each select="./serialNumber">  
	<xsl:call-template name="CertificateSerialNumber"/>
    </xsl:for-each>


	<!-- -->

  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_issuer</xsl:with-param> </xsl:call-template>		<!--  --> 	
  </fo:block>

	<!--   -->
     <xsl:for-each select="./issuer">  
	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="Name"/>
	</fo:block>
    </xsl:for-each>





	<!--    -->
  <xsl:if test="count(issuerUniqueID)>=1">

	<!--   -->
     <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_issuerUniqueID</xsl:with-param> </xsl:call-template>		<!--  --> 	
     </fo:block>

	<!--   -->
     <xsl:for-each select="./issuerUniqueID">  
	<xsl:call-template name="UniqueIdentifier"/>
    </xsl:for-each>

  </xsl:if> 






     <!--   -->

     <xsl:for-each select="./validity">  
	<xsl:call-template name="Validity"/>
    </xsl:for-each>




	<!--  -->

	<!--  -->
  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_subject</xsl:with-param> </xsl:call-template>		<!--  --> 	
  </fo:block>

	<!--   -->

     <xsl:for-each select="./subject">  
	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="Name"/>
	</fo:block>
    </xsl:for-each>



	<!--   -->
  <xsl:if test="count(subjectUniqueID)>=1">

	<!--   -->
     <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_subjectUniqueID</xsl:with-param> </xsl:call-template>		<!--  --> 	
     </fo:block>

	<!--   -->
     <xsl:for-each select="./subjectUniqueID">  
	<xsl:call-template name="UniqueIdentifier"/>
    </xsl:for-each>

  </xsl:if> 



	<!--      -->

     <xsl:for-each select="./subjectPublicKeyInfo">  
	<xsl:call-template name="SubjectPublicKeyInfo"/>
    </xsl:for-each>



	<!--   -->
	<!--   : -->
  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TBSCertificate_extensions</xsl:with-param> </xsl:call-template>				<!--  -->
  </fo:block>

	<!--   -->
  <fo:block font-family="Times" font-size="10pt"
	    margin-left="1.5em"
	    >

     <xsl:for-each select="./extensions">  
	<xsl:call-template name="Extensions"/>
    </xsl:for-each>

  </fo:block>

</xsl:template>






<xsl:template name="OID">
	<xsl:value-of select="."/>
</xsl:template>



      	<!--   -->
<xsl:template name="Extensions" match="Extensions">
	<xsl:for-each select="./Extension">
      	<!--   -->
		<xsl:call-template name="Extension"/>
	</xsl:for-each>
</xsl:template>

      	<!--   -->
<xsl:template name="Extension" match="Extension">

  <fo:block font-family="Times" font-size="10pt"                                
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >


	<xsl:for-each select="./extnID">
      	<!--   -->
		<xsl:call-template name="printOID"/>
	</xsl:for-each>


	<!--   -->

    <xsl:if test='critical/true'>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_cryt_ext</xsl:with-param> </xsl:call-template>					<!--  -->
    </xsl:if>
 </fo:block>

	<!--    -->
  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"

	    >
    <xsl:choose>
      <xsl:when test='extnValue/*'>

<!--	<xsl:call-template name="split">
	  <xsl:with-param name="val"> -->

	    <xsl:apply-templates select="extnValue/*"/>

<!--	  </xsl:with-param>
	</xsl:call-template> -->

      </xsl:when>
      <xsl:otherwise>
	<xsl:call-template name="split">
	  <xsl:with-param name="val">
	    <xsl:value-of select="extnValue"/>					<!--    -->
	  </xsl:with-param>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </fo:block>

</xsl:template>







<xsl:template match="KeyPurposeId" name="KeyPurposeId">
    <xsl:call-template name="printOID"/>
    <xsl:text> </xsl:text>
</xsl:template>






<!--          ANY -->

<xsl:template match="//publicKeyParamSet">
    <xsl:call-template name="PublicKeyParamSet"/>
</xsl:template>


<xsl:template match="//encryptionParamSet">
    <xsl:call-template name="EncryptionParamSet"/>
</xsl:template>

<xsl:template match="//digestParamSet">
    <xsl:call-template name="DigestParamSet"/>
</xsl:template>

	<!--    -->
<xsl:template match="cA/true">
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_cert_cent</xsl:with-param> </xsl:call-template>
</xsl:template>

<xsl:template match="NULLParams" name="NULLParams">
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_NULLParams</xsl:with-param> </xsl:call-template>
</xsl:template>






</xsl:stylesheet>


