#!/bin/sh
# vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[]
#
# Copyright(C) 2005-2013  
#
#    , 
#    .
#
#        ,
# ,    ,
#     ,
# ,      
#     
#      .
#
#  ,    , 
#         
#   .
#
#  -   
#     .
#

mnt=/home/ftp/pub
base=$mnt/4_0/linux-x86_gcc34

while getopts d:r:D:R:l: nm; do
	case $nm in
	d)
		fcsp="$base/$OPTARG/debug"
		fipsec="$base/$OPTARG/debug"
		;;
	r)
		fcsp="$base/$OPTARG/release"
		fipsec="$base/$OPTARG/release"
		;;
	D)
		fcsp="$base/checked/debug"
		fipsec="$base/$OPTARG/debug"
		;;
	R)
		fcsp="$base/checked/release"
		fipsec="$base/$OPTARG/release"
		;;
	l)
		license="$OPTARG"
		;;
	?)
		printf \
			'Usage: %s [-d <debug>] [-r <release>] [-c <checked>] [-l <license> [<dist>]\n' \
			"$0"
		exit 2
		;;
	esac
done
shift $(($OPTIND - 1))

t=${1:-.}

conf="
	libstdc++-3.4.4-2.fc3.i386.rpm
	cprocsp-compat-splat-1.0.0-1.noarch.rpm
    "

cpbin="
	lsb-cprocsp-base-3.6*noarch.rpm 
	lsb-cprocsp-rdr-3.6*86.rpm
	lsb-cprocsp-kc1-3.6.*.i486.rpm 
	lsb-cprocsp-capilite-3.6*86.rpm 
	lsb-cprocsp-devel-3.6*noarch.rpm 
	cprocsp-drv-2.4.21-21cp-3.6*86.rpm
    "
ipbin="
	cprocsp-ipsec-devel-3.6*noarch.rpm 
	cprocsp-ipsec-esp-2.4.21-21cp-3.6*86.rpm 
	cprocsp-ipsec-genpsk-3.6*86.rpm 
	cprocsp-ipsec-ike-3.6*86.rpm 
    "
cpsrc=cprocsp-drv-3.6*src.rpm 
ipsrc=cprocsp-ipsec-esp-3.6*src.rpm

cpprg="drtcsp/dmntcs drtcsp/drtcsp.o"
ipprg="drvesptest/example_io_krn 
	drvesptest/testesp.o drvesptest/testesp.ko" # TODO: .ko/.o

revout() {
	first="$1"
	shift && (
		revout "$@"
	)
	basename $t/$first
}

reverse() {
	pattern="$1"
	shift
	revout "$@" | sed -n "$pattern"
}
 
if [ ! -z "$fcsp" ]; then
	mount $mnt
	mount -o remount $mnt

	mkdir -p $t
	mkdir $t/srpm

	for i in $conf ; do
	    cp $fcsp/../$i $t/.
	done

	for i in $cpbin ; do
	    cp $fcsp/$i $t/.
	done

	for i in $cpsrc ; do
	    cp $fcsp/$i $t/srpm/.
	done

	for i in $cpprg ; do
	    cp $fcsp/SPLAT/$i $t/.
	    chmod a+x $t/`basename $i`
	done

	for i in $ipbin ; do
	    cp $fipsec/$i $t/.
	done

	for i in $ipsrc ; do
	    cp $fipsec/$i $t/srpm/.
	done

	for i in $ipprg ; do
	    cp $fipsec/SPLAT/$i $t/.
	    chmod a+x $t/`basename $i`
	done

	if [ "$t" != "." ]; then
	    cp install.sh check_install.sh $t/.
	    cp gdb-t72 $t/.
	    chmod a+x $t/gdb-t72
	    cp gdb-cos3 $t/.
	    chmod a+x $t/gdb-cos3
	fi
fi

/sbin/rmmod drtcsp
/sbin/rmmod testesp
/sbin/rmmod esp_gost
/sbin/rmmod drvcsp

for i in `reverse 's/\.[^.]*[6h]\.rpm//p' $conf $cpbin $ipbin` ; do
    rpm -e $i
done

for i in $conf $cpbin $ipbin; do 
    rpm -i $t/$i
done

ldconfig

if [ -z "$license" ]; then
    license="`cat license.txt`"
    if [ -z "$license" ]; then
        printf '%s: No license (file license.txt not found and not "-l" argument\n' "$0" 1>&2
	exit 1
    fi
fi
/opt/cprocsp/sbin/ia32/cpconfig -license -set "$license"
#
#      SPLAT
#/opt/cprocsp/sbin/ia32/cpconfig -ini '\config\apppath' -add string libcurl.so /usr/lib/libcurl.so
#
