/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2005-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

/*
 * \version $Revision: 204906 $
 * \date $Date:: 2020-01-14 11:27:14 +0300#$
 * \author $Author: dim $
 */

/*
 * \brief     IKE
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#ifdef HAVE_CPRO_CONFIG_H
#include "myconfig.h"
#endif
#ifndef _WIN32
#   include <unistd.h>
#else
#   include <io.h>
#   include "BaseTsd.h"
#   define ssize_t SSIZE_T
#endif
#include <stdarg.h>
#include <time.h>
#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#endif
#include "wincspc.h"
#include "typedefs.h"
#include "ike_gost.h"
#include "init_plg.h"

#if !defined UNUSED
#   define UNUSED(x) ((void)(x))
#endif // UNUSED

static void CAPI_EXTC 
logger_func(void *a, 
	    log_severity_t severity, unsigned uFlags, 
	    const char *fmt, ...)
{
    UNUSED(uFlags);

    if(severity <= *(log_severity_t*)a){
	va_list ap;
	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
	printf("\n");
    }
}

static void CAPI_EXTC
set_log_level(void *a,
	      log_severity_t level, unsigned uFlags)
{
    UNUSED(uFlags);
    *(log_severity_t*)a = level;
}

static log_severity_t log_level = CAPI_INFO;

#ifdef __cplusplus
extern "C" {
#endif

    static inline DWORD CPCAPI
	CPC2CryptAcquireContext(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [out] */ HCRYPTPROV *phProv,
	/* [string][in] */ CHAR *pszContainer,
	/* [in] */ DWORD dwFlags,
	/* [in] */ PVTABLEPROVSTRUC pVTable)
    {
	UNUSED(hCSP);
	return CryptAcquireContextA(phProv, pszContainer, pVTable->pszProvName, pVTable->dwProvType, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptReleaseContext(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP);
	return CryptReleaseContext(hProv, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptGetProvParam(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ DWORD dwParam,
	/* [size_is][out] */ BYTE *pbData,
	/* [out][in] */ DWORD *pdwDataLen,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP);
	return CryptGetProvParam(hProv, dwParam, pbData, pdwDataLen, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptSetProvParam(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ DWORD dwParam,
	/* [size_is][in] */ BYTE *pbData,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP);
	return CryptSetProvParam(hProv, dwParam, pbData, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptGenKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ ALG_ID AlgId,
	/* [in] */ DWORD dwFlags,
	/* [out] */ HCRYPTKEY *phKey)
    {
	UNUSED(hCSP);
	return CryptGenKey(hProv, AlgId, dwFlags, phKey)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptDestroyKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTKEY hKey)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptDestroyKey(hKey)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptCreateHash(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ ALG_ID AlgId,
	/* [in] */ HCRYPTKEY hKey,
	/* [in] */ DWORD dwFlags,
	/* [out] */ HCRYPTHASH *phHash)
    {
	UNUSED(hCSP);
	return CryptCreateHash(hProv, AlgId, hKey, dwFlags, phHash)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptDestroyHash(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptDestroyHash(hHash)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptEncrypt(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTKEY hKey,
	/* [in] */ HCRYPTHASH hHash,
	/* [in] */ BOOL Final,
	/* [in] */ DWORD dwFlags,
	/* [size_is][out][in] */ BYTE *pbData,
	/* [out][in] */ DWORD *pdwDataLen,
	/* [in] */ DWORD dwBufLen)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptEncrypt(hKey, hHash, Final, dwFlags, pbData, pdwDataLen, dwBufLen)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptDecrypt(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTKEY hKey,
	/* [in] */ HCRYPTHASH hHash,
	/* [in] */ BOOL Final,
	/* [in] */ DWORD dwFlags,
	/* [full][size_is][out][in] */ BYTE *pbData,
	/* [out][in] */ DWORD *pdwDataLen)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptDecrypt(hKey, hHash, Final, dwFlags, pbData, pdwDataLen)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptDeriveKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ ALG_ID AlgId,
	/* [in] */ HCRYPTHASH hBaseData,
	/* [in] */ DWORD dwFlags,
	/* [out] */ HCRYPTKEY *phKey)
    {
	UNUSED(hCSP);
	return CryptDeriveKey(hProv, AlgId, hBaseData, dwFlags, phKey)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptDuplicateKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTKEY hKey,
	/* [full][in] */ DWORD *pdwReserved,
	/* [in] */ DWORD dwFlags,
	/* [out] */ HCRYPTKEY *phKey)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptDuplicateKey(hKey, pdwReserved, dwFlags, phKey)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptDuplicateHash(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash,
	/* [full][in] */ DWORD *pdwReserved,
	/* [in] */ DWORD dwFlags,
	/* [out] */ HCRYPTHASH *phHash)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptDuplicateHash(hHash, pdwReserved, dwFlags, phHash)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptExportKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTKEY hKey,
	/* [in] */ HCRYPTKEY hExpKey,
	/* [in] */ DWORD dwBlobType,
	/* [in] */ DWORD dwFlags,
	/* [full][size_is][out][in] */ BYTE *pbData,
	/* [out][in] */ DWORD *pdwDataLen)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptExportKey(hKey, hExpKey, dwBlobType, dwFlags, pbData, pdwDataLen)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptGenRandom(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ DWORD dwLen,
	/* [size_is][out][in] */ BYTE *pbBuffer)
    {
	UNUSED(hCSP);
	return CryptGenRandom(hProv, dwLen, pbBuffer)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptGetHashParam(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash,
	/* [in] */ DWORD dwParam,
	/* [full][size_is][out][in] */ BYTE *pbData,
	/* [out][in] */ DWORD *pdwDataLen,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptGetHashParam(hHash, dwParam, pbData, pdwDataLen, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptGetKeyParam(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTKEY hKey,
	/* [in] */ DWORD dwParam,
	/* [full][size_is][out][in] */ BYTE *pbData,
	/* [out][in] */ DWORD *pdwDataLen,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptGetKeyParam(hKey, dwParam, pbData, pdwDataLen, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptGetUserKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ DWORD dwKeySpec,
	/* [out] */ HCRYPTKEY *phUserKey)
    {
	UNUSED(hCSP);
	return CryptGetUserKey(hProv, dwKeySpec, phUserKey)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptHashData(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash,
	/* [full][size_is][in] */ CONST BYTE *pbData,
	/* [in] */ DWORD dwDataLen,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptHashData(hHash, pbData, dwDataLen, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptHashSessionKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash,
	/* [in] */ HCRYPTKEY hKey,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptHashSessionKey(hHash, hKey, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptImportKey(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [full][size_is][in] */ CONST BYTE *pbData,
	/* [in] */ DWORD dwDataLen,
	/* [in] */ HCRYPTKEY hImpKey,
	/* [in] */ DWORD dwFlags,
	/* [out] */ HCRYPTKEY *phKey)
    {
	UNUSED(hCSP);
	return CryptImportKey(hProv, pbData, dwDataLen, hImpKey, dwFlags, phKey)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptSetHashParam(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash,
	/* [in] */ DWORD dwParam,
	/* [size_is][in] */ BYTE *pbData,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptSetHashParam(hHash, dwParam, pbData, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptSetKeyParam(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTKEY hKey,
	/* [in] */ DWORD dwParam,
	/* [size_is][in] */ BYTE *pbData,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP); UNUSED(hProv);
	return CryptSetKeyParam(hKey, dwParam, pbData, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptSignHash(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash,
	/* [in] */ DWORD dwKeySpec,
	/* [string][full][in] */ LPCWSTR sDescription,
	/* [in] */ DWORD dwFlags,
	/* [size_is][out][in] */ BYTE *pbSignature,
	/* [out][in] */ DWORD *pdwSigLen)
    {
	UNUSED(hCSP); UNUSED(hProv); UNUSED(sDescription);
	return CryptSignHash(hHash, dwKeySpec, NULL, dwFlags, pbSignature, pdwSigLen)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptVerifySignature(
	/* [in] */ HCRYPTMODULE hCSP,
	/* [in] */ HCRYPTPROV hProv,
	/* [in] */ HCRYPTHASH hHash,
	/* [size_is][in] */ CONST BYTE *pbSignature,
	/* [in] */ DWORD dwSigLen,
	/* [in] */ HCRYPTKEY hPubKey,
	/* [string][full][in] */ LPCWSTR sDescription,
	/* [in] */ DWORD dwFlags)
    {
	UNUSED(hCSP); UNUSED(hProv); UNUSED(sDescription);
	return CryptVerifySignature(hHash, pbSignature, dwSigLen, hPubKey, NULL, dwFlags)?0:GetLastError();
    }

    static inline DWORD CPCAPI
	CPC2CryptDestroyProvider(
	/* [in] */ HCRYPTMODULE hCSP)
    {
	free(hCSP);

	return 0;
    }

    static inline DWORD WINAPI
	CPC2CryptCreateProvider(
	HCRYPTMODULE * phCSP,	/* [out] */
	LPCPC_CONFIG pConfig)
    {
	UNUSED(pConfig);

	*phCSP=(HCRYPTMODULE)malloc(sizeof(CPC_FUNCTION_TABLE));
	if(!*phCSP) return (DWORD)NTE_NO_MEMORY;
	(*phCSP)->AcquireContext=CPC2CryptAcquireContext;
	(*phCSP)->ReleaseContext=CPC2CryptReleaseContext;
	(*phCSP)->GetProvParam=CPC2CryptGetProvParam;
	(*phCSP)->SetProvParam=CPC2CryptSetProvParam;
	(*phCSP)->GenKey=CPC2CryptGenKey;
	(*phCSP)->DestroyKey=CPC2CryptDestroyKey;
	(*phCSP)->CreateHash=CPC2CryptCreateHash;
	(*phCSP)->DestroyHash=CPC2CryptDestroyHash;
	(*phCSP)->Encrypt=CPC2CryptEncrypt;
	(*phCSP)->Decrypt=CPC2CryptDecrypt;
	(*phCSP)->DeriveKey=CPC2CryptDeriveKey;
	(*phCSP)->DuplicateKey=CPC2CryptDuplicateKey;
	(*phCSP)->DuplicateHash=CPC2CryptDuplicateHash;
	(*phCSP)->ExportKey=CPC2CryptExportKey;
	(*phCSP)->GenRandom=CPC2CryptGenRandom;
	(*phCSP)->GetHashParam=CPC2CryptGetHashParam;
	(*phCSP)->GetKeyParam=CPC2CryptGetKeyParam;
	(*phCSP)->GetUserKey=CPC2CryptGetUserKey;
	(*phCSP)->HashData=CPC2CryptHashData;
	(*phCSP)->HashSessionKey=CPC2CryptHashSessionKey;
	(*phCSP)->ImportKey=CPC2CryptImportKey;
	(*phCSP)->SetHashParam=CPC2CryptSetHashParam;
	(*phCSP)->SetKeyParam=CPC2CryptSetKeyParam;
	(*phCSP)->SignHash=CPC2CryptSignHash;
	(*phCSP)->VerifySignature=CPC2CryptVerifySignature;
	(*phCSP)->DestroyProvider=CPC2CryptDestroyProvider;

	return 0;
    }

#ifdef __cplusplus
}
#endif

HCRYPTMODULE GetNewModule_Crypt();
HCRYPTMODULE GetNewModule_Crypt()
{
    HCRYPTMODULE h;
    CPC2CryptCreateProvider( &h, 0 );
    return h;
}

void ReleaseModule_Crypt( HCRYPTMODULE h );
void ReleaseModule_Crypt( HCRYPTMODULE h )
{
    CPC2CryptDestroyProvider( h );
}

HCRYPTMODULE hModuleIke = 0;
bool GetNewModule( HCRYPTMODULE * h, bool bVerbose, const CPC_FAST_CODE *pcfcCfg );
CPC_CONFIG * GetCPCConfig();

ike_gost_handle
init_ike_module(unsigned NumSessions)
{
    unsigned rc = CAPI_INTERNAL_ERROR;
    int line;

    if( !hModuleIke )
    {
#ifndef TEST_CONFORMITY
	GetNewModule( &hModuleIke, 0, 0 );
#else
	hModuleIke = GetNewModule_Crypt();//GetNewModule( &hModuleIke, true, 0 );
#endif
    }

    ike_gost_out ike_out_init_data;
    ike_gost_in ike_in_init_data = {
	API_IPSEC_GOST_MAJOR, API_IPSEC_GOST_MINOR,
	NumSessions, // 0 =   (  )
	&log_level, logger_func, set_log_level,
	0,
	"123",
	hModuleIke,
	GetCPCConfig(),
	{0, 0, 0, 0, 0}
    };

    ike_gost_handle h = 0;

    if(CAPI_NOERROR != (rc = cpike_init_gost(h, &ike_in_init_data, 0, &ike_out_init_data))) {
	line = __LINE__;
	goto err;
    }
    if(NULL == (h = (ike_gost_handle)calloc(ike_out_init_data.requiredMem, 1))) {
	rc = CAPI_INTERNAL_ERROR;
	line = __LINE__;
	goto err;
    }
    ike_in_init_data.allocatedMem = ike_out_init_data.requiredMem;
    if(CAPI_NOERROR != (rc = cpike_init_gost(h, &ike_in_init_data, 0, &ike_out_init_data))) {
	line = __LINE__;
	goto err;
    }
    return h;

err:
    printf("%s: fail at %d, rc=0x%x\n", __FUNCTION__, line, rc);
    if(h) {
	free(h);
	h = 0;
    }
    return NULL;
}
