/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2008-2013
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 *
 * This is proprietary information of
 * Crypto-Pro company.
 *
 * Any part of this file can not be copied, 
 * corrected, translated into other languages,
 * localized or modified by any means,
 * compiled, transferred over a network from or to
 * any computer system without preliminary
 * agreement with Crypto-Pro company
 */

/*!
 * \version $Revision: 238239 $
 * \date $Date:: 2022-02-08 15:40:13 +0300#$
 * \author $Author: dim $
 *
 * \brief     vblob.
 *
 */

#ifndef _VBLOB_H_
#define _VBLOB_H_

#ifdef __cplusplus
extern "C" {
#else
# ifdef DT_HASH
#  undef DT_HASH
# endif
#endif
/* ID   */
/**
 * \ingroup supportIKE
 * \brief   vblob
 *
 * \xmlonly <locfile><header>vblob.h</header><ulib>libike_gost.so</ulib></locfile>\endxmlonly
 *
 * - DT_SITEID --    (Site).  .   .   .
 * - DT_PSK -- PreShared Key.  .  .
 * - DT_NETID --  .  .   .   .
 * - DT_SA -- SA.   .   .
 * - DT_CKY -- CKY.   4 .   .
 * - DT_M_ID -- M-ID.    4  256 .   .
 * - DT_KEY -- PUBLICKEYBLOB. 100 .  .
 * - DT_NONCE -- Nonce.        .
 *   ( ""  )     .
 * - DT_SIG_IR --  .        .
 *   ( ""  )     .
 * - DT_HASH_IR, DT_HASH --     1 IKE.
 *        .
 *   ( ""  )     .
 * - DT_P1_DATA -     1 IKE.  .
 * - DT_SPI_DATA -     SPI-  ESP.  .
 * - DT_EXTDATA --  .    .   .
 *
 *  :
 *    vblob   .
*/
typedef enum {
    DT_SITEID,
    DT_PSK,
    DT_NETID,
    DT_SA,
    DT_CKY,
    DT_M_ID,
    DT_KEY,
    DT_NONCE,
    DT_SIG_IR,
    DT_HASH_IR,
    DT_HASH,
    DT_P1_DATA,
    DT_SPI_DATA,
    DT_EXTDATA	/*    . ,   ID */
#if defined TEST_CONFORMITY
    ,
    DT_BYTE,
    DT_STRING,
    DT_DWORD,
    DT_QWORD,
    DT_time_t,
    DT_IKEPACKET,
    DT_ESPPACKET,
    DT_AHPACKET,
    DT_PUBLICBLOB,
    DT_SIGN
#endif	/* TEST_CONFORMITY */
#if defined IPSEC_UNIT_TEST
    ,
    DT_NONCE_FIXED,
    DT_KEY_FIXED,
    DT_M_ID_NONCE_FIXED
#endif
} DATA_TYPE;

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus

class vblob;

//#if defined VBLOB_INTERNAL
class vblob {
public:
    bool is_valid() const;   /* internally consistent. if false then any request for vblob's operations will FAIL */
    DATA_TYPE dtype() const; /* object type as enum value */
    const char * ref() const; /* read-only data ref, 0 if !is_valid() */
    unsigned size() const;   /* data_size, 0 if no data or !is_valid() */

    void vinit( CPC_CONFIG * _config, DATA_TYPE dp, const char *data, unsigned len); /* alloc memory, copy data */
    void clear( vblob ** v );

    bool has_fixed_size() const;
    bool is_valid_datyp() const;
    unsigned datalen( bool is_512 = false ) const;

    CPC_CONFIG * config;
    DATA_TYPE datyp;
    char * p;
    unsigned sz;
    bool deadborn; /* incorrect and cant be made correct.
		      we don't raise exceptions so use flag.
		      can be set in CTOR only
		   */
private:
    vblob();
public:		// TODO: defines a private destructor and has no friends
    ~vblob();
};
//#endif VBLOB_INTERNAL
#else /*__cplusplus */
    /* fake */
    struct vblob_st;
    typedef struct vblob_st vblob;
#endif
#ifdef __cplusplus
extern "C" {
#endif
#if !defined(_M_ARM64) && !defined( _M_ARM64EC )    //conflicts with __n64 vcreate(unsigned __int64 src) from arm64_neon.h
vblob* vcreate(CPC_CONFIG * config,DATA_TYPE dp, char *d, unsigned l);
#endif /*_M_ARM64*/
void vdelete(vblob ** v);
int vis_valid(vblob * v);
DATA_TYPE vdtype(vblob * v);
const char * vref(vblob * v);
unsigned vsize(vblob * v);
#ifdef __cplusplus
}
#endif

#endif /* _VBLOB_H_ */
