/*
 * Copyright(C) 2010-2012
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */
/*!
 * \version $Revision: 190356 $
 * \date $Date:: 2019-03-13 20:41:17 +0300#$
 * \author $Author: sempav $
 *
 * \brief
 *
 */

#ifndef _TYPEDEFS_SADB_H_
#define _TYPEDEFS_SADB_H_

/*     CPC/CSP, ..
 * typedefs_sadb.h    wincspc.h
 *
 *  SIZEOF_VOID_P  ,   
 * . 
 * TODO:  uintptr_t ,  .   CSP
 *   ULONG_PTR  UINT_PTR,    
 *   uintptr_t.
 */
#if !defined _WINCSPC_H_INCLUDED
typedef struct CPC_CONFIG_ CPC_CONFIG, *LPCPC_CONFIG;
typedef struct CPC_FUNCTION_TABLE_ *HCRYPTMODULE;
#endif	/* !_WINCSPC_H_INCLUDED */

#if !defined __WINCRYPT_H__
#ifndef SIZEOF_VOID_P 
    typedef ULONG_PTR HCRYPTPROV;
    typedef ULONG_PTR HCRYPTKEY;
    typedef ULONG_PTR HCRYPTHASH;
#elif SIZEOF_VOID_P == 4
    typedef unsigned long HCRYPTPROV;
    typedef unsigned long HCRYPTKEY;
    typedef unsigned long HCRYPTHASH;
#elif SIZEOF_VOID_P == 8
    typedef unsigned long long HCRYPTPROV;
    typedef unsigned long long HCRYPTKEY;
    typedef unsigned long long HCRYPTHASH;
#endif
#endif	/* !__WINCRYPT_H__ */

/*!
 * \ingroup sadbData
 * \struct privkey
 * \brief   /. 
 *
 */
typedef struct privkey {
    HCRYPTMODULE hModule;
        /*!< \brief   " CSP".
         */
    HCRYPTPROV hProv;
        /*!< \brief    .
         */
    HCRYPTKEY hKey;
        /*!< \brief   .
         */
} PRIVKEY;

#ifndef EXPORT_IMIT_SIZE
#define EXPORT_IMIT_SIZE 4
#endif

#define MAX_IV_LEN 8
#define MAX_HASH_LEN 64
#define MAX_SIG_LEN 128
#define MAX_PUBLICKEYBLOB_LEN 175 // 167 (0xA7) + 8
#define MAX_PRIVATEKEYBLOB_LEN 154 // 114 (0x72) + 32 + 8
#define MAX_SIMPLEBLOB_LEN 103 // 71 + 32
#define KEYLEN_256 32
#define KEYLEN_512 64

typedef uint8_t CPSADB_UKM_T[MAX_IV_LEN];
typedef uint8_t CPSADB_WKEY_T[KEYLEN_256];
typedef uint8_t CPSADB_WKEY_512_T[KEYLEN_512];
typedef uint8_t CPSADB_IMIT_T[EXPORT_IMIT_SIZE];
typedef uint8_t CPSADB_HASH_T[MAX_HASH_LEN];

/*!
 * \ingroup sadbData
 * \struct pubkey
 * \brief   /. 
 *
 */
#if !defined SOLARIS && !defined AIX	// TODO:    push
    #pragma pack(push,4)
#else
    #pragma pack(4)
#endif
typedef struct {
    long long born_time;
        /*!< \brief    .
         */
    CPIPSEC_LDURATION_T ttlutc;
        /*!< \brief    .
         */
    DWORD dwPubKeyLen;
	/*!< \brief    .
         */
    BYTE bPubKey[MAX_PUBLICKEYBLOB_LEN];
	/*!< \brief .    .
         */
} PUBKEY_2012;
#if !defined SOLARIS && !defined AIX
    #pragma pack(pop)
#else
    #pragma pack()
#endif

/*!
 * \ingroup sadbData
 * \struct CPSADB_KEYWRAP
 * \brief   . 
 *
 */
typedef struct CPSADB_KEYWRAP {
    CPSADB_UKM_T cpsadb_ukm;
    /*!< \brief    . */
    CPSADB_WKEY_T cpsadb_wkey;
    /*!< \brief   . */
    CPSADB_IMIT_T cpsadb_imit;
    /*!< \brief    . */
} CPSADB_KEYWRAP_T;

/*!
 * \ingroup sadbData
 * \struct CPSADB_KEYWRAP_512
 * \brief    512 . 
 *
 */
typedef struct CPSADB_KEYWRAP_512 {
    CPSADB_UKM_T cpsadb_ukm;
    /*!< \brief    . */
    CPSADB_WKEY_512_T cpsadb_wkey;
    /*!< \brief   . */
    CPSADB_IMIT_T cpsadb_imit;
    /*!< \brief    . */
} CPSADB_KEYWRAP_512_T;

/*!
 * \ingroup sadbData
 * \struct CPSADB_KEYWRAP_UNI
 * \brief    512 . 
 *
 */
typedef struct CPSADB_KEYWRAP_UNI {
    uint8_t sadb_keywrap_is_512; 
    /*!< \brief     (256  512 ). */
    union
    {
	CPSADB_KEYWRAP_T sadb_kw_256;
	/*!< \brief   256 . */
	CPSADB_KEYWRAP_512_T sadb_kw_512;
	/*!< \brief   512 . */
    }kw;
    /*!< \brief   . */
} CPSADB_KEYWRAP_UNI_T;

/*     ipsec/doc/typedefs_sadb.dtx */
/*     */
typedef struct sadbIPsec_SA {
    struct sadb_ipsec_param {
	uint16_t sadb_ip_ver_spec; //      Vendor ID
	uint8_t sadb_ip_spi[4];
	uint8_t sadb_ip_dir;
	uint8_t sadb_ip_satype;  // CPIPSEC_PROTO_IPSEC_ESP, CPIPSEC_PROTO_IPSEC_AH  SADB_SATYPE_AH/SADB_SATYPE_ESP
	uint8_t sadb_ip_encrypt; //     (CPESP_TRANSFORM_ID_T)
				 //  CPIPSEC_PROTO_IPSEC_AH     
				 // sadb_ip_encrypt == CPESP_NULL
				 //
				 // TODO: uint8_t sadb_ip_ah_transform;
	uint16_t sadb_ip_auth;   //      (CPAH_TRANSFORM_ID_T)
				 //  CPIPSEC_PROTO_IPSEC_AH - 2..255
				 //  CPIPSEC_PROTO_IPSEC_ESP - 1..65535
				 //  ,   - union   uint8_t  uint16_t
				 //    sadb_ip_encrypt != CPESP_NULL,   
				 //     CPESP_MAC_NULL
	uint8_t sadb_ip_replay;  //  ,   128
	uint32_t sadb_ip_flags;	 //  ECN ( CPIPSEC_AT_Ext_Serial_Number, CPIPSEC_ATP_Check_SN)
	uint8_t sadb_ip_ivlen;   //  SPIcookie (0-4)  IV ( ? )
	uint8_t sadb_ip_padmod;  //  
	uint8_t sadb_ip_icvlen;  //  ICV --- ???   ???
	uint8_t sadb_ip_hashlen; //  HASH ( 1-4)
	uint8_t sadb_ip_hmaclen; //  HMAC	  (8-32)  
    } sap;

    //   sadb_key_data_ipsec_gost 
    //        
    struct sadb_key_data_ipsec_gost {
	CPSADB_UKM_T sadb_kdgc_ukm;
	struct sadb_kdg_content_ipsec {
	    uint32_t sadb_kdgc_AlgId;
	    uint32_t sadb_kdgc_Magic;
	    CPSADB_KEYWRAP_T sadb_kdgc_Kr_e;
	    CPSADB_KEYWRAP_T sadb_kdgc_Kr_i;
	    uint8_t sadb_kdgc_spicookie[4];
	    uint16_t sadb_kdgc_sbox; /* CPESP_SBOX_T */
	    CPIPSEC_MAX_AUTH_ERR_T sadb_kdgc_max_auth;
	    CPESP_MAX_PKTLEN_T sadb_kdgc_maxmsg;
	    CPIPSEC_LDURATION_T sadb_kdgc_ttlkb;
	    CPIPSEC_LDURATION_T sadb_kdgc_ttlutc;
	} tbh;
	CPSADB_IMIT_T hmac;   // substr(0..3, HMAC(XCH_SADB_vko, tbh))
    } kd;
} SADBIPSECSA;

/*     ipsec/doc/typedefs_sadb.dtx */
typedef struct sadbIKE_SA {
    //   sadb_ike_param 
    //  "host" ,   RFC 2367
    struct sadb_ike_param {
	uint16_t sadb_ikep_ver_spec;	//      Vendor ID
	uint16_t sadb_ikep_auth;	// CPIKE_AUTH_GOST_PSK, CPIKE_AUTH_GOST_SIGNATURE
	uint16_t sadb_ikep_encrypt;	// CPIKE_ENC_A/B/C/D
	uint16_t sadb_ikep_hash;	// CPIKE_HASH_A
	uint8_t sadb_ikep_ivlen;	//  InitVector
	uint8_t sadb_ikep_padmod;	//  
	uint8_t sadb_ikep_icvlen;	//  ICV
	uint8_t sadb_ikep_kelen;	//  KE
	uint8_t sadb_ikep_hashlen;      //  HASH
	uint8_t sadb_ikep_cfgmode_status; // CFGMODE final status
    } sap;

    //   sadb_key_data_ike_gost 
    //        
    struct sadb_key_data_ike_gost {
	CPSADB_UKM_T sadb_kdgc_ukm;
	struct sadb_kdg_ike_content {
	    uint32_t sadb_kdgc_AlgId;
	    uint32_t sadb_kdgc_Magic;
	    CPSADB_KEYWRAP_UNI_T sadb_kdgc_SID_d;
	    CPSADB_KEYWRAP_UNI_T sadb_kdgc_SID_a;
	    CPSADB_KEYWRAP_UNI_T sadb_kdgc_SID_e;
	    uint16_t sadb_kdgc_sbox; /* CPIKE_ENC_T */
	    uint8_t sadb_kdgc_pfs; /* uint8_t   PFS CPIKE_PFSC_T */
	    CPESP_MAX_PKTLEN_T sadb_kdgc_maxmsg;
	    CPIPSEC_LDURATION_T sadb_kdgc_ttlkb;
	    CPIPSEC_LDURATION_T sadb_kdgc_ttlutc;
	    CPSADB_HASH_T sadb_kdgc_AUTH_I;
	    CPSADB_HASH_T sadb_kdgc_AUTH_R;
	    CPSADB_IMIT_T sadb_kdgc_Last_ICV;  // (   8 ??? )
	    uint32_t sadb_kdgc_gostcookie; // GOST_cookie retro for R65 ver_spec
	    uint32_t sadb_kdgc_counter_bytes; // IPSEC-471 counter_bytes through all
	} tbh;
	CPSADB_IMIT_T hmac;   // substr(0..3, HMAC(XCH_SADB_vko, tbh))
    } kd;
} SADBIKESA;

#if !defined SOLARIS && !defined AIX	// TODO:    push
    #pragma pack(push,1)
#else
    #pragma pack(1)
#endif

typedef struct sadbPUBLICKEYBLOB{
    struct sadb_key_data_sadb_gost{
	uint32_t ttl;
	uint32_t bloblen_max;
	uint32_t bloblen;
	uint8_t blob[MAX_PUBLICKEYBLOB_LEN];
	uint32_t hash_alg;
    } tbh;
    CPSADB_IMIT_T hash;
} SADB_PUBLICKEYBLOB;

#if !defined SOLARIS && !defined AIX
    #pragma pack(pop)
#else
    #pragma pack()
#endif

#endif /* _TYPEDEFS_SADB_H_ */
