/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2007-2014
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 *
 * This is proprietary information of
 * Crypto-Pro company.
 *
 * Any part of this file can not be copied, 
 * corrected, translated into other languages,
 * localized or modified by any means,
 * compiled, transferred over a network from or to
 * any computer system without preliminary
 * agreement with Crypto-Pro company
 */

/*
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 * \brief    IPsec (ISAKMP), CP-ESP-GOST
 *
 *   [DOI]   [draft.CPESP]  
 *  [ISAKMP]   .
 *
 * :
 *   [Magic-Numbers]  "Magic Numbers" for ISAKMP Protocol
 *                    <http://www.iana.org/assignments/isakmp-registry>
 *   [ISAKMP]         Internet Security Association and Key Management 
 *                    Protocol (ISAKMP), RFC 2408
 *                    <http://tools.ietf.org/html/rfc2408#section-3.5>
 *   [DOI]            The Internet IP Security Domain of Interpretation 
 *                    for ISAKMP, RFC 2407
 *                    <http://tools.ietf.org/html/rfc2407#section-4.4.3>
 *   [ESN]            Extended Sequence Number (ESN) Addendum to IPsec 
 *                    Domain of Interpretation (DOI) for Internet 
 *                    Security Association and Key Management Protocol 
 *                    (ISAKMP), RFC 4304
 *                    <http://tools.ietf.org/html/rfc4304#section-2>
 *   [rus.CPAH]            
 *                      () 26, "  
 *                    .  .  
 *                         34.11-94
 *                         
 *                    IPsec AH  ESP", 2013.
 *   [rus.CPESP]           
 *                      () 26, "  
 *                    .  .  
 *                        28147-89  
 *                      IPsec ESP", 2013.
 *   [draft.CPESP]    Using GOST 28147-89 with IPsec Encapsulating 
 *                    Security Payload (ESP), December 2013, work in progress
 *                    <http://tools.ietf.org/html/draft-fedchenko-ipsecme-cpesp-gost>
 *   [rus.CPIKE]           
 *                      () 26, "  
 *                    .  .  
 *                        28147-89, 
 *                      34.11-94    34.10-2001   
 *                       IKE  ISAKMP", 2013.
 *   [rus.ESP-SBOX-TC26]
 *                    26, , (), "  
 *                    .  .  
 *                        28147-89  
 *                      IPsec ESP",  2014, 
 *                       .
 *                    <rus-popov-esp-sbox-00-rb>
 *   [CPALGS]         Additional Cryptographic Algorithms for Use 
 *                    with GOST 28147-89, GOST R 34.10-94, 
 *                    GOST R 34.10-2001, and GOST R 34.11-94 
 *                    Algorithms
 *                    <http://tools.ietf.org/html/rfc4357>
 *
 */

#ifndef _CP_IPSEC_GOST_H_
#define _CP_IPSEC_GOST_H_

/*
 * ESP GOST Private attribute and class values
 * SHOULD announce by Vendor ID 
 */
#define CPESP_Ver_Major CPIKE_Ver_Major
#define CPESP_Ver_Minor CPIKE_Ver_Minor
#define CPESP_Base_VID	CPIKE_Base_VID

static const char CPESP_Vendor_ID_Current[] = {
    CPESP_Base_VID,
    CPESP_Ver_Major,
    CPESP_Ver_Minor
};

/*
 * Version specific ID
 */
typedef CPIKE_VER_SPEC_T CPESP_VER_SPEC_T;

/*
 * IPSEC Security Protocol Identifier 
 */
    // [DOI]
typedef unsigned char CPIPSEC_PROTOCOL_ID_T;  // 1 octet [ISAKMP]

static const 
unsigned char CPIPSEC_PROTO_RESERVED = 0;
static const 
unsigned char CPIPSEC_PROTO_ISAKMP = 1;
static const 
unsigned char CPIPSEC_PROTO_IPSEC_AH = 2;
static const 
unsigned char CPIPSEC_PROTO_IPSEC_ESP = 3;
static const 
unsigned char CPIPSEC_PROTO_IPCOMP = 4;

/*
 * IPSEC ESP Transform ID 
 */
typedef enum CPESP_TRANSFORM_ID {
	// [DOI]
    CPESP_NULL         = 11,	  //    ESP   
	// [draft.CPESP]
    CPESP_GOST_4M_IMIT     = 253, // ESP_GOST-4M-IMIT
				  // change key internally. No extern
				  // REKEYing is needed. Used in FW-1/ESP
    CPESP_GOST_1K_IMIT     = 252, // ESP_GOST-1K-IMIT
				  // change key internally. No extern 
				  // REKEYing is needed. Primary used 
				  // for KB1/ESP

    // Pseudo transform ID for undefined
    CPESP_GOST_UNDEF  = 0
} CPESP_TRANSFORM_ID_T;

typedef enum CPAH_TRANSFORM_ID {
	// [draft.CPESP]
    CPESP_MAC_NULL     = 65411,	//  ESP   . 
				//  "", "" .
	// [draft.CPAH]
    CPAH_GOST_HMAC_4M  = 251,	// AH_GOST-HMAC-4M
				//  ESP   :
				// p2_SetParamFn(p2, CPIPSEC_AT_Authentication_Algorithm,
				//               CPESP_AUTH_GOST_HMAC_4M, 0, 0));
				// spiSerializeFn(p2, CPIPSEC_PROTO_IPSEC_ESP, spi, dir, CPESP_NULL)
				//  AH
				// spiSerializeFn(p2, CPIPSEC_PROTO_IPSEC_MAC, spi, dir, ...)
				// TODO:    ESP  AH 
				//       c ,  ESP "Authentication Algorithm"
				//            
    CPAH_GOST_HMAC_1K  = 250,	// AH_GOST-HMAC-1K
				//  AH . 
				// ESP   :
				// p2_SetParamFn(p2, CPIPSEC_AT_Authentication_Algorithm,
				//               CPESP_AUTH_GOST_HMAC_1K, 0, 0));
				// spiSerializeFn(p2, CPIPSEC_PROTO_IPSEC_ESP, spi, dir,
				//                CPESP_NULL)
				// TODO:    ESP  AH 
				//       c ,  ESP "Authentication Algorithm"
				//            
    // Pseudo transform ID for undefined
    CPESP_MAC_UNDEF  = 0
} CPAH_TRANSFORM_ID_T;

/*
 * Attribute Types 
 */
typedef enum CPIPSEC_AT {
	// [DOI] 
    CPIPSEC_AT_Life_Type = 1,// ID  (Attribute Class)
                             //       CPIPSEC_AT_Life_Duration.
                             //  API " IPsec"  ,
                             //   CPIPSEC_LIFET_KILOBYTES/CPIPSEC_LIFET_SECONDS
                             //    upClsType  p2_SetParamFn  p2_GetParamFn
    CPIPSEC_AT_Life_Duration = 2,
    CPIPSEC_AT_Group_Description = 3,
    CPIPSEC_AT_Authentication_Algorithm = 5,
	// [ESN]
    CPIPSEC_AT_Ext_Serial_Number = 11,
	// [draft.CPESP]
    CPIPSEC_AT_GOST_28147_SBOX = 32401,	//    28147-89
    CPIPSEC_AT_Max_Auth_Error = 32402,	// . -   
    CPIPSEC_AT_Max_Packet_Len = 32403,	// .  
	//     Vendor ID
    CPIPSEC_ATP_Get_Vendor_ID = 888880,
	//     SN
    CPIPSEC_ATP_Check_SN = 888881,
    CPIPSEC_AT_GOST_MACLEN = 888882
} CPIPSEC_AT_T;

/*
 * Life Type (Class Value)
 */
typedef enum CPIPSEC_LIFET {
	// [DOI]
    CPIPSEC_LIFET_SECONDS = 1,
    CPIPSEC_LIFET_KILOBYTES = 2
} CPIPSEC_LIFET_T;

/*
 * Life Duration (Class Value)
 */
    // [DOI]
    //   long long     .
typedef unsigned int CPIPSEC_LDURATION_T;

    // [DOI] If unspecified, the default value shall be assumed to be
    // 28800 seconds (8 hours).
static const 
CPIPSEC_LDURATION_T CPIPSEC_DFLT_SEC_LDURATION = 8*60*60;

    // [draft.CPESP]    SA ESP   24 
static const 
CPIPSEC_LDURATION_T CPIPSEC_MAX_SEC_LDURATION = 24*60*60;

    // [draft.CPESP]     ( 
    //  ) 
    // GOST-ESP 4M/1K  2^42  (2^32-1 ) 
static const 
CPIPSEC_LDURATION_T CPIPSEC_MAX_4M_KBS = (CPIPSEC_LDURATION_T)-1;
static const 
CPIPSEC_LDURATION_T CPIPSEC_MAX_1K_KBS = (CPIPSEC_LDURATION_T)-1;

/*
 * Group Description (Class Value)
 */
typedef enum CPIPSEC_GROUP {
	// [draft.CPIKE]
    CPIPSEC_GROUP_XchA = CPIKE_GROUP_XchA,
				// id-GostR3410-2001-CryptoPro-XchA-ParamSet
				// id-GostR3411-94-CryptoProParamSet
    CPIPSEC_GROUP_XchB = CPIKE_GROUP_XchB,
				// id-GostR3410-2001-CryptoPro-XchB-ParamSet
				// id-GostR3411-94-CryptoProParamSet
	//     PFS  QM
    CPESP_GROUPP_No_PFS = 888881
} CPIPSEC_GROUP_T;

/*
 * Authentication Algorithm
 */
typedef enum CPESP_AUTH_ALG {
	// [draft.CPIKE]
    CPESP_AUTH_GOST_HMAC_4M = CPAH_GOST_HMAC_4M,
    CPESP_AUTH_GOST_HMAC_1K = CPAH_GOST_HMAC_1K
} CPESP_AUTH_ALG_T;

/*
 * Extended (64-bit) Sequence Number
 */
typedef enum CPESP_ESN {
	// [ESN]
    CPESP_ESN_Enable = 1,
        //      ESN
    CPESP_ESNP_Disable = 77770
} CPESP_ESN_T;

/*
 *    28147-89
 */
typedef enum CPESP_SBOX {
	// [draft.CPESP]
    CPESP_SBOX_A = 65403,    // id-Gost28147-89-CryptoPro-A-ParamSet
    CPESP_SBOX_B = 65404,    // id-Gost28147-89-CryptoPro-B-ParamSet
    CPESP_SBOX_C = 65405,    // id-Gost28147-89-CryptoPro-C-ParamSet
    CPESP_SBOX_D = 65406,    // id-Gost28147-89-CryptoPro-D-ParamSet
    	// [draft.CPESPbis]
    CPESP_SBOX_TC26Z = 65407 // id-tc26-gost-28147-param-Z
} CPESP_SBOX_T;

/*
 * Max Auth Error
 */
    // [draft.CPESP]
typedef unsigned int CPIPSEC_MAX_AUTH_ERR_T;

    //       
    // ESP  4M, 1K  10^5;
static const 
CPIPSEC_MAX_AUTH_ERR_T CPIPSEC_4M_MAX_AUTH_ERR = (100*1000);
static const 
CPIPSEC_MAX_AUTH_ERR_T CPIPSEC_1K_MAX_AUTH_ERR = (10);	// .  KB1,   KC{1,2,3}
static const 
CPIPSEC_MAX_AUTH_ERR_T CPIPSEC_1K_KC_MAX_AUTH_ERR = (100*1000); // .  KC{1,2,3}

/*
 * Max Messages
 */
    // [draft.CPESP]    ESP
typedef unsigned int CPESP_MAX_PKTLEN_T;	//  

    //     GOST-IKE,
    // GOST-ESP 4M  64 ; GOST-ESP-1K  4 .
static const 
CPESP_MAX_PKTLEN_T CPESP_4M_MAX_PKTLEN = 64;	    // 64
static const 
CPESP_MAX_PKTLEN_T CPESP_1K_MAX_PKTLEN = 4*1024*1024; // 4

/*
 *    () Vendor ID
 */
typedef CPIKE_GET_VENDOR_ID_T CPESP_GET_VENDOR_ID_T;

/*
 *     SN
 */
typedef enum CPESP_CHKSN {
    CPESP_CHKSN_Enable = 0,
    //CPESP_CHKSN_Preliminary_Disable = 1,
    CPESP_CHKSN_Disable_All = 2
} CPESP_CHKSN_T;

typedef struct CPESP_LENPARAMS {
    unsigned IV_SIZE;
    unsigned PAD_MODULE;
    unsigned ICV_SIZE;
} CPESP_LENPARAMS_T;


#define ESP_PACKETIMITA		3
#define ESP_LENPARAMS		5
#define ESP_MULTIPACKET_MAX	6
#define ESP_MULTIPACKET_OPT_CSP 7
#define ESP_MULTIPACKET_OPT_KEY 8
#define ESP_SPICOOKIE		9

static const unsigned short GOST_NULL_INTEGRITY_ALGORITHM = CPESP_MAC_NULL;

#endif /* _CP_IPSEC_GOST_H_ */
