#!/bin/bash
# vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[]
#
# Copyright(C) 2000-2013  
#
#    , 
#    .
#
#        ,
# ,    ,
#     ,
# ,      
#     
#      .
#
#
set -e
KVER=${1:-`uname -r`}
eval `/opt/cprocsp/src/doxygen/setenv.sh`
for BUILDDIR in /lib/modules/$KVER/build /usr/src/linux-$KVER /usr/src/linux-headers-$KVER /usr/src/kernels/$KVER
do
    if test -d $BUILDDIR || test -h $BUILDDIR
    then
    	break
    fi
done
if ! test -d $BUILDDIR && ! test -h $BUILDDIR
then
    echo "Cannot find any suitable kernel headers"
    exit 1
fi


case $KVER in
5.*|6.*)
    ar x libcpcdrv.a
    sed 's/libcpcdrv\.a/cpc.o/' <Makefile.drvcsp_linux.dist >Makefile;;
*)
    cp Makefile.drvcsp_linux.dist Makefile;;
esac
# DEBUG="-DDEBUG"
 DEBUG=""
if grep -q "^CONFIG_MODVERSIONS[[:blank:]]*=[[:blank:]]*y" $BUILDDIR/.config
then
    check_symbols=1
else
    check_symbols=0
fi
case $KVER in
2.6.*) make $MAKE_VARS -C $BUILDDIR SUBDIRS=$PWD CFLAGS_MODULE="$DEBUG $PROC_TYPE -DUNIX -DLINUX -DCSP_LITE -DCSP_DRIVER -I/opt/cprocsp/include -I/opt/cprocsp/include/cpcsp -I/opt/cprocsp/include/interfaces -I/opt/cprocsp/include/reader -I/opt/cprocsp/src/drvcsp -DMODULE" modules;;
3.*)  make $MAKE_VARS -C $BUILDDIR M=$PWD CFLAGS_MODULE="$DEBUG $PROC_TYPE -DUNIX -DLINUX -DCSP_LITE -DCSP_DRIVER -I/opt/cprocsp/include -I/opt/cprocsp/include/cpcsp -I/opt/cprocsp/include/interfaces -I/opt/cprocsp/include/reader -I/opt/cprocsp/src/drvcsp -DMODULE";;
4.*)  make $MAKE_VARS -C $BUILDDIR M=$PWD CFLAGS_MODULE="$DEBUG $PROC_TYPE -DUNIX -DLINUX -DCSP_LITE -DCSP_DRIVER -I/opt/cprocsp/include -I/opt/cprocsp/include/cpcsp -I/opt/cprocsp/include/interfaces -I/opt/cprocsp/include/reader -I/opt/cprocsp/src/drvcsp -DMODULE"
      check_symbols=0;;
5.*|6.*) touch .cpc.o.cmd  
    make $MAKE_VARS -C $BUILDDIR M=$PWD CFLAGS_MODULE="$DEBUG $PROC_TYPE -DUNIX -DLINUX -DCSP_LITE -DCSP_DRIVER -I/opt/cprocsp/include -I/opt/cprocsp/include/cpcsp -I/opt/cprocsp/include/interfaces -I/opt/cprocsp/include/reader -I/opt/cprocsp/src/drvcsp -DMODULE" KBUILD_EXTRA_SYMBOLS=$MODVERSFILE
      check_symbols=0;;
*) echo Unsupported kernel: $KVER; exit 1;;
esac 
VERS_FILE=$MODVERSFILE
chmod +x gen_syms.sh check_syms.sh
./gen_syms.sh drvcsp.ko >drvcsp.syms
if test $check_symbols -eq 1
then
  if ! ./check_syms.sh drvcsp.syms $VERS_FILE CPCGetDefaultConfig CPCCreateProvider CPCInitMemoryLF
  then
      echo "Version info mismatch:"
      echo "$VERS_FILE:"
      cat $VERS_FILE
      echo "drvcsp.ko:"
      cat drvcsp.syms
      exit 1
  fi
fi

rm Makefile
