#!/bin/sh
# drv.sh (start|stop) [<mod_dir>]
# Starts and stops drvcsp - drvcsp LKM
# Starts and stops drtcsp - test LKM for drvcsp
#
# vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[]
#
# Copyright(C) 2000-2010  
#
#    , 
#    .
#
#        ,
# ,    ,
#     ,
# ,      
#     
#      .
#
#  ,    , 
#         
#   .
#
#  -   
#     .
#

#TODO: function?
sync
sleep 1

case `uname -s` in
Linux)
  case $1 in
  start)
    /sbin/modprobe drvcsp || exit 1
    [ "x$2" = "xdrvcsp" ] && exit 0 
    /sbin/modprobe drtcsp || exit 1
    major=`grep drtcsp /proc/devices |cut -d' ' -f1`
    i=0;
    while test $i -lt 80 
    do
      rm -f /dev/drtcsp$i
      test -n "$major" && mknod /dev/drtcsp$i c $major $i || exit 1
      i=`expr $i + 1`
    done;;
  stop)
    if [ "x$2" != "xdrvcsp" ]
    then
	/sbin/rmmod drtcsp
	i=0
	while test $i -lt 80 
	do 
	  rm -f /dev/drtcsp$i; 
	  i=`expr $i + 1`
	done
    fi	
    /sbin/rmmod drvcsp;;
  esac;;
SunOS)
  case $1 in
  start)
    add_drv drvcsp || exit 1
    [ "x$2" = "xdrvcsp" ] && exit 0 
    update_drv drvcsp || exit 1 #TODO:??

    instdir=/usr/kernel/drv	#TODO:?? function
    karch=`isainfo -k`
    case "$karch" in
    amd64|sparcv9)
      instmod="$instdir"/"$karch"
      ;;
    *)
      instmod="$instdir"
      ;;
    esac

    cp drtcsp "$instmod"/.
    cp drtcsp.conf "$instdir"/. #TODO:??

    add_drv -m '* 0666 bin bin' drtcsp || exit 1
    i=0
    while test $i -lt 80 
    do
      ln -sf /devices/pseudo/drtcsp\@$i\:drtcsp /dev/drtcsp$i || exit 1
      i=`expr $i + 1`
    done;;
  stop)
    if [ "x$2" != "xdrvcsp" ]
    then 
	rem_drv drtcsp

	instdir=/usr/kernel/drv	#TODO:?? function
	karch=`isainfo -k`
	case "$karch" in
	amd64|sparcv9)
	  instmod="$instdir"/"$karch"
	  ;;
	*)
	  instmod="$instdir"
	  ;;
	esac

	i=0
	while test $i -lt 80 
	do
	  rm -f /dev/drtcsp$i 
	  i=`expr $i + 1`
	done

	rm  "$instmod"/drtcsp
	#TODO:?? rm "$instdir"/drtcsp.conf
    fi	

    rem_drv drvcsp;;
  esac;;
FreeBSD)
  case $1 in
  start)
    /sbin/kldload drvcsp.ko || exit 1
    [ "x$2" = "xdrvcsp" ] && exit 0 
    /sbin/kldload drtcsp.ko || exit 1;;
  stop)

    if [ "x$2" != "xdrvcsp" ]
    then
	/sbin/kldunload drtcsp
    fi	
    /sbin/kldunload drvcsp;;
  esac;;
esac

#TODO: 
sync
sleep 1
