/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
/*
 * Copyright(C) 2004-2013  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 *
 *  ,    , 
 *         
 *   .
 *
 *  -   
 *     .
 */

#ifdef LINUX
#define _POSIX_C_SOURCE 200809
#define _XOPEN_SOURCE 700
#endif
#include <stdio.h>

#include <sys/types.h>
#include <sys/time.h>
#include <inttypes.h>
#include <string.h>
#include <sys/resource.h> /* For setrlimit only */
#include <stdlib.h>
#include <stdarg.h>
#include <pthread.h>
#include "stdafx.h"
#include "wincsp.h"
#include "wincspc.h"
#include "reader/dbtrace_initer.h"
#include "reality/cspmemSTDC.h"
#if defined(PROCESSOR_TYPE) && PROCESSOR_TYPE == PROC_TYPE_MIPS32
#define USE_STD_MM
#endif
#ifndef USE_STD_MM
#include "lfmm.h"
#include "lfmm_int.h"
#define MAXCONTEXTS 100
#endif
#ifndef CSP_LITE
# include "Crypt.h"
#endif
#ifdef USE_STD_MM
static DWORD CPCAPI
stdAllocMemory(LPCPC_MEMORY_ARENA pArena, SIZE_T dwSize, DWORD dwMemPoolId,
	       DWORD dwThreadId, LPVOID *pRes)
{
  void *ptr;
  UNUSED(pArena);
  UNUSED(dwThreadId);
  UNUSED(dwMemPoolId);

  ptr = malloc(dwSize);
  if(!ptr){
    return NTE_NO_MEMORY;
  } 
  memset (ptr, 0, dwSize);
  *pRes = ptr;
  return S_OK;
}

/*!
 * \ingroup MemoryManager
 * \brief  
 */
static DWORD CPCAPI
stdFreeMemory(LPCPC_MEMORY_ARENA pArena, VOID *pMem, DWORD dwMemPoolId)
{
  UNUSED(pArena);
  UNUSED(dwMemPoolId);
  free (pMem);
  return 0;
}

static void CPCAPI
stdValidateMemory(LPCPC_MEMORY_ARENA pArena)
{
    UNUSED(pArena);
}

static void CPCAPI
stdStatMemory (LPCPC_MEMORY_ARENA pArena, LPCPC_MEMORY_STATS pStats,
	       DWORD dwMemPoolId)
{
    UNUSED (pArena);
    UNUSED (pStats);
    UNUSED (dwMemPoolId);
}

static void CPCAPI
stdDoneMemory(LPCPC_MEMORY_ARENA pArena)
{
    UNUSED(pArena);
}

DWORD CPCAPI stdInitMemory(LPCPC_MEMORY_ARENA *pArena, LONG *PoolSizes, DWORD nPools)
{
  static CPC_MEMORY_ARENA Config;
  UNUSED(pArena);
  UNUSED(PoolSizes);
  UNUSED(nPools);
  memset (&Config, 0, sizeof (Config));
  Config.pValidateMemory = stdValidateMemory;
  Config.pDoneMemory = stdDoneMemory;
  Config.pAllocMemory = stdAllocMemory;
  Config.pFreeMemory = stdFreeMemory;
  Config.pStatMemory = stdStatMemory;
  *pArena = &Config;
  return S_OK;
}

#endif
HCRYPTMODULE uCSP=NULL;

const VTABLEPROVSTRUC VTABLE2001 = { 3, 0, 0, PROV_GOST_2001_DH,
    0, 0, 0 };
VTABLEPROVSTRUC CurVTable=VTABLE2001;

/*
 * !!!!!!??????? 
 * !    ntohs_ptr, ntohl_ptr
 * !!!!!!??????? 
 */
#include "platformstream.h"

#ifdef DEBUG
#define MODULE  "TEST_dcpexed"
#else
#define MODULE  "TEST_dcpexe"
#endif /* DEBUG */

#define MAX_SHIFT   (1)
#define STEP_SHIFT  (1)

/*
 *   dmntcs, 
 */
#define dev_info_t  void

#include "drtcsp_io.h"

/*
 *   drtcsp, 
 */
static int drtcsp_attach(int channel);
//int drtcsp_detach(void);
static int drtcsp_open(int channel);
static int drtcsp_close(int channel);
static int drtcsp_ioctl_DRTCSP_DRIVER_RNG(int channel,DRTCSP_DRIVER_KEY *ptmp);
static int drtcsp_ioctl_DRTCSP_SESSION_KEY(int channel,DRTCSP_DRIVER_KEY *ptmp);
static int drtcsp_ioctl_DRTCSP_SELFTEST(int channel,DRTCSP_DRIVER_KEY *ptmp);
static int drtcsp_read(int channel,BYTE *buf, size_t resid);
static int drtcsp_write(int channel,BYTE *buf, size_t resid);

static DRTCSP channels[MAX_MINORS];

#if 0
static unsigned char test_iv[8], test_data[8];

static int
test_encrypt_dat(HCRYPTMODULE csp, HCRYPTPROV prov, HCRYPTKEY key)
{
  DWORD dwcbData=8;

  if(csp->GetKeyParam(csp, prov, key, KP_IV, test_iv, &dwcbData, 0)) {
    printf("drtcsp: %d: test_encrypt_data SetKeyParam\n", __LINE__);
    return -1;
  }
  memset(test_data, 0, 8);
  if(csp->Encrypt(csp, prov, key, 0, TRUE, 0, test_data, &dwcbData, dwcbData)) {
    printf("drtcsp: %d: Encrypt\n", __LINE__);
    return -1;
  }

  return 0;
}

static int
test_decrypt_data(HCRYPTMODULE csp, HCRYPTPROV prov, HCRYPTKEY key)
{
  DWORD dwcbData=8;
  char buf[8]={0,0,0,0,0,0,0,0};

  if(csp->SetKeyParam(csp, prov, key, KP_IV, test_iv, 0)) {
    printf("drtcsp: %d: test_decrypt_data SetKeyParam\n", __LINE__);
    return __LINE__;
  }
  if(csp->Decrypt(csp, prov, key, 0, TRUE, 0, test_data, &dwcbData)) {
    printf("drtcsp: %d: test_decrypt_data Encrypt\n", __LINE__);
    return __LINE__;
  }
  if(memcmp(test_data, buf, 8)) {
    printf("drtcsp: %d: test_decrypt_data !data are different\n", __LINE__);
    return __LINE__;
  }

  return 0;
}
#endif

/*
 *   dmntcs, 
 */
static char    buf[1024 + MAX_SHIFT];
static int buf_size = sizeof(buf) - MAX_SHIFT;

static int
TEST_dmntcs_drtcsp(int channel, int data_shift)
{
  /* int drv; */
  HCRYPTPROV  hProv = 0;
  HCRYPTHASH  hDrvHash = 0;
  HCRYPTKEY   hDrvKey = 0;
  HCRYPTKEY   hSessionKey = 0;
  DRTCSP_DRIVER_KEY   tmp;
  // pbShiftedData   tmp.bData      .
  //     / tmp.bData.
  BYTE bShiftedDataHolder[sizeof(tmp.bData) + MAX_SHIFT];
  BYTE* pbShiftedData = bShiftedDataHolder + data_shift;
  DWORD   dwcbData;
  DWORD   dwAlgId;    /* what length ??? */
  int     retval;

  /*  -test /dev/drtcsp0 */
  if (drtcsp_attach(channel) < 0) {
    printf(MODULE "!test:attach\n");
    retval = __LINE__;
    goto err_ret;
  }
    
  /* drv = open("/dev/drtcsp0", O_RDWR) */
  if (drtcsp_open(channel) < 0) {
    printf(MODULE "!test:open(\"/dev/drtcsp0\", O_RDWR)\n");
    retval = __LINE__;
    goto err_ret;
  }

  if (uCSP->AcquireContext(uCSP, &hProv, NULL, CRYPT_VERIFYCONTEXT, &CurVTable)) {
    printf(MODULE "!test:%d: user AcquireContext\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  tmp.size = (uint16_t)sizeof(tmp);
  tmp.version = Version1_2;
  tmp.magic = Drtcsp_RN_Daemon_Magic;
  dwcbData = (uint8_t)sizeof(tmp.bData);

  if(uCSP->GetProvParam(uCSP, hProv, PP_RANDOM, pbShiftedData, &dwcbData, 0)) {
    printf(MODULE "!test:%d: user GetProvParam\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }
  tmp.cbData=(uint8_t)dwcbData;
  memcpy(tmp.bData, pbShiftedData, dwcbData);
    
  if(uCSP->CreateHash(uCSP, hProv, CALG_GR3411, 0, 0, &hDrvHash)) {
    printf(MODULE "!test:%d: user CreateHash\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  if(uCSP->HashData(uCSP, hProv, hDrvHash, (BYTE *)"DriverDaemon", (DWORD)sizeof("DriverDaemon"), 0)) {
    printf(MODULE "!test:%d: user HashData(...'DriverDaemon'\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  if(uCSP->HashData(uCSP, hProv, hDrvHash, pbShiftedData, dwcbData, 0)) {
    printf(MODULE "!test:%d: user HashData(...tmp.bData\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }


  /* ioctl(drv, DRTCSP_DRIVER_RNG, &tmp) */
  if (drtcsp_ioctl_DRTCSP_DRIVER_RNG(channel,&tmp) < 0) {
    printf(MODULE "!test:ioctl(drv, DRTCSP_DRIVER_RNG, &tmp)\n");
    retval = __LINE__;
    goto err_ret;
  }

  if (tmp.size != sizeof(tmp) ||
      tmp.version != Version1_2 ||
      tmp.magic != Drtcsp_RN_Driver_Magic) {
    printf(MODULE "!test:%d: Drtcsp_RN_Driver_Magic: corrupt\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  dwcbData = tmp.cbData;
  memcpy(pbShiftedData, tmp.bData, tmp.cbData);

  if(uCSP->HashData(uCSP, hProv, hDrvHash, pbShiftedData, dwcbData, 0)) {
    printf(MODULE "!test:%d: user HashData(...tmp.bData\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  if(uCSP->DeriveKey(uCSP, hProv, CALG_G28147, hDrvHash, 0, &hDrvKey)) {
    printf(MODULE "!test:%d: user DeriveKey\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

#if 0
  retval=test_decrypt_data(uCSP, hProv, hDrvKey);
  if(retval) goto err_ret;
#endif

  if(uCSP->DestroyHash(uCSP, hProv, hDrvHash)) {
    printf(MODULE "!test:%d: user DestroyHash\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }
  hDrvHash = 0;

  dwAlgId = CALG_SIMPLE_EXPORT;
  if(uCSP->SetKeyParam(uCSP, hProv, hDrvKey, KP_ALGID, (BYTE *)&dwAlgId, 0)) {
    printf(MODULE "!test:%d: user SetKeyParam(...hDrvKey\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  memset(&tmp, 0, sizeof(tmp));

  if(uCSP->GenKey(uCSP, hProv, CALG_G28147, CRYPT_EXPORTABLE, &hSessionKey)) {
    printf(MODULE "!test:%d: user GenKey(...&hSessionKey)\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  tmp.size = (uint16_t)sizeof(tmp);
  tmp.version = Version1_2;
  tmp.magic = Drtcsp_KE_Session_Magic;
  dwcbData = (uint8_t)sizeof(tmp.bData);
      
  if(uCSP->ExportKey(uCSP, hProv, hSessionKey, hDrvKey, SIMPLEBLOB, 0, pbShiftedData, &dwcbData)) {
    printf(MODULE "!test:%d: user ExportKey(...hSessionKey)\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  tmp.cbData = (uint8_t)dwcbData;
  memcpy(tmp.bData, pbShiftedData, dwcbData);
    
  if (drtcsp_ioctl_DRTCSP_SESSION_KEY(channel,&tmp) < 0) {
    printf(MODULE "!test:ioctl(drv, DRTCSP_DRIVER_RNG, &tmp)\n");
    retval = __LINE__;
    goto err_ret;
  }
#if 0
  retval=test_decrypt_data(uCSP, hProv, hSessionKey);
  if(retval) goto err_ret;
#endif

  if (tmp.size != sizeof(tmp) ||
      tmp.version != Version1_2 ||
      tmp.magic != Drtcsp_KE_OKSetSK_Magic) {
    printf(MODULE "!test:%d: Drtcsp_KE_OKSetSK_Magic: corrupt\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  memset(&tmp, 0, sizeof(tmp));

  {
    int bytes;
    if ((bytes=drtcsp_read(channel, (BYTE *)buf + data_shift, buf_size)) != buf_size) {
      printf(MODULE "!test:read(drv, buf, sizeof(buf)), bytes=%d, sizeof(buf)=%ld",bytes,(unsigned long)sizeof(buf));
      retval = __LINE__;
      goto err_ret;
    }
  }

  if (drtcsp_write(channel, (BYTE *)buf + data_shift, buf_size) != buf_size) {
    printf(MODULE "!test:write(drv, buf, sizeof(buf))");
    retval = __LINE__;
    goto err_ret;
  }

  memset(&buf, 0, sizeof(buf));

  tmp.size = (uint16_t)sizeof(tmp);
  tmp.version = Version1_2;
  tmp.magic = Drtcsp_ST_Daemon_Magic;
  tmp.cbData = (uint16_t)sizeof(tmp.bData);
    
  if (drtcsp_ioctl_DRTCSP_SELFTEST(channel,&tmp) < 0) {
    printf(MODULE "!test:ioctl(drv, DRTCSP_SELFTEST, &tmp)\n");
    retval = __LINE__;
    goto err_ret;
  }

  if (tmp.size != sizeof(tmp) ||
      tmp.version != Version1_2 ||
      tmp.magic != Drtcsp_ST_Driver_Magic) {
    printf(MODULE "!test:%d: Drtcsp_ST_Driver_Magic: corrupt\n", __LINE__);
    retval = __LINE__;
    goto err_ret;
  }

  memset(&tmp, 0, sizeof(tmp));
  printf(MODULE "!test:OK\n");
  retval = 0;
    
 err_ret:;

  if (hSessionKey) {
    uCSP->DestroyKey(uCSP, hProv, hSessionKey);
  }

  if (hDrvKey) {
    uCSP->DestroyKey(uCSP, hProv, hDrvKey);
  }

  if (hDrvHash) {
    uCSP->DestroyKey(uCSP, hProv, hDrvHash);
  }

  if (hProv) {
    uCSP->ReleaseContext(uCSP, hProv, 0);
  }

  memset(&tmp, 0, sizeof(tmp));
  memset(&buf, 0, sizeof(buf));
  memset(bShiftedDataHolder, 0, sizeof(bShiftedDataHolder));

  drtcsp_close(channel);

  return retval;
}
#ifndef USE_STD_MM
static DWORD lfmmInitMemory(LPCPC_MEMORY_ARENA * pArena, mem_block * blk,DWORD maxContexts)
{
	CPC_LFMM_CONFIG Config;
	LONG PoolSizes[16];
	HRESULT code;
	memset (PoolSizes, 0, sizeof(PoolSizes));
	PoolSizes [MP_WORK] += 10000 * (250 + maxContexts); 
	PoolSizes [MP_BIG] += 10000 * (250 + maxContexts); 
	PoolSizes [MP_PRIME_M] += 1024 * (400 + maxContexts); 
	PoolSizes [MP_SEC_M] = 1024 * (400 + maxContexts); 
	PoolSizes [MP_WORK_M] += 2 * 1024 * (400 + maxContexts);
	memset (&Config,0, sizeof(Config));
	Config.fSMP=TRUE;
	Config.Size=0;
	Config.Buffer=NULL;
	Config.PoolSizes=PoolSizes;
	Config.nPools=16;
	Config.nCPUs=1;
	blk->buffer=NULL;
	blk->size=0;
	code=CPCInitMemoryLF(pArena,&Config);
	if (code != NTE_NO_MEMORY)
		return NTE_FAIL; 
        Config.Buffer= malloc(Config.Size); /* may sleep on request */
    
	if(!Config.Buffer)
	{
		printf(MODNAME ": %s: %d: Too big memory alloc %x\n",
		   __func__, __LINE__, Config.Size);
		return NTE_NO_MEMORY;
	}
	
	blk->buffer=Config.Buffer;
	blk->size=Config.Size;
	code=CPCInitMemoryLF(pArena,&Config);
	if (code!=S_OK)
	{
	  free(Config.Buffer);
	  blk->buffer=NULL;
	  blk->size=0;
	  return code;
	}
	return S_OK;
}
static void drtcsp_lfmmDoneMemory(mem_block *blk)
{
  if (blk->buffer && blk->size)
    free(blk->buffer);
}


#endif
extern "C" {
static inline pthread_rwlock_t *
cpc_rwlock_imp(LPCPC_RWLOCK pSection)
{
    return (pthread_rwlock_t *)pSection->dummy;
}

static inline DWORD CPCAPI
rwlock_init(LPCPC_RWLOCK pSection, DWORD cbSection, LPVOID lpArg)
{
    UNUSED(cbSection);
    UNUSED(lpArg);

    if((sizeof(*pSection) > cbSection) |
       (sizeof(pthread_rwlock_t) > sizeof(pSection->dummy))) {
	return (DWORD)NTE_NO_MEMORY;
    }
    pthread_rwlock_init(cpc_rwlock_imp(pSection), NULL);

    return S_OK;
}

static inline VOID CPCAPI
rwlock_destroy(LPCPC_RWLOCK pSection)
{
    pthread_rwlock_destroy(cpc_rwlock_imp(pSection));
}

static inline VOID CPCAPI
rwlock_wrlock(LPCPC_RWLOCK pSection)
{
    pthread_rwlock_wrlock(cpc_rwlock_imp(pSection));
}

static inline VOID CPCAPI
rwlock_rdlock(LPCPC_RWLOCK pSection)
{
    pthread_rwlock_rdlock(cpc_rwlock_imp(pSection));
}

static inline VOID CPCAPI
rwlock_unlock(LPCPC_RWLOCK pSection)
{
    pthread_rwlock_unlock(cpc_rwlock_imp(pSection));
}
}
#define SET_LOCKS(cfg) {\
 (cfg).lockFuncs.rwlock_init=rwlock_init;\
 (cfg).lockFuncs.rwlock_destroy=rwlock_destroy;\
 (cfg).lockFuncs.rwlock_wrlock=rwlock_wrlock;\
 (cfg).lockFuncs.rwlock_rdlock=rwlock_rdlock;\
 (cfg).lockFuncs.rwlock_unlock=rwlock_unlock;}



extern int CPCAPI
prepare_config(LPCPC_CONFIG CSPConfig, mem_block * blk, int use_fastcode, int use_locks)
{
    CSPConfig->cbSize = sizeof(CPC_CONFIG);
    if(CPCGetDefaultConfig(CSPConfig,NULL) != S_OK)
	return NTE_FAIL;
    if (use_fastcode)
	CSPConfig->FuncStruct.UsesFunctions = CPC_FAST_CODE_DEFAULT;
#ifdef USE_STD_MM
    UNUSED(blk);
    if(stdInitMemory(&CSPConfig->pArena, NULL, 0)) {
      return NTE_NO_MEMORY;
    }
#else
    if(lfmmInitMemory(&CSPConfig->pArena, blk, MAXCONTEXTS)) {
      return NTE_NO_MEMORY;
    }
#endif    
    CSPConfig->logConfig.name=_TEXT(MODNAME);
    if (use_locks)
	    SET_LOCKS(*CSPConfig);
    return S_OK;
}

extern int CPCAPI
remove_config(LPCPC_CONFIG CSPConfig, mem_block * blk)
{
  UNUSED(CSPConfig);
#ifdef USE_STD_MM
  UNUSED(blk);
#else
  drtcsp_lfmmDoneMemory(blk);
#endif  
   return S_OK;
}


int
main(int argc, char ** argv)
{
  int retval=0;
  int data_shift = 0;
  char stack_eater[3000]; /* 1850 and more crashes in release (rh7.3) */
  mem_block blk;

  UNUSED(stack_eater);
  init_hook();
  int channel=(argc==1)?0:atoi(argv[1]);

#ifdef CSP_LITE
  CPC_CONFIG CSPConfig;

  if(CPCGetDefaultConfig(&CSPConfig, NULL) != S_OK)
    return 1;
#ifdef USE_STD_MM
  UNUSED(blk);
  if(stdInitMemory(&CSPConfig.pArena, NULL, 0)) {
    return 1;
  }
#else
  if(lfmmInitMemory(&CSPConfig.pArena, &blk,MAXCONTEXTS)) {
    return 1;
  }
#endif
  CSPConfig.logConfig.name=DTEXT("drtcsp_u");

  if(CPCCreateProvider(&uCSP, &CSPConfig) || !uCSP){
    printf("Failed to load user CSP.\n");
    return 1;
  }
#else /* CSP_LITE */
  if(CPC2CryptCreateProvider(&uCSP, NULL) || !uCSP){
    printf("Failed to load user CSP.\n");
    return 1;
  }
#endif /* CSP_LITE */

  /* Set stack size, because kernel has very hard limits on it... */
  /* In linux it is from 4k to 8k, effective size is less by about 1.5k */
  /* http://seclists.org/linux-kernel/2002/Aug/6531.html */
  {
    struct rlimit rl;
    rl.rlim_cur=4096;
    rl.rlim_max=rl.rlim_cur;
#ifndef FREEBSD // It doesn't work well with FreeBSD.
//    if(setrlimit(RLIMIT_STACK, &rl)) perror("serlimit");
#endif
  }

  for (data_shift = 0; data_shift <= MAX_SHIFT; data_shift += STEP_SHIFT){
    printf("\nshift=%d ", data_shift);
    retval = retval ? retval : TEST_dmntcs_drtcsp(channel, data_shift);
  }

  uCSP->DestroyProvider(uCSP);

#ifndef USE_STD_MM
  drtcsp_lfmmDoneMemory(&blk);
#endif

  fini_hook();

  return retval;
}

/*
 *   drtcsp, 
 */
#ifndef SOLARIS
typedef enum uio_rw { UIO_READ, UIO_WRITE } uio_rw_t;
#endif

int
drtcsp_attach(int channel)
{
  PDRTCSP pdrtcsp=&channels[channel];  
  memset(pdrtcsp,0,sizeof(*pdrtcsp));
  pdrtcsp->size = sizeof(*pdrtcsp);
  pdrtcsp->minor=channel;
  pdrtcsp->state = DRTCSP_ATTACH;
  return 0;
}

#if 0
int
drtcsp_detach(int channel)
{
  PDRTCSP pdrtcsp=&channels[channel];
  return detach_hook(pdrtcsp);
}
#endif

int
drtcsp_open(int channel)
{
  PDRTCSP pdrtcsp=&channels[channel];
  return open_hook(pdrtcsp);
}

int
drtcsp_close(int channel)
{
  PDRTCSP pdrtcsp=&channels[channel];
  return close_hook(pdrtcsp);
}

int
drtcsp_ioctl_DRTCSP_DRIVER_RNG(int channel, DRTCSP_DRIVER_KEY *ptmp)
{
  PDRTCSP pdrtcsp=&channels[channel];
  return set_driver_rng(pdrtcsp, ptmp);
}

int
drtcsp_ioctl_DRTCSP_SESSION_KEY(int channel, DRTCSP_DRIVER_KEY *ptmp)
{
  PDRTCSP pdrtcsp=&channels[channel];
  return set_session_key(pdrtcsp, ptmp);
}

int
drtcsp_ioctl_DRTCSP_SELFTEST(int channel, DRTCSP_DRIVER_KEY *ptmp)
{
  PDRTCSP pdrtcsp=&channels[channel];
  return kernel_selftest(pdrtcsp, ptmp);
}


int
trans(unsigned char *data, size_t len, int dir, void *arg)
{
  char **d1=(char**)arg;

  if(dir == FROM_KERNEL)
    memcpy(*d1, data, len);
  else
    memcpy(data, *d1, len);
  *d1+=len;

  return 0;
}

int
drtcsp_read(int channel,BYTE *data, size_t resid)
{
  int r=(int)resid;
  BYTE *tmp=data;
  PDRTCSP pdrtcsp=&channels[channel];

  return read_hook(pdrtcsp, &r, (void*)&tmp)?-1:(int)resid;
}

int
drtcsp_write(int channel,BYTE *data, size_t resid)
{
  int r=(int)resid;
  BYTE *tmp=data;
  PDRTCSP pdrtcsp=&channels[channel];

  return write_hook(pdrtcsp, &r, (void*)&tmp)?-1:(int)resid;
}
