#pragma warning(disable:4996)

#include <iterator>
#include <vector>
#include <iostream>
#include <wchar.h>
#include <cstdlib>

#ifdef _WIN32
#include <tchar.h>
#else
#include <cstdio>
#include "reader/tchar.h"
#endif

#include "cades.h"

/*
   CADES_BES  CADES_X_LONG_TYPE_1       SDK.
       sign.dat ( LowlevelSignCadesBes, SimplifiedSignCadesBes). 
  OCSP     . sign.dat     .
*/

using namespace std;

#include "../samples_util.h"

int main(void) {
    vector<unsigned char> message;
    //    
    if (ReadFileToVector("sign.dat", message)) {
        cout << "Reading signature from file \"sign.dat\" failed" << endl;
        return -1;
    }

    if (message.empty()) {
        cout << "File \"sign.dat\" is empty. Nothing to enhance" << endl;
        return -1;
    }

    //         
    HCRYPTMSG hMsg = CryptMsgOpenToDecode(X509_ASN_ENCODING | PKCS_7_ASN_ENCODING, 0, 0, 0, 0, 0);
    if (!hMsg) {
        cout << "CryptMsgOpenToDecode() failed" << endl;
        return -1;
    }

    //     
    if (!CryptMsgUpdate(hMsg, &message[0], (unsigned long) message.size(), TRUE)) {
        CryptMsgClose(hMsg);
        cout << "CryptMsgUpdate() failed" << endl;
        return -1;
    }

    //   CADES_BES  CADES_X_LONG_TYPE_1
    CADES_SERVICE_CONNECTION_PARA tspConnectionPara = {sizeof(tspConnectionPara)};
    tspConnectionPara.wszUri = SERVICE_URL_2012; //   -     

    CADES_SIGN_PARA cadesSignPara = {sizeof(cadesSignPara)};
    cadesSignPara.dwCadesType = CADES_X_LONG_TYPE_1; //     CADES_X_LONG_TYPE_1
    cadesSignPara.pTspConnectionPara = &tspConnectionPara;

    //  ,    CADES_BES,    CADES_X_LONG_TYPE_1
    if (!CadesMsgEnhanceSignature(hMsg, 0, &cadesSignPara)) {
        CryptMsgClose(hMsg);
        cout << "CadesMsgEnhanceSignature() failed" << endl;
        return -1;
    }

    DWORD size = 0;
    //   
    if (!CryptMsgGetParam(hMsg, CMSG_ENCODED_MESSAGE, 0, 0, &size)) {
        CryptMsgClose(hMsg);
        cout << "CryptMsgGetParam() failed" << endl;
        return -1;
    }

    message.resize(size);
    //    
    if (!CryptMsgGetParam(hMsg, CMSG_ENCODED_MESSAGE, 0, &message[0], &size)) {
        CryptMsgClose(hMsg);
        cout << "CryptMsgGetParam() failed" << endl;
        return -1;
    }
    message.resize(size);

    //   
    if (!CryptMsgClose(hMsg)) {
        cout << "CryptMsgClose() failed" << endl;
        return -1;
    }

    //    
    if (SaveVectorToFile<unsigned char>("adv_sign.dat", message)) {
        cout << "Signature was not saved" << endl;
        return -1;
    }

    cout << "Signature was enhanced successfully." << endl;

    return 0;
}
