#ifndef CPPCADES_CP_HASHEDDATA_OBJECT_H_
#define CPPCADES_CP_HASHEDDATA_OBJECT_H_

#include "cppcades.h"
#include "cplib/Blob.h"
#include "CPPCadesContent.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPHashedDataObject
{
public:
    static const int DEFAULT_KEY_LENGTH = 64;
    static const int MIN_KEY_LENGTH = 32;

    CPPCadesCPHashedDataObject(void);
    ~CPPCadesCPHashedDataObject(void);

    //     .   .
    HRESULT get_Value(CAtlString& pVal); 
#ifndef UNIX
    HRESULT put_Hash(const BSTR pVal);
#endif // !UNIX
    HRESULT put_Hash(LPCSTR pbData, DWORD cbData);
    //       
    HRESULT put_HashValue(const CAtlString& pVal);
    HRESULT put_Key(const CAtlString& pVal);
    HRESULT get_Key(CAtlString& pVal);
    HRESULT put_Algorithm(CAPICOM_HASH_ALGORITHM pVal);
    HRESULT get_Algorithm(CAPICOM_HASH_ALGORITHM* pVal);
    HRESULT put_DataEncoding(CADESCOM_CONTENT_ENCODING_TYPE EncodingType);
    HRESULT get_DataEncoding(CADESCOM_CONTENT_ENCODING_TYPE* pVal);

    //internal use
    HRESULT InitHash();
    HRESULT CalculateHash();
    HRESULT get_BlobValue(CBlob& pVal); 
    void ResetState();
    ALG_ID get_AlgId();
    CAtlStringA& get_HashAlgOID();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPHashedDataObject);

    CAPICOM_HASH_ALGORITHM m_alg;
    CCadesContent m_currentDataBlock;
    ALG_ID m_algID;
    CAtlStringA m_algStr;
    CCryptProv m_cryptProv;
    CCryptHashEx m_cryptHash;
    CBlob m_valueBlob;
    CBlob m_keyBlob;
    CCryptKey m_cryptKey;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_HASHEDDATA_OBJECT_H_

